/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.remote.MockRemoteCacheService;
import org.apache.commons.jcs.auxiliary.remote.http.server.RemoteHttpCacheServlet;
import org.apache.commons.jcs.auxiliary.remote.util.RemoteCacheRequestFactory;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.commons.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.behavior.ICacheElement;

public class RemoteHttpCacheServletUnitTest
extends TestCase {
    private RemoteHttpCacheServlet servlet;
    private MockRemoteCacheService<Serializable, Serializable> remoteHttpCacheService;

    protected void setUp() throws Exception {
        super.setUp();
        this.servlet = new RemoteHttpCacheServlet();
        this.servlet.init(null);
        this.remoteHttpCacheService = new MockRemoteCacheService();
        this.servlet.setRemoteCacheService(this.remoteHttpCacheService);
    }

    protected void tearDown() throws Exception {
        this.servlet.destroy();
        super.tearDown();
    }

    public void testProcessRequest_null() {
        RemoteCacheRequest request = null;
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertTrue((String)"Should have 'The request is null' in the errorMessage", (result.getErrorMessage().indexOf("The request is null") != -1 ? 1 : 0) != 0);
        RemoteHttpCacheServletUnitTest.assertTrue((String)"Should have 'The request is null' in the toString", (result.toString().indexOf("The request is null") != -1 ? 1 : 0) != 0);
    }

    public void testProcessRequest_Get() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        RemoteCacheRequest request = RemoteCacheRequestFactory.createGetRequest((String)cacheName, (Object)key, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong key.", (Object)key, this.remoteHttpCacheService.lastGetKey);
    }

    public void testProcessRequest_GetMatching() {
        String cacheName = "test";
        String pattern = "pattern";
        long requesterId = 2L;
        RemoteCacheRequest request = RemoteCacheRequestFactory.createGetMatchingRequest((String)cacheName, (String)pattern, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong pattern.", (String)pattern, (String)this.remoteHttpCacheService.lastGetMatchingPattern);
    }

    public void testProcessRequest_GetMultiple() {
        String cacheName = "test";
        Set keys = Collections.emptySet();
        long requesterId = 2L;
        RemoteCacheRequest request = RemoteCacheRequestFactory.createGetMultipleRequest((String)cacheName, keys, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong keys.", keys, this.remoteHttpCacheService.lastGetMultipleKeys);
    }

    public void testProcessRequest_Update() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        CacheElement element = new CacheElement(cacheName, (Object)key, null);
        RemoteCacheRequest request = RemoteCacheRequestFactory.createUpdateRequest((ICacheElement)element, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong object.", (Object)element, this.remoteHttpCacheService.lastUpdate);
    }

    public void testProcessRequest_Remove() {
        String cacheName = "test";
        String key = "key";
        long requesterId = 2L;
        RemoteCacheRequest request = RemoteCacheRequestFactory.createRemoveRequest((String)cacheName, (Object)key, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong key.", (Object)key, this.remoteHttpCacheService.lastRemoveKey);
    }

    public void testProcessRequest_RemoveAll() {
        String cacheName = "testRemoveALl";
        long requesterId = 2L;
        RemoteCacheRequest request = RemoteCacheRequestFactory.createRemoveAllRequest((String)cacheName, (long)requesterId);
        RemoteCacheResponse result = this.servlet.processRequest(request);
        RemoteHttpCacheServletUnitTest.assertNotNull((String)"Should have a result.", (Object)result);
        RemoteHttpCacheServletUnitTest.assertEquals((String)"Wrong cacheName.", (String)cacheName, (String)this.remoteHttpCacheService.lastRemoveAllCacheName);
    }
}

