/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import junit.framework.AssertionFailedError;
import org.apache.commons.jcs.auxiliary.MockCacheEventLogger;
import org.apache.commons.jcs.auxiliary.remote.MockRemoteCacheListener;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheFactory;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.commons.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerStartupUtil;
import org.apache.commons.jcs.engine.CacheElement;
import org.apache.commons.jcs.engine.CacheStatus;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.control.MockCompositeCacheManager;
import org.apache.commons.jcs.engine.control.MockElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.jcs.utils.timing.SleepUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class BasicRemoteCacheClientServerUnitTest
extends Assert {
    private static final int LOCAL_PORT = 12020;
    private static RemoteCacheServer<String, String> server = null;
    private static RemoteCacheFactory factory = null;
    private static int remotePort;

    @BeforeClass
    public static void setup() {
        try {
            InetAddress lh = InetAddress.getByName("localhost");
            System.out.println("localhost=" + lh);
            InetAddress ina = InetAddress.getLocalHost();
            System.out.println("InetAddress.getLocalHost()=" + ina);
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    boolean loopbackAddress = inetAddr.isLoopbackAddress();
                    boolean siteLocalAddress = inetAddr.isSiteLocalAddress();
                    System.out.println("Found: " + inetAddr + " isLoopback: " + loopbackAddress + " isSiteLocal: " + siteLocalAddress + (!loopbackAddress && siteLocalAddress ? " *" : ""));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String configFile = "TestRemoteCacheClientServer.ccf";
        server = RemoteCacheServerStartupUtil.startServerUsingProperties(configFile);
        factory = new RemoteCacheFactory();
        factory.initialize();
        remotePort = BasicRemoteCacheClientServerUnitTest.server.remoteCacheServerAttributes.getRemoteLocation().getPort();
    }

    @AfterClass
    public static void stop() throws IOException {
        if (server != null) {
            server.shutdown("localhost", remotePort);
        }
        File jcsLog = new File("target/jcs.log");
        File logSave = new File("target/BasicRemoteCacheClientServerUnitTest_jcs.log");
        System.out.println("Renamed log file? " + jcsLog.renameTo(logSave));
    }

    @Test
    public void test1SinglePut() throws Exception {
        MockCompositeCacheManager compositeCacheManager = new MockCompositeCacheManager();
        RemoteCacheAttributes attributes = new RemoteCacheAttributes();
        attributes.setRemoteLocation("localhost", remotePort);
        attributes.setLocalPort(12020);
        attributes.setCacheName("testSinglePut");
        RemoteCacheManager remoteCacheManager = factory.getManager((IRemoteCacheAttributes)attributes, (ICompositeCacheManager)compositeCacheManager, (ICacheEventLogger)new MockCacheEventLogger(), (IElementSerializer)new MockElementSerializer());
        RemoteCacheNoWait cache = remoteCacheManager.getCache((IRemoteCacheAttributes)attributes);
        int numPutsPrior = server.getPutCount();
        CacheElement element = new CacheElement(cache.getCacheName(), (Object)"key", (Object)"value");
        cache.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(200L);
        try {
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Cache is alive", (Object)CacheStatus.ALIVE, (Object)cache.getStatus());
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts", (long)1L, (long)(server.getPutCount() - numPutsPrior));
        }
        catch (AssertionFailedError e) {
            System.out.println(cache.getStats());
            System.out.println(server.getStats());
            throw e;
        }
        ICacheElement result = cache.get((Object)"key");
        BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong element.", (Object)element.getVal(), (Object)result.getVal());
    }

    @Test
    public void test2PutRemove() throws Exception {
        MockCompositeCacheManager compositeCacheManager = new MockCompositeCacheManager();
        RemoteCacheAttributes attributes = new RemoteCacheAttributes();
        attributes.setRemoteLocation("localhost", remotePort);
        attributes.setLocalPort(12020);
        attributes.setCacheName("testPutRemove");
        MockCacheEventLogger cacheEventLogger = new MockCacheEventLogger();
        RemoteCacheManager remoteCacheManager = factory.getManager((IRemoteCacheAttributes)attributes, (ICompositeCacheManager)compositeCacheManager, (ICacheEventLogger)cacheEventLogger, null);
        RemoteCacheNoWait cache = remoteCacheManager.getCache((IRemoteCacheAttributes)attributes);
        int numPutsPrior = server.getPutCount();
        CacheElement element = new CacheElement(cache.getCacheName(), (Object)"key", (Object)"value");
        cache.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(50L);
        try {
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Cache is alive", (Object)CacheStatus.ALIVE, (Object)cache.getStatus());
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts", (long)1L, (long)(server.getPutCount() - numPutsPrior));
        }
        catch (AssertionFailedError e) {
            System.out.println(cache.getStats());
            System.out.println(server.getStats());
            throw e;
        }
        ICacheElement result = cache.get((Object)"key");
        BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong element.", (Object)element.getVal(), (Object)result.getVal());
        cache.remove((Object)"key");
        SleepUtil.sleepAtLeast(200L);
        ICacheElement resultAfterRemote = cache.get((Object)"key");
        BasicRemoteCacheClientServerUnitTest.assertNull((String)"Element resultAfterRemote should be null.", (Object)resultAfterRemote);
    }

    @Test
    public void test3PutAndListen() throws Exception {
        MockCompositeCacheManager compositeCacheManager = new MockCompositeCacheManager();
        RemoteCacheAttributes attributes = new RemoteCacheAttributes();
        attributes.setRemoteLocation("localhost", remotePort);
        attributes.setLocalPort(12020);
        attributes.setCacheName("testPutAndListen");
        RemoteCacheManager remoteCacheManager = factory.getManager((IRemoteCacheAttributes)attributes, (ICompositeCacheManager)compositeCacheManager, (ICacheEventLogger)new MockCacheEventLogger(), (IElementSerializer)new MockElementSerializer());
        RemoteCacheNoWait cache = remoteCacheManager.getCache((IRemoteCacheAttributes)attributes);
        MockRemoteCacheListener listener = new MockRemoteCacheListener();
        server.addCacheListener(cache.getCacheName(), listener);
        int numPutsPrior = server.getPutCount();
        CacheElement element = new CacheElement(cache.getCacheName(), (Object)"key", (Object)"value");
        cache.update((ICacheElement)element);
        SleepUtil.sleepAtLeast(50L);
        try {
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Cache is alive", (Object)CacheStatus.ALIVE, (Object)cache.getStatus());
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts", (long)1L, (long)(server.getPutCount() - numPutsPrior));
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts to listener.", (long)1L, (long)listener.putCount);
        }
        catch (AssertionFailedError e) {
            System.out.println(cache.getStats());
            System.out.println(server.getStats());
            throw e;
        }
        finally {
            server.removeCacheListener(listener);
        }
    }

    @Test
    public void test4PutaMultipleAndListen() throws Exception {
        MockCompositeCacheManager compositeCacheManager = new MockCompositeCacheManager();
        RemoteCacheAttributes attributes = new RemoteCacheAttributes();
        attributes.setRemoteLocation("localhost", remotePort);
        attributes.setLocalPort(12020);
        attributes.setCacheName("testPutaMultipleAndListen");
        RemoteCacheManager remoteCacheManager = factory.getManager((IRemoteCacheAttributes)attributes, (ICompositeCacheManager)compositeCacheManager, (ICacheEventLogger)new MockCacheEventLogger(), (IElementSerializer)new MockElementSerializer());
        RemoteCacheNoWait cache = remoteCacheManager.getCache((IRemoteCacheAttributes)attributes);
        MockRemoteCacheListener listener = new MockRemoteCacheListener();
        server.addCacheListener(cache.getCacheName(), listener);
        int numPutsPrior = server.getPutCount();
        int numToPut = 100;
        for (int i = 0; i < numToPut; ++i) {
            CacheElement element = new CacheElement(cache.getCacheName(), (Object)"key1", (Object)("value" + i));
            cache.update((ICacheElement)element);
        }
        SleepUtil.sleepAtLeast(500L);
        try {
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Cache is alive", (Object)CacheStatus.ALIVE, (Object)cache.getStatus());
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts", (long)numToPut, (long)(server.getPutCount() - numPutsPrior));
            BasicRemoteCacheClientServerUnitTest.assertEquals((String)"Wrong number of puts to listener.", (long)numToPut, (long)listener.putCount);
        }
        catch (AssertionFailedError e) {
            System.out.println(cache.getStats());
            System.out.println(server.getStats());
            throw e;
        }
    }

    @Test
    public void testLocalHost() throws Exception {
        InetAddress byName = InetAddress.getByName("localhost");
        BasicRemoteCacheClientServerUnitTest.assertTrue((String)("Expected localhost (" + byName.getHostAddress() + ") to be a loopback address"), (boolean)byName.isLoopbackAddress());
        InetAddress localHost = HostNameUtil.getLocalHostLANAddress();
        BasicRemoteCacheClientServerUnitTest.assertTrue((String)("Expected getLocalHostLANAddress() (" + localHost + ") to return a site local address"), (boolean)localHost.isSiteLocalAddress());
    }
}

