/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.rmi.server.RMISocketFactory;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.commons.jcs.auxiliary.remote.server.MockRMISocketFactory;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.auxiliary.remote.server.TimeoutConfigurableRMISocketFactory;

public class RemoteCacheServerFactoryUnitTest
extends TestCase {
    public void testConfigureRemoteCacheServerAttributes_eventQueuePoolName() {
        String eventQueuePoolName = "specialName";
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.EventQueuePoolName", eventQueuePoolName);
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong eventQueuePoolName", (String)eventQueuePoolName, (String)result.getEventQueuePoolName());
    }

    public void testConfigureRemoteCacheServerAttributes_timeoutPresent() {
        int timeout = 123245;
        Properties props = new Properties();
        props.put("remote.cache.rmiSocketFactoryTimeoutMillis", String.valueOf(timeout));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong timeout", (int)timeout, (int)result.getRmiSocketFactoryTimeoutMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_timeoutNotPresent() {
        Properties props = new Properties();
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong timeout", (int)10000, (int)result.getRmiSocketFactoryTimeoutMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_registryKeepAliveDelayMillisPresent() {
        int registryKeepAliveDelayMillis = 123245;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.registryKeepAliveDelayMillis", String.valueOf(registryKeepAliveDelayMillis));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong registryKeepAliveDelayMillis", (long)registryKeepAliveDelayMillis, (long)result.getRegistryKeepAliveDelayMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_useRegistryKeepAlivePresent() {
        boolean useRegistryKeepAlive = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.useRegistryKeepAlive", String.valueOf(useRegistryKeepAlive));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong useRegistryKeepAlive", (boolean)useRegistryKeepAlive, (boolean)result.isUseRegistryKeepAlive());
    }

    public void testConfigureRemoteCacheServerAttributes_rmiSocketFactoryTimeoutMillisPresent() {
        int rmiSocketFactoryTimeoutMillis = 123245;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.rmiSocketFactoryTimeoutMillis", String.valueOf(rmiSocketFactoryTimeoutMillis));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong rmiSocketFactoryTimeoutMillis", (int)rmiSocketFactoryTimeoutMillis, (int)result.getRmiSocketFactoryTimeoutMillis());
    }

    public void testConfigureRemoteCacheServerAttributes_allowClusterGetPresent() {
        boolean allowClusterGet = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.allowClusterGet", String.valueOf(allowClusterGet));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong allowClusterGet", (boolean)allowClusterGet, (boolean)result.isAllowClusterGet());
    }

    public void testConfigureRemoteCacheServerAttributes_localClusterConsistencyPresent() {
        boolean localClusterConsistency = false;
        Properties props = new Properties();
        props.put("jcs.remotecache.serverattributes.localClusterConsistency", String.valueOf(localClusterConsistency));
        RemoteCacheServerAttributes result = RemoteCacheServerFactory.configureRemoteCacheServerAttributes((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong localClusterConsistency", (boolean)localClusterConsistency, (boolean)result.isLocalClusterConsistency());
    }

    public void testConfigureObjectSpecificCustomFactory_withProperty() {
        String testValue = "123245";
        Properties props = new Properties();
        props.put("jcs.remotecache.customrmisocketfactory", MockRMISocketFactory.class.getName());
        props.put("jcs.remotecache.customrmisocketfactory.testStringProperty", testValue);
        RMISocketFactory result = RemoteCacheServerFactory.configureObjectSpecificCustomFactory((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertNotNull((String)"Should have a custom socket factory.", (Object)result);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong testValue", (String)testValue, (String)((MockRMISocketFactory)result).getTestStringProperty());
    }

    public void testConfigureObjectSpecificCustomFactory_withProperty_TimeoutConfigurableRMIScoketFactory() {
        int readTimeout = 1234;
        int openTimeout = 1234;
        Properties props = new Properties();
        props.put("jcs.remotecache.customrmisocketfactory", TimeoutConfigurableRMISocketFactory.class.getName());
        props.put("jcs.remotecache.customrmisocketfactory.readTimeout", String.valueOf(readTimeout));
        props.put("jcs.remotecache.customrmisocketfactory.openTimeout", String.valueOf(openTimeout));
        RMISocketFactory result = RemoteCacheServerFactory.configureObjectSpecificCustomFactory((Properties)props);
        RemoteCacheServerFactoryUnitTest.assertNotNull((String)"Should have a custom socket factory.", (Object)result);
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong readTimeout", (int)readTimeout, (int)((TimeoutConfigurableRMISocketFactory)result).getReadTimeout());
        RemoteCacheServerFactoryUnitTest.assertEquals((String)"Wrong readTimeout", (int)openTimeout, (int)((TimeoutConfigurableRMISocketFactory)result).getOpenTimeout());
    }
}

