/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.commons.jcs.auxiliary.remote.RemoteUtils;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.commons.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs.utils.net.HostNameUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCacheServerStartupUtil {
    private static final Log log = LogFactory.getLog(RemoteCacheServerStartupUtil.class);
    private static final int DEFAULT_REGISTRY_PORT = 1101;

    public static <K, V> RemoteCacheServer<K, V> startServerUsingProperties(String propsFileName) {
        int registryPort = 1101;
        Properties props = null;
        try {
            props = RemoteUtils.loadProps((String)propsFileName);
        }
        catch (IOException e) {
            log.error((Object)("Problem loading configuration from " + propsFileName), (Throwable)e);
        }
        if (props != null) {
            String portS = props.getProperty("registry.port", String.valueOf(1101));
            try {
                registryPort = Integer.parseInt(portS);
            }
            catch (NumberFormatException e) {
                log.error((Object)"Problem converting port to an int.", (Throwable)e);
            }
        }
        try {
            String registryHost = HostNameUtil.getLocalHostAddress();
            if (log.isDebugEnabled()) {
                log.debug((Object)("registryHost = [" + registryHost + "]"));
            }
            if ("localhost".equals(registryHost) || "127.0.0.1".equals(registryHost)) {
                log.warn((Object)("The local address [" + registryHost + "] is INVALID.  Other machines must be able to use the address to reach this server."));
            }
            try {
                RemoteCacheServerFactory.startup((String)registryHost, (int)registryPort, (Properties)props);
            }
            catch (IOException e) {
                log.error((Object)"Problem starting remote cache server.", (Throwable)e);
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"Could not get local address to use for the registry!", (Throwable)e);
        }
        return RemoteCacheServerFactory.getRemoteCacheServer();
    }
}

