/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.match;

import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.jcs.engine.match.KeyMatcherPatternImpl;

public class KeyMatcherPatternImpllUnitTest
extends TestCase {
    public void testGetMatchingKeysFromArray_AllMatch() {
        int numToInsertPrefix1 = 10;
        HashSet<String> keyArray = new HashSet<String>();
        String keyprefix1 = "MyPrefixC";
        for (int i = 0; i < numToInsertPrefix1; ++i) {
            keyArray.add(keyprefix1 + String.valueOf(i));
        }
        KeyMatcherPatternImpl keyMatcher = new KeyMatcherPatternImpl();
        Set result1 = keyMatcher.getMatchingKeysFromArray(keyprefix1 + ".", keyArray);
        KeyMatcherPatternImpllUnitTest.assertEquals((String)("Wrong number returned 1: " + result1), (int)numToInsertPrefix1, (int)result1.size());
    }

    public void testGetMatchingKeysFromArray_AllMatchFirstNull() {
        int numToInsertPrefix1 = 10;
        HashSet<String> keyArray = new HashSet<String>();
        String keyprefix1 = "MyPrefixC";
        for (int i = 1; i < numToInsertPrefix1 + 1; ++i) {
            keyArray.add(keyprefix1 + String.valueOf(i));
        }
        KeyMatcherPatternImpl keyMatcher = new KeyMatcherPatternImpl();
        Set result1 = keyMatcher.getMatchingKeysFromArray(keyprefix1 + "\\S+", keyArray);
        KeyMatcherPatternImpllUnitTest.assertEquals((String)("Wrong number returned 1: " + result1), (int)numToInsertPrefix1, (int)result1.size());
    }

    public void testGetMatchingKeysFromArray_TwoTypes() {
        int i;
        int numToInsertPrefix1 = 10;
        int numToInsertPrefix2 = 50;
        HashSet<String> keyArray = new HashSet<String>();
        String keyprefix1 = "MyPrefixA";
        String keyprefix2 = "MyPrefixB";
        for (i = 0; i < numToInsertPrefix1; ++i) {
            keyArray.add(keyprefix1 + String.valueOf(i));
        }
        for (i = numToInsertPrefix1; i < numToInsertPrefix2 + numToInsertPrefix1; ++i) {
            keyArray.add(keyprefix2 + String.valueOf(i));
        }
        KeyMatcherPatternImpl keyMatcher = new KeyMatcherPatternImpl();
        Set result1 = keyMatcher.getMatchingKeysFromArray(keyprefix1 + ".+", keyArray);
        Set result2 = keyMatcher.getMatchingKeysFromArray(keyprefix2 + ".+", keyArray);
        KeyMatcherPatternImpllUnitTest.assertEquals((String)("Wrong number returned 1: " + result1), (int)numToInsertPrefix1, (int)result1.size());
        KeyMatcherPatternImpllUnitTest.assertEquals((String)("Wrong number returned 2: " + result2), (int)numToInsertPrefix2, (int)result2.size());
    }
}

