/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.utils.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import junit.framework.TestCase;
import org.apache.commons.jcs.utils.zip.CompressionUtil;

public class CompressionUtilUnitTest
extends TestCase {
    public final void testDecompressByteArray_failure() {
        try {
            CompressionUtil.decompressByteArray(null);
            CompressionUtilUnitTest.fail((String)"excepted an IllegalArgumentException");
        }
        catch (IllegalArgumentException exception) {
            return;
        }
    }

    public final void testCompressDecompressByteArray_success() throws IOException {
        String text = "This is some text to compress, not a lot, just a bit ";
        byte[] compressedText = CompressionUtil.compressByteArray((byte[])text.getBytes());
        byte[] output = CompressionUtil.decompressByteArray((byte[])compressedText);
        String result = new String(output);
        CompressionUtilUnitTest.assertNotNull((String)"decompressed output stream shouldn't have been null ", (Object)output);
        CompressionUtilUnitTest.assertEquals((String)text, (String)result);
    }

    public final void testCompressDecompressGzipByteArray_success() throws IOException {
        String text = " This is some text to compress, not a lot, just a bit ";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        os.write(text.getBytes());
        os.flush();
        os.close();
        byte[] output = CompressionUtil.decompressGzipByteArray((byte[])baos.toByteArray());
        String result = new String(output);
        CompressionUtilUnitTest.assertNotNull((String)"decompressed output stream shouldn't have been null ", (Object)output);
        CompressionUtilUnitTest.assertEquals((String)text, (String)result);
    }
}

