/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class LateralCacheNoWaitFacade
implements AuxiliaryCache {
    private static final long serialVersionUID = -9047687810358008955L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWaitFacade == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWaitFacade = LateralCacheNoWaitFacade.class$("org.apache.jcs.auxiliary.lateral.LateralCacheNoWaitFacade")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWaitFacade));
    public LateralCacheNoWait[] noWaits;
    private String cacheName;
    private ILateralCacheAttributes lateralCacheAttributes;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWaitFacade;

    public LateralCacheNoWaitFacade(LateralCacheNoWait[] noWaits, ILateralCacheAttributes cattr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"CONSTRUCTING NO WAIT FACADE");
        }
        this.noWaits = noWaits;
        this.cacheName = cattr.getCacheName();
        this.lateralCacheAttributes = cattr;
    }

    public boolean addNoWait(LateralCacheNoWait noWait) {
        if (noWait == null) {
            return false;
        }
        for (int i = 0; i < this.noWaits.length; ++i) {
            if (!noWait.equals(this.noWaits[i])) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("No Wait already contained, [" + noWait + "]"));
            }
            return false;
        }
        LateralCacheNoWait[] newArray = new LateralCacheNoWait[this.noWaits.length + 1];
        System.arraycopy(this.noWaits, 0, newArray, 0, this.noWaits.length);
        newArray[this.noWaits.length] = noWait;
        this.noWaits = newArray;
        return true;
    }

    public void update(ICacheElement ce) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating through lateral cache facade, noWaits.length = " + this.noWaits.length));
        }
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].update(ce);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public ICacheElement get(Serializable key) {
        int i = 0;
        if (i < this.noWaits.length) {
            try {
                ICacheElement obj = this.noWaits[i].get(key);
                if (obj != null) {
                    return obj;
                }
            }
            catch (Exception ex) {
                log.error((Object)"Failed to get", (Throwable)ex);
            }
            return null;
        }
        return null;
    }

    public Set getGroupKeys(String group) {
        HashSet allKeys = new HashSet();
        for (int i = 0; i < this.noWaits.length; ++i) {
            LateralCacheNoWait aux = this.noWaits[i];
            if (aux == null) continue;
            try {
                allKeys.addAll(aux.getGroupKeys(group));
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return allKeys;
    }

    public boolean remove(Serializable key) {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].remove(key);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        return false;
    }

    public void removeAll() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].removeAll();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public void dispose() {
        try {
            for (int i = 0; i < this.noWaits.length; ++i) {
                this.noWaits[i].dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public int getSize() {
        return 0;
    }

    public int getCacheType() {
        return 3;
    }

    public String getCacheName() {
        return "";
    }

    public int getStatus() {
        return 0;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.lateralCacheAttributes;
    }

    public String toString() {
        return "LateralCacheNoWaitFacade: " + this.cacheName;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait Facade");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        if (this.noWaits != null) {
            se = new StatElement();
            se.setName("Number of No Waits");
            se.setData("" + this.noWaits.length);
            elems.add(se);
            for (int i = 0; i < this.noWaits.length; ++i) {
                if (this.noWaits[i] == null) continue;
                IStats sStats = this.noWaits[i].getStatistics();
                IStatElement[] sSEs = sStats.getStatElements();
                List<IStatElement> sL = Arrays.asList(sSEs);
                elems.addAll(sL);
            }
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

