/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.test.xml;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.jelly.Jelly;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;

public class TestDefaultNamespaceFilter
extends TestCase {
    Jelly jelly = null;
    JellyContext context = null;
    XMLOutput xmlOutput = null;

    public TestDefaultNamespaceFilter(String name) {
        super(name);
    }

    public static TestSuite suite() throws Exception {
        return new TestSuite(TestDefaultNamespaceFilter.class);
    }

    public void setUp() throws Exception {
        this.context = new JellyContext();
        this.xmlOutput = XMLOutput.createXMLOutput((Writer)new StringWriter());
        this.jelly = new Jelly();
        String script = "nsFilterTest.jelly";
        URL url = ((Object)((Object)this)).getClass().getResource(script);
        if (url == null) {
            throw new Exception("Could not find Jelly script: " + script + " in package of class: " + ((Object)((Object)this)).getClass().getName());
        }
        this.jelly.setUrl(url);
    }

    public void testNamespaceDefined() throws Exception {
        this.jelly.setDefaultNamespaceURI("jelly:core");
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestDefaultNamespaceFilter.assertTrue((String)"should have set 'usedDefaultNamespace' variable", (this.context.getVariable("usedDefaultNamespace") != null ? 1 : 0) != 0);
    }

    public void testNamespaceNotDefined() throws Exception {
        Script script = this.jelly.compileScript();
        script.run(this.context, this.xmlOutput);
        TestDefaultNamespaceFilter.assertTrue((String)"should not have set 'usedDefaultNamespace' variable", (this.context.getVariable("usedDefaultNamespace") == null ? 1 : 0) != 0);
    }
}

