/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.servlet.JellyServletContext;

public class JellyServlet
extends HttpServlet {
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRequest(request, response);
    }

    protected void doRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        JellyContext context = this.createContext(req, res);
        try {
            URL script = this.getScript(req);
            this.runScript(script, context, req, res);
        }
        catch (Exception e) {
            this.error(req, res, e);
        }
    }

    protected JellyContext createContext(HttpServletRequest req, HttpServletResponse res) {
        JellyServletContext ctx = new JellyServletContext(this.getServletContext());
        ctx.setVariable(REQUEST, req);
        ctx.setVariable(RESPONSE, res);
        return ctx;
    }

    protected URL getScript(HttpServletRequest req) throws MalformedURLException {
        URL url;
        String scriptUrl = req.getParameter("script");
        if (scriptUrl == null) {
            scriptUrl = req.getPathInfo();
        }
        if ((url = this.getServletContext().getResource(scriptUrl)) == null) {
            throw new IllegalArgumentException("Invalid script url:" + scriptUrl);
        }
        return url;
    }

    protected void runScript(URL script, JellyContext context, HttpServletRequest req, HttpServletResponse res) throws IOException, UnsupportedEncodingException, JellyException {
        ServletOutputStream output = res.getOutputStream();
        XMLOutput xmlOutput = XMLOutput.createXMLOutput((OutputStream)output);
        context.runScript(script, xmlOutput);
        xmlOutput.flush();
        xmlOutput.close();
        output.flush();
    }

    protected void error(HttpServletRequest request, HttpServletResponse response, Exception cause) throws ServletException, IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<title>Error</title>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>JellyServlet : Error processing the script</h2>");
        html.append("<pre>");
        String why = cause.getMessage();
        if (why != null && why.trim().length() > 0) {
            html.append(why);
            html.append("<br>");
        }
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</pre>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }
}

