/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.Foo;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.junit.Asserter;

public class MethodTest
extends JexlTestCase {
    private Asserter asserter;
    private static final String METHOD_STRING = "Method string";

    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    public void testCallVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        this.asserter.assertExpression("test.callInts()", "Varargs:0");
        this.asserter.assertExpression("test.callInts(1)", "Varargs:1");
        this.asserter.assertExpression("test.callInts(1,2,3,4,5)", "Varargs:15");
    }

    public void testCallMixedVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        MethodTest.assertEquals((String)"Mixed:1", (String)test.callMixed(1, new Integer[0]));
        this.asserter.assertExpression("test.callMixed(1)", "Mixed:1");
        MethodTest.assertEquals((String)"Mixed:-999", (String)test.callMixed(1, (Integer[])null));
        this.asserter.assertExpression("test.callMixed(1, null)", "Mixed:-999");
        this.asserter.assertExpression("test.callMixed(1,2)", "Mixed:3");
        this.asserter.assertExpression("test.callMixed(1,2,3,4,5)", "Mixed:15");
    }

    public void testCallJexlVarArgMethod() throws Exception {
        VarArgs test = new VarArgs();
        this.asserter.setVariable("test", test);
        MethodTest.assertEquals((String)"jexl:0", (String)test.callMixed("jexl", new Integer[0]));
        this.asserter.assertExpression("test.callMixed('jexl')", "jexl:0");
        MethodTest.assertEquals((String)"jexl:-1000", (String)test.callMixed("jexl", (Integer[])null));
        this.asserter.assertExpression("test.callMixed('jexl', null)", "jexl:-1000");
        this.asserter.assertExpression("test.callMixed('jexl', 2)", "jexl:2");
        this.asserter.assertExpression("test.callMixed('jexl',2,3,4,5)", "jexl:14");
    }

    public void testInvoke() throws Exception {
        Functor func = new Functor();
        MethodTest.assertEquals((Object)10, (Object)this.JEXL.invokeMethod((Object)func, "ten", new Object[0]));
        MethodTest.assertEquals((Object)42, (Object)this.JEXL.invokeMethod((Object)func, "PLUS20", new Object[]{22}));
        try {
            this.JEXL.invokeMethod((Object)func, "nonExistentMethod", new Object[0]);
            MethodTest.fail((String)"method does not exist!");
        }
        catch (Exception xj0) {
            // empty catch block
        }
        try {
            this.JEXL.invokeMethod((Object)func, "NPEIfNull", (Object[])null);
            MethodTest.fail((String)"method should have thrown!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMethod() throws Exception {
        this.asserter.setVariable("foo", new Foo());
        this.asserter.assertExpression("foo.bar()", METHOD_STRING);
    }

    public void testMulti() throws Exception {
        this.asserter.setVariable("foo", new Foo());
        this.asserter.assertExpression("foo.innerFoo.bar()", METHOD_STRING);
    }

    public void testStringMethods() throws Exception {
        this.asserter.setVariable("foo", "abcdef");
        this.asserter.assertExpression("foo.substring(3)", "def");
        this.asserter.assertExpression("foo.substring(0,(size(foo)-3))", "abc");
        this.asserter.assertExpression("foo.substring(0,size(foo)-3)", "abc");
        this.asserter.assertExpression("foo.substring(0,foo.length()-3)", "abc");
        this.asserter.assertExpression("foo.substring(0, 1+1)", "ab");
    }

    public void testStaticMethodInvocation() throws Exception {
        this.asserter.setVariable("aBool", Boolean.FALSE);
        this.asserter.assertExpression("aBool.valueOf('true')", Boolean.TRUE);
    }

    public void testStaticMethodInvocationOnClasses() throws Exception {
        this.asserter.setVariable("Boolean", Boolean.class);
        this.asserter.assertExpression("Boolean.valueOf('true')", Boolean.TRUE);
    }

    public void testTopLevelCall() throws Exception {
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        funcs.put(null, new Functor());
        funcs.put("math", new MyMath());
        funcs.put("cx", ContextualFunctor.class);
        this.JEXL.setFunctions(funcs);
        EnhancedContext jc = new EnhancedContext();
        Expression e = this.JEXL.createExpression("ten()");
        Object o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        e = this.JEXL.createExpression("plus10(10)");
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("plus10(ten())");
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        jc.set("pi", new Double(Math.PI));
        e = this.JEXL.createExpression("math:cos(pi)");
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((Object)-1.0, (Object)o);
        e = this.JEXL.createExpression("cx:ratio(10) + cx:ratio(20)");
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((Object)7, (Object)o);
    }

    public void testNamespaceCall() throws Exception {
        HashMap<String, Object> funcs = new HashMap<String, Object>();
        funcs.put("func", new Functor());
        funcs.put("FUNC", Functor.class);
        this.JEXL.setFunctions(funcs);
        Expression e = this.JEXL.createExpression("func:ten()");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        e = this.JEXL.createExpression("func:plus10(10)");
        jc = new MapContext();
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("func:plus10(func:ten())");
        jc = new MapContext();
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 20", (Object)new Integer(20), (Object)o);
        e = this.JEXL.createExpression("FUNC:PLUS20(10)");
        jc = new MapContext();
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 30", (Object)new Integer(30), (Object)o);
        e = this.JEXL.createExpression("FUNC:PLUS20(FUNC:TWENTY())");
        jc = new MapContext();
        o = e.evaluate((JexlContext)jc);
        MethodTest.assertEquals((String)"Result is not 40", (Object)new Integer(40), (Object)o);
    }

    public void testScriptCall() throws Exception {
        MapContext context = new MapContext();
        Script plus = this.JEXL.createScript("a + b", new String[]{"a", "b"});
        context.set("plus", (Object)plus);
        Script forty2 = this.JEXL.createScript("plus(4, 2) * plus(4, 3)");
        Object o = forty2.execute((JexlContext)context);
        MethodTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        HashMap<String, Object> foo = new HashMap<String, Object>();
        foo.put("plus", plus);
        context.set("foo", foo);
        forty2 = this.JEXL.createScript("foo.plus(4, 2) * foo.plus(4, 3)");
        o = forty2.execute((JexlContext)context);
        MethodTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        context = new ScriptContext(foo);
        forty2 = this.JEXL.createScript("script:plus(4, 2) * script:plus(4, 3)");
        o = forty2.execute((JexlContext)context);
        MethodTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        final JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlMethod mplus = new JexlMethod(){

            public Object invoke(Object obj, Object[] params) throws Exception {
                if (obj instanceof Map) {
                    return ja.add(params[0], params[1]);
                }
                throw new Exception("not a script context");
            }

            public Object tryInvoke(String name, Object obj, Object[] params) {
                try {
                    if ("plus".equals(name)) {
                        return this.invoke(obj, params);
                    }
                }
                catch (Exception xany) {
                    // empty catch block
                }
                return this;
            }

            public boolean tryFailed(Object rval) {
                return rval == this;
            }

            public boolean isCacheable() {
                return true;
            }

            public Class<?> getReturnType() {
                return Object.class;
            }
        };
        foo.put("PLUS", mplus);
        forty2 = this.JEXL.createScript("script:PLUS(4, 2) * script:PLUS(4, 3)");
        o = forty2.execute((JexlContext)context);
        MethodTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
        context.set("foo.bar", foo);
        forty2 = this.JEXL.createScript("foo.'bar'.PLUS(4, 2) * foo.bar.PLUS(4, 3)");
        o = forty2.execute((JexlContext)context);
        MethodTest.assertEquals((String)"Result is not 42", (Object)new Integer(42), (Object)o);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScriptContext
    extends MapContext
    implements NamespaceResolver {
        Map<String, Object> nsScript;

        ScriptContext(Map<String, Object> ns) {
            this.nsScript = ns;
        }

        public Object resolveNamespace(String name) {
            if (name == null) {
                return this;
            }
            if ("script".equals(name)) {
                return this.nsScript;
            }
            return null;
        }
    }

    public static class MyMath {
        public double cos(double x) {
            return Math.cos(x);
        }
    }

    public static class ContextualFunctor {
        private final EnhancedContext context;

        public ContextualFunctor(EnhancedContext theContext) {
            this.context = theContext;
        }

        public int ratio(int n) {
            --this.context.factor;
            return n / this.context.factor;
        }
    }

    public static class EnhancedContext
    extends MapContext {
        int factor = 6;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Functor {
        public int ten() {
            return 10;
        }

        public int plus10(int num) {
            return num + 10;
        }

        public static int TWENTY() {
            return 20;
        }

        public static int PLUS20(int num) {
            return num + 20;
        }

        public static Class<?> NPEIfNull(Object x) {
            return x.getClass();
        }
    }

    public static class VarArgs {
        public String callInts(Integer ... args) {
            int result = 0;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    result += args[i] != null ? args[i] : -100;
                }
            } else {
                result = -1000;
            }
            return "Varargs:" + result;
        }

        public String callMixed(Integer fixed, Integer ... args) {
            int result = fixed;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    result += args[i] != null ? args[i] : -100;
                }
            } else {
                result -= 1000;
            }
            return "Mixed:" + result;
        }

        public String callMixed(String mixed, Integer ... args) {
            int result = 0;
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    result += args[i] != null ? args[i] : -100;
                }
            } else {
                result = -1000;
            }
            return mixed + ":" + result;
        }
    }
}

