/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationTest
extends JexlTestCase {
    public AnnotationTest() {
        super("AnnotationTest");
    }

    @Test
    public void test197a() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("@synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
    }

    @Test
    public void testVarStmt() throws Exception {
        Object r;
        OptAnnotationContext jc = new OptAnnotationContext();
        JexlEngine jexl = new JexlBuilder().strict(true).silent(false).create();
        jc.setOptions(jexl);
        JexlScript e = jexl.createScript("(s, v)->{ @strict(s) @silent(v) var x = y ; 42; }");
        try {
            r = e.execute((JexlContext)jc, new Object[]{false, true});
            Assert.assertEquals((Object)42, (Object)r);
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"should not have thrown");
        }
        r = null;
        try {
            r = e.execute((JexlContext)jc, new Object[]{true, false});
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException.Variable xjexl) {
            Assert.assertNull(r);
        }
        r = null;
        try {
            r = e.execute((JexlContext)jc, new Object[]{true, true});
            Assert.assertEquals(null, (Object)r);
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"should not have thrown");
        }
        r = null;
        try {
            r = e.execute((JexlContext)jc, new Object[]{false, false});
            Assert.assertEquals((Object)42, (Object)r);
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"should not have thrown");
        }
        Assert.assertTrue((boolean)jc.isStrict());
        e = jexl.createScript("@scale(5) 42;");
        r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        Assert.assertTrue((boolean)jc.isStrict());
        Assert.assertEquals((long)5L, (long)jc.getArithmeticMathScale());
    }

    @Test
    public void testNoArg() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("@synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        Assert.assertEquals((long)1L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testNoArgExpression() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("@synchronized 42");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        Assert.assertEquals((long)1L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testOneArg() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("@one(1) { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        Assert.assertEquals((long)1L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("one"));
        Assert.assertTrue((boolean)jc.getNames().contains("1"));
    }

    @Test
    public void testMultiple() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("@one(1) @synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)r);
        Assert.assertEquals((long)2L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("synchronized"));
        Assert.assertTrue((boolean)jc.getNames().contains("one"));
        Assert.assertTrue((boolean)jc.getNames().contains("1"));
    }

    @Test
    public void testError() throws Exception {
        this.testError(true);
        this.testError(false);
    }

    private void testError(boolean silent) throws Exception {
        CaptureLog log = new CaptureLog();
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().logger((Log)log).strict(true).silent(silent).create();
        JexlScript e = jexl.createScript("@error('42') { return 42; }");
        try {
            Object r = e.execute((JexlContext)jc);
            if (!silent) {
                Assert.fail((String)"should have failed");
            } else {
                Assert.assertEquals((long)1L, (long)log.count("warn"));
            }
        }
        catch (JexlException.Annotation xjexl) {
            Assert.assertEquals((Object)"error", (Object)xjexl.getAnnotation());
        }
        Assert.assertEquals((long)1L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("error"));
        Assert.assertTrue((boolean)jc.getNames().contains("42"));
        if (!silent) {
            Assert.assertEquals((long)0L, (long)log.count("warn"));
        }
    }

    @Test
    public void testUnknown() throws Exception {
        this.testUnknown(true);
        this.testUnknown(false);
    }

    private void testUnknown(boolean silent) throws Exception {
        CaptureLog log = new CaptureLog();
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().logger((Log)log).strict(true).silent(silent).create();
        JexlScript e = jexl.createScript("@unknown('42') { return 42; }");
        try {
            Object r = e.execute((JexlContext)jc);
            if (!silent) {
                Assert.fail((String)"should have failed");
            } else {
                Assert.assertEquals((long)1L, (long)log.count("warn"));
            }
        }
        catch (JexlException.Annotation xjexl) {
            Assert.assertEquals((Object)"unknown", (Object)xjexl.getAnnotation());
        }
        Assert.assertEquals((long)1L, (long)jc.getCount());
        Assert.assertTrue((boolean)jc.getNames().contains("unknown"));
        Assert.assertFalse((boolean)jc.getNames().contains("42"));
        if (!silent) {
            Assert.assertEquals((long)0L, (long)log.count("warn"));
        }
    }

    public class OptAnnotationContext
    extends JexlEvalContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            if ("strict".equals(name)) {
                boolean s = (Boolean)args[0];
                boolean b2 = this.isStrict();
                this.setStrict(s);
                Object r = statement.call();
                this.setStrict(b2);
                return r;
            }
            if ("silent".equals(name)) {
                if (args == null || args.length == 0) {
                    boolean b = this.isSilent();
                    try {
                        Object b2 = statement.call();
                        return b2;
                    }
                    catch (JexlException xjexl) {
                        Object r = null;
                        return r;
                    }
                    finally {
                        this.setSilent(b);
                    }
                }
                boolean s = (Boolean)args[0];
                boolean b = this.isSilent();
                this.setSilent(s);
                Object r = statement.call();
                this.setSilent(b);
                return r;
            }
            if ("scale".equals(name)) {
                this.setMathScale((Integer)args[0]);
                return statement.call();
            }
            return statement.call();
        }
    }

    public static class AnnotationContext
    extends MapContext
    implements JexlContext.AnnotationProcessor {
        private int count = 0;
        private final Set<String> names = new TreeSet<String>();

        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            ++this.count;
            this.names.add(name);
            if ("one".equals(name)) {
                this.names.add(args[0].toString());
            } else if ("two".equals(name)) {
                this.names.add(args[0].toString());
                this.names.add(args[1].toString());
            } else {
                if ("error".equals(name)) {
                    this.names.add(args[0].toString());
                    throw new IllegalArgumentException(args[0].toString());
                }
                if ("unknown".equals(name)) {
                    return null;
                }
            }
            return statement.call();
        }

        public int getCount() {
            return this.count;
        }

        public Set<String> getNames() {
            return this.names;
        }
    }
}

