/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.ByteArrayInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ArithmeticTest
extends JexlTestCase {
    private static final double EPSILON = 1.0E-6;
    private final Asserter asserter;

    public ArithmeticTest() {
        super("ArithmeticTest");
        this.asserter = new Asserter(this.JEXL);
    }

    @Override
    @Before
    public void setUp() {
    }

    @Test
    public void testUndefinedVar() throws Exception {
        this.asserter.failExpression("objects[1].status", ".* undefined variable objects.*");
    }

    @Test
    public void testLeftNullOperand() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", 8);
        this.asserter.setStrict(true);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    @Test
    public void testRightNullOperand() throws Exception {
        this.asserter.setVariable("left", 9);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    @Test
    public void testNullOperands() throws Exception {
        this.asserter.setVariable("left", null);
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("left + right", ".*null.*");
        this.asserter.failExpression("left - right", ".*null.*");
        this.asserter.failExpression("left * right", ".*null.*");
        this.asserter.failExpression("left / right", ".*null.*");
        this.asserter.failExpression("left % right", ".*null.*");
        this.asserter.failExpression("left & right", ".*null.*");
        this.asserter.failExpression("left | right", ".*null.*");
        this.asserter.failExpression("left ^ right", ".*null.*");
    }

    @Test
    public void testNullOperand() throws Exception {
        this.asserter.setVariable("right", null);
        this.asserter.failExpression("~right", ".*null.*");
    }

    @Test
    public void testBigDecimal() throws Exception {
        this.asserter.setVariable("left", new BigDecimal(2));
        this.asserter.setVariable("right", new BigDecimal(6));
        this.asserter.assertExpression("left + right", new BigDecimal(8));
        this.asserter.assertExpression("right - left", new BigDecimal(4));
        this.asserter.assertExpression("right * left", new BigDecimal(12));
        this.asserter.assertExpression("right / left", new BigDecimal(3));
        this.asserter.assertExpression("right % left", new BigDecimal(0));
    }

    @Test
    public void testBigInteger() throws Exception {
        this.asserter.setVariable("left", new BigInteger("2"));
        this.asserter.setVariable("right", new BigInteger("6"));
        this.asserter.assertExpression("left + right", new BigInteger("8"));
        this.asserter.assertExpression("right - left", new BigInteger("4"));
        this.asserter.assertExpression("right * left", new BigInteger("12"));
        this.asserter.assertExpression("right / left", new BigInteger("3"));
        this.asserter.assertExpression("right % left", new BigInteger("0"));
    }

    @Test
    public void testUnaryMinus() throws Exception {
        this.asserter.setVariable("aByte", new Byte(1));
        this.asserter.setVariable("aShort", new Short(2));
        this.asserter.setVariable("anInteger", new Integer(3));
        this.asserter.setVariable("aLong", new Long(4L));
        this.asserter.setVariable("aFloat", new Float(5.5));
        this.asserter.setVariable("aDouble", new Double(6.6));
        this.asserter.setVariable("aBigInteger", new BigInteger("7"));
        this.asserter.setVariable("aBigDecimal", new BigDecimal("8.8"));
        this.asserter.assertExpression("-3", new Integer("-3"));
        this.asserter.assertExpression("-3.0", new Double("-3.0"));
        this.asserter.assertExpression("-aByte", new Byte(-1));
        this.asserter.assertExpression("-aShort", new Short(-2));
        this.asserter.assertExpression("-anInteger", new Integer(-3));
        this.asserter.assertExpression("-aLong", new Long(-4L));
        this.asserter.assertExpression("-aFloat", new Float(-5.5));
        this.asserter.assertExpression("-aDouble", new Double(-6.6));
        this.asserter.assertExpression("-aBigInteger", new BigInteger("-7"));
        this.asserter.assertExpression("-aBigDecimal", new BigDecimal("-8.8"));
    }

    @Test
    public void testCalculations() throws Exception {
        this.asserter.setStrict(true, false);
        this.asserter.setVariable("imanull", null);
        this.asserter.assertExpression("imanull + 2", new Integer(2));
        this.asserter.assertExpression("imanull + imanull", new Integer(0));
        this.asserter.setVariable("foo", new Integer(2));
        this.asserter.assertExpression("foo + 2", new Integer(4));
        this.asserter.assertExpression("3 + 3", new Integer(6));
        this.asserter.assertExpression("3 + 3 + foo", new Integer(8));
        this.asserter.assertExpression("3 * 3", new Integer(9));
        this.asserter.assertExpression("3 * 3 + foo", new Integer(11));
        this.asserter.assertExpression("3 * 3 - foo", new Integer(7));
        this.asserter.assertExpression("(4 + 3) * 6", new Integer(42));
        this.asserter.assertExpression("(8 - 2) * 7", new Integer(42));
        this.asserter.assertExpression("3 * \"3.0\"", new Double(9.0));
        this.asserter.assertExpression("3 * 3.0", new Double(9.0));
        this.asserter.setStrict(false, false);
        this.asserter.assertExpression("6 / 3", new Integer(2));
        this.asserter.assertExpression("6.4 / 3", new Double(2.1333333333333333));
        this.asserter.assertExpression("0 / 3", new Integer(0));
        this.asserter.assertExpression("3 / 0", new Double(0.0));
        this.asserter.assertExpression("4 % 3", new Integer(1));
        this.asserter.assertExpression("4.8 % 3", new Double(1.7999999999999998));
    }

    @Test
    public void testCoercions() throws Exception {
        this.asserter.assertExpression("1", new Integer(1));
        this.asserter.assertExpression("5L", new Long(5L));
        this.asserter.setVariable("I2", new Integer(2));
        this.asserter.setVariable("L2", new Long(2L));
        this.asserter.setVariable("L3", new Long(3L));
        this.asserter.setVariable("B10", BigInteger.TEN);
        this.asserter.assertExpression("I2 + 2", new Integer(4));
        this.asserter.assertExpression("I2 * 2", new Integer(4));
        this.asserter.assertExpression("I2 - 2", new Integer(0));
        this.asserter.assertExpression("I2 / 2", new Integer(1));
        this.asserter.assertExpression("I2 * L2", new Long(4L));
        this.asserter.assertExpression("I2 / L2", new Long(1L));
        this.asserter.assertExpression("L2 + 3", new Long(5L));
        this.asserter.assertExpression("L2 + L3", new Long(5L));
        this.asserter.assertExpression("L2 / L2", new Long(1L));
        this.asserter.assertExpression("L2 / 2", new Long(1L));
        this.asserter.assertExpression("B10 / 10", BigInteger.ONE);
        this.asserter.assertExpression("B10 / I2", new BigInteger("5"));
        this.asserter.assertExpression("B10 / L2", new BigInteger("5"));
    }

    @Test
    public void testLongLiterals() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 10L; b = 10l; c = 42.0D; d = 42.0d; e=56.3F; f=56.3f; g=63.5; h=0x10; i=010; j=0x10L; k=010l}";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)10L, (Object)ctxt.get("a"));
        Assert.assertEquals((Object)10L, (Object)ctxt.get("b"));
        Assert.assertEquals((Object)42.0, (Object)ctxt.get("c"));
        Assert.assertEquals((Object)42.0, (Object)ctxt.get("d"));
        Assert.assertEquals((Object)Float.valueOf(56.3f), (Object)ctxt.get("e"));
        Assert.assertEquals((Object)Float.valueOf(56.3f), (Object)ctxt.get("f"));
        Assert.assertEquals((Object)63.5, (Object)ctxt.get("g"));
        Assert.assertEquals((Object)16, (Object)ctxt.get("h"));
        Assert.assertEquals((Object)8, (Object)ctxt.get("i"));
        Assert.assertEquals((Object)16L, (Object)ctxt.get("j"));
        Assert.assertEquals((Object)8L, (Object)ctxt.get("k"));
    }

    @Test
    public void testBigLiteralValue() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        JexlExpression e = this.JEXL.createExpression("9223372036854775806.5B");
        String res = String.valueOf(e.evaluate((JexlContext)ctxt));
        Assert.assertEquals((Object)"9223372036854775806.5", (Object)res);
    }

    @Test
    public void testBigdOp() throws Exception {
        BigDecimal sevendot475 = new BigDecimal("7.475");
        BigDecimal SO = new BigDecimal("325");
        MapContext jc = new MapContext();
        jc.set("SO", (Object)SO);
        String expr = "2.3*SO/100";
        Object evaluate = this.JEXL.createExpression(expr).evaluate((JexlContext)jc);
        Assert.assertEquals((Object)sevendot475, (Object)((BigDecimal)evaluate));
    }

    @Test
    public void testBigLiterals() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 10H; b = 10h; c = 42.0B; d = 42.0b;}";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)new BigInteger("10"), (Object)ctxt.get("a"));
        Assert.assertEquals((Object)new BigInteger("10"), (Object)ctxt.get("b"));
        Assert.assertEquals((Object)new BigDecimal("42.0"), (Object)ctxt.get("c"));
        Assert.assertEquals((Object)new BigDecimal("42.0"), (Object)ctxt.get("d"));
    }

    @Test
    public void testBigExponentLiterals() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 42.0e1B; b = 42.0E+2B; c = 42.0e-1B; d = 42.0E-2b; e=4242.4242e1b}";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)new BigDecimal("42.0e+1"), (Object)ctxt.get("a"));
        Assert.assertEquals((Object)new BigDecimal("42.0e+2"), (Object)ctxt.get("b"));
        Assert.assertEquals((Object)new BigDecimal("42.0e-1"), (Object)ctxt.get("c"));
        Assert.assertEquals((Object)new BigDecimal("42.0e-2"), (Object)ctxt.get("d"));
        Assert.assertEquals((Object)new BigDecimal("4242.4242e1"), (Object)ctxt.get("e"));
    }

    @Test
    public void test2DoubleLiterals() throws Exception {
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 42.0e1D; b = 42.0E+2D; c = 42.0e-1d; d = 42.0E-2d;}";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)Double.valueOf("42.0e+1"), (Object)ctxt.get("a"));
        Assert.assertEquals((Object)Double.valueOf("42.0e+2"), (Object)ctxt.get("b"));
        Assert.assertEquals((Object)Double.valueOf("42.0e-1"), (Object)ctxt.get("c"));
        Assert.assertEquals((Object)Double.valueOf("42.0e-2"), (Object)ctxt.get("d"));
    }

    @Test
    public void testDivideByZero() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        JexlEvalContext context = new JexlEvalContext(vars);
        vars.put("aByte", new Byte(1));
        vars.put("aShort", new Short(2));
        vars.put("aInteger", new Integer(3));
        vars.put("aLong", new Long(4L));
        vars.put("aFloat", new Float(5.5));
        vars.put("aDouble", new Double(6.6));
        vars.put("aBigInteger", new BigInteger("7"));
        vars.put("aBigDecimal", new BigDecimal("8.8"));
        vars.put("zByte", new Byte(0));
        vars.put("zShort", new Short(0));
        vars.put("zInteger", new Integer(0));
        vars.put("zLong", new Long(0L));
        vars.put("zFloat", new Float(0.0f));
        vars.put("zDouble", new Double(0.0));
        vars.put("zBigInteger", new BigInteger("0"));
        vars.put("zBigDecimal", new BigDecimal("0"));
        String[] tnames = new String[]{"Byte", "Short", "Integer", "Long", "Float", "Double", "BigInteger", "BigDecimal"};
        int PERMS = tnames.length * tnames.length;
        JexlEngine jexl = this.JEXL;
        for (int s = 0; s < 2; ++s) {
            boolean strict = s != 0;
            context.setStrict(true, strict);
            int zthrow = 0;
            int zeval = 0;
            for (String vname : tnames) {
                for (String zname : tnames) {
                    String expr = "a" + vname + " / " + "z" + zname;
                    try {
                        double zero;
                        JexlExpression zexpr = jexl.createExpression(expr);
                        Object nan = zexpr.evaluate((JexlContext)context);
                        if (!(nan instanceof Number) || (zero = ((Number)nan).doubleValue()) != 0.0) continue;
                        ++zeval;
                    }
                    catch (Exception any) {
                        ++zthrow;
                    }
                }
            }
            if (strict) {
                Assert.assertTrue((String)("All expressions should have thrown " + zthrow + "/" + PERMS), (zthrow == PERMS ? 1 : 0) != 0);
                continue;
            }
            Assert.assertTrue((String)("All expressions should have zeroed " + zeval + "/" + PERMS), (zeval == PERMS ? 1 : 0) != 0);
        }
        ArithmeticTest.debuggerCheck(jexl);
    }

    @Test
    public void testNaN() throws Exception {
        HashMap<String, Class<Double>> ns = new HashMap<String, Class<Double>>();
        ns.put("double", Double.class);
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        JexlScript script = jexl.createScript("#NaN");
        Object result = script.execute(null);
        Assert.assertTrue((boolean)Double.isNaN((Double)result));
        script = jexl.createScript("NaN");
        result = script.execute(null);
        Assert.assertTrue((boolean)Double.isNaN((Double)result));
        script = jexl.createScript("double:isNaN(#NaN)");
        result = script.execute(null);
        Assert.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("double:isNaN(NaN)");
        result = script.execute(null);
        Assert.assertTrue((boolean)((Boolean)result));
    }

    @Test
    public void testMultClass() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d * 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B * 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B * 0.1B").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    public void testDivClass() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d / 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B / 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B / 0.1B").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    public void testPlusClass() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d + 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B + 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B + 0.1B").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    public void testMinusClass() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Object ra = jexl.createExpression("463.0d - 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(Double.class, ra.getClass());
        Object r0 = jexl.createExpression("463.0B - 0.1").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r0.getClass());
        Object r1 = jexl.createExpression("463.0B - 0.1B").evaluate((JexlContext)jc);
        Assert.assertEquals(BigDecimal.class, r1.getClass());
    }

    @Test
    public void testAddWithStringsLenient() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(false)).create();
        JexlScript script = jexl.createScript("'a' + 0");
        Object result = script.execute(null);
        Assert.assertEquals((Object)"a0", (Object)result);
        script = jexl.createScript("0 + 'a' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"0a", (Object)result);
        script = jexl.createScript("0 + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + 1.2 ");
        result = script.execute(null);
        Assert.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + 1.2 ");
        result = script.execute(null);
        Assert.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + 0 ");
        result = script.execute(null);
        Assert.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("'1.2' + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"1.21.2", (Object)result);
    }

    @Test
    public void testAddWithStringsStrict() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(true)).create();
        JexlScript script = jexl.createScript("'a' + 0");
        Object result = script.execute(null);
        Assert.assertEquals((Object)"a0", (Object)result);
        script = jexl.createScript("0 + 'a' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"0a", (Object)result);
        script = jexl.createScript("0 + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"01.2", (Object)result);
        script = jexl.createScript("'1.2' + 1.2 ");
        result = script.execute(null);
        Assert.assertEquals((Object)"1.21.2", (Object)result);
        script = jexl.createScript("1.2 + 1.2 ");
        result = script.execute(null);
        Assert.assertEquals((double)2.4, (double)((Double)result), (double)1.0E-6);
        script = jexl.createScript("1.2 + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"1.21.2", (Object)result);
        script = jexl.createScript("'1.2' + 0 ");
        result = script.execute(null);
        Assert.assertEquals((Object)"1.20", (Object)result);
        script = jexl.createScript("'1.2' + '1.2' ");
        result = script.execute(null);
        Assert.assertEquals((Object)"1.21.2", (Object)result);
    }

    @Test
    public void testOption() throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        JexlEvalContext context = new JexlEvalContext(vars);
        JexlScript script = this.JEXL.createScript("0 + '1.2' ");
        context.setStrictArithmetic(true);
        Object result = script.execute((JexlContext)context);
        Assert.assertEquals((Object)"01.2", (Object)result);
        context.setStrictArithmetic(false);
        result = script.execute((JexlContext)context);
        Assert.assertEquals((double)1.2, (double)((Double)result), (double)1.0E-6);
    }

    @Test
    public void testIsFloatingPointPattern() throws Exception {
        JexlArithmetic ja = new JexlArithmetic(true);
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"floating point"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"a1."));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"b1.2"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"-10.2a-34"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+10.2a+34"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"0"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"1"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"12A"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"2F3"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"23"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+34"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3-4"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"+3.-4"));
        Assert.assertFalse((boolean)ja.isFloatingPointNumber((Object)"3ee4"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"0."));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1."));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2e3"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"2e3"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+2e-3"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+23E-34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+23.E-34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-23.4E+45"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"1.2e34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2e34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2e34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e-34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"10.2e+34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2e-34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2e+34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"-10.2E-34"));
        Assert.assertTrue((boolean)ja.isFloatingPointNumber((Object)"+10.2E+34"));
    }

    @Test
    public void testEmpty() throws Exception {
        Object[] SCRIPTS = new Object[]{"var x = null; log('x = %s', x);", 0, "var x = 'abc'; log('x = %s', x);", 1, "var x = 333; log('x = %s', x);", 1, "var x = [1, 2]; log('x = %s', x);", 2, "var x = ['a', 'b']; log('x = %s', x);", 2, "var x = {1:'A', 2:'B'}; log('x = %s', x);", 1, "var x = null; return empty(x);", true, "var x = ''; return empty(x);", true, "var x = 'abc'; return empty(x);", false, "var x = 0; return empty(x);", true, "var x = 333; return empty(x);", false, "var x = []; return empty(x);", true, "var x = [1, 2]; return empty(x);", false, "var x = ['a', 'b']; return empty(x);", false, "var x = {:}; return empty(x);", true, "var x = {1:'A', 2:'B'}; return empty(x);", false};
        JexlEngine jexl = new JexlBuilder().create();
        EmptyTestContext jc = new EmptyTestContext();
        for (int e = 0; e < SCRIPTS.length; e += 2) {
            String stext = (String)SCRIPTS[e];
            Object expected = SCRIPTS[e + 1];
            JexlScript script = jexl.createScript(stext);
            Object result = script.execute((JexlContext)jc);
            Assert.assertEquals((String)("failed on " + stext), (Object)expected, (Object)result);
        }
    }

    @Test
    public void testArithmeticPlus() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new ArithmeticPlus(false)).create();
        EmptyTestContext jc = new EmptyTestContext();
        this.runOverload(jexl, (JexlContext)jc);
        this.runOverload(jexl, (JexlContext)jc);
    }

    @Test
    public void testArithmeticPlusNoCache() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(0).arithmetic((JexlArithmetic)new ArithmeticPlus(false)).create();
        EmptyTestContext jc = new EmptyTestContext();
        this.runOverload(jexl, (JexlContext)jc);
    }

    protected void runOverload(JexlEngine jexl, JexlContext jc) {
        JexlScript script = jexl.createScript("(x, y)->{ x < y }");
        Object result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(43), new Var(42)});
        Assert.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x <= y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assert.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x > y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(43), new Var(42)});
        Assert.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x >= y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assert.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x == y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(41), new Var(44)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{43, 42});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assert.assertEquals((Object)false, (Object)result);
        script = jexl.createScript("(x, y)->{ x != y }");
        result = script.execute(jc, new Object[]{42, 43});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(42), new Var(43)});
        Assert.assertEquals((Object)true, (Object)result);
        result = script.execute(jc, new Object[]{new Var(44), new Var(44)});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{44, 44});
        Assert.assertEquals((Object)false, (Object)result);
        result = script.execute(jc, new Object[]{new Var(45), new Var(40)});
        Assert.assertEquals((Object)true, (Object)result);
        script = jexl.createScript("(x, y)->{ x % y }");
        result = script.execute(jc, new Object[]{4242, 100});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(4242), new Var(100)});
        Assert.assertEquals((long)42L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x * y }");
        result = script.execute(jc, new Object[]{6, 7});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(6), new Var(7)});
        Assert.assertEquals((long)42L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x + y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assert.assertEquals((long)42L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x - y }");
        result = script.execute(jc, new Object[]{49, 7});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{"foobarquux", "bar"});
        Assert.assertEquals((Object)"fooquux", (Object)result);
        result = script.execute(jc, new Object[]{50, 8});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(50), new Var(8)});
        Assert.assertEquals((long)42L, (long)((Var)result).value);
        script = jexl.createScript("(x)->{ -x }");
        result = script.execute(jc, new Object[]{-42});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(jc, new Object[]{new Var(-42)});
        Assert.assertEquals((long)42L, (long)((Var)result).value);
        result = script.execute(jc, new Object[]{"pizza"});
        Assert.assertEquals((Object)"azzip", (Object)result);
        result = script.execute(jc, new Object[]{-142});
        Assert.assertEquals((Object)142, (Object)result);
        script = jexl.createScript("(x)->{ ~x }");
        result = script.execute(jc, new Object[]{-1});
        Assert.assertEquals((Object)0L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(-1)});
        Assert.assertEquals((long)0L, (long)((Var)result).value);
        result = script.execute(jc, new Object[]{new Var(-42)});
        Assert.assertEquals((long)41L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x ^ y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assert.assertEquals((Object)36L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assert.assertEquals((long)36L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x & y }");
        result = script.execute(jc, new Object[]{35, 7});
        Assert.assertEquals((Object)3L, (Object)result);
        result = script.execute(jc, new Object[]{new Var(35), new Var(7)});
        Assert.assertEquals((long)3L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x =^ y }");
        result = script.execute(jc, new Object[]{3115, 31});
        Assert.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(31)});
        Assert.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !^ y }");
        result = script.execute(jc, new Object[]{3115, 31});
        Assert.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(31)});
        Assert.assertFalse((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x =$ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(15)});
        Assert.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !$ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3115), new Var(15)});
        Assert.assertFalse((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x =~ y }");
        result = script.execute(jc, new Object[]{3155, 15});
        Assert.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3155), new Var(15)});
        Assert.assertFalse((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(15), new Var(3155)});
        Assert.assertTrue((boolean)((Boolean)result));
        script = jexl.createScript("(x, y)->{ x !~ y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(3155), new Var(15)});
        Assert.assertTrue((boolean)((Boolean)result));
        result = script.execute(jc, new Object[]{new Var(15), new Var(3155)});
        Assert.assertFalse((boolean)((Boolean)result));
        script = jexl.createScript("(x)->{ !x }");
        try {
            result = script.execute(jc, new Object[]{new Var(-42)});
            Assert.fail((String)"should fail");
        }
        catch (JexlException xany) {
            Assert.assertTrue((boolean)(xany instanceof JexlException.Operator));
        }
    }

    @Test
    public void testJexl173() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext jc = new MapContext();
        Callable173 c173 = new Callable173();
        JexlScript e = jexl.createScript("c173(9, 6)", new String[]{"c173"});
        Object result = e.execute((JexlContext)jc, new Object[]{c173});
        Assert.assertEquals((Object)54, (Object)result);
        e = jexl.createScript("c173('fourty', 'two')", new String[]{"c173"});
        result = e.execute((JexlContext)jc, new Object[]{c173});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testInfiniteArithmetic() throws Exception {
        HashMap<String, Class<Math>> ns = new HashMap<String, Class<Math>>();
        ns.put("math", Math.class);
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic132()).namespaces(ns).create();
        Object evaluate = jexl.createExpression("1/0").evaluate(null);
        Assert.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("-1/0").evaluate(null);
        Assert.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("1.0/0.0").evaluate(null);
        Assert.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("-1.0/0.0").evaluate(null);
        Assert.assertTrue((boolean)Double.isInfinite((Double)evaluate));
        evaluate = jexl.createExpression("math:abs(-42)").evaluate(null);
        Assert.assertEquals((Object)42, (Object)evaluate);
    }

    private static Document getDocument(String xml) throws Exception {
        DocumentBuilder xmlBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream stringInputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        return xmlBuilder.parse(stringInputStream);
    }

    @Test
    public void testXmlArithmetic() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new XmlArithmetic(false)).create();
        JexlScript e0 = jexl.createScript("x.empty()", new String[]{"x"});
        JexlScript e1 = jexl.createScript("empty(x)", new String[]{"x"});
        JexlScript s0 = jexl.createScript("x.size()", new String[]{"x"});
        JexlScript s1 = jexl.createScript("size(x)", new String[]{"x"});
        Document xml = ArithmeticTest.getDocument("<node info='123'/>");
        Node x = xml.getLastChild();
        Boolean empty = (Boolean)e0.execute(null, new Object[]{x});
        Assert.assertFalse((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assert.assertFalse((boolean)empty);
        int size = (Integer)s0.execute(null, new Object[]{x});
        Assert.assertEquals((long)0L, (long)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assert.assertEquals((long)0L, (long)size);
        xml = ArithmeticTest.getDocument("<node><a/><b/></node>");
        x = xml.getLastChild();
        empty = (Boolean)e0.execute(null, new Object[]{x});
        Assert.assertFalse((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assert.assertFalse((boolean)empty);
        size = (Integer)s0.execute(null, new Object[]{x});
        Assert.assertEquals((long)2L, (long)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assert.assertEquals((long)2L, (long)size);
        xml = ArithmeticTest.getDocument("<node/>");
        x = xml.getLastChild();
        empty = (Boolean)e0.execute(null, new Object[]{x});
        Assert.assertTrue((boolean)empty);
        empty = (Boolean)e1.execute(null, new Object[]{x});
        Assert.assertTrue((boolean)empty);
        size = (Integer)s0.execute(null, new Object[]{x});
        Assert.assertEquals((long)0L, (long)size);
        size = (Integer)s1.execute(null, new Object[]{x});
        Assert.assertEquals((long)0L, (long)size);
        xml = ArithmeticTest.getDocument("<node info='123'/>");
        NamedNodeMap nnm = xml.getLastChild().getAttributes();
        Attr info = (Attr)nnm.getNamedItem("info");
        Assert.assertEquals((Object)"123", (Object)info.getValue());
        MapContext jc = new MapContext();
        jc.set("x", (Object)xml.getLastChild());
        String y = "456";
        jc.set("y", (Object)"456");
        JexlScript s = jexl.createScript("x.attribute.info = y");
        Object r = s.execute((JexlContext)jc);
        nnm = xml.getLastChild().getAttributes();
        info = (Attr)nnm.getNamedItem("info");
        Assert.assertEquals((Object)"456", (Object)r);
        Assert.assertEquals((Object)"456", (Object)info.getValue());
    }

    @Test
    public void testEmptyLong() throws Exception {
        Object x = this.JEXL.createScript("new('java.lang.Long', 4294967296)").execute(null);
        Assert.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("new('java.lang.Long', '4294967296')").execute(null);
        Assert.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("4294967296l").execute(null);
        Assert.assertEquals((long)0x100000000L, (long)((Long)x));
        x = this.JEXL.createScript("4294967296L").execute(null);
        Assert.assertEquals((long)0x100000000L, (long)((Long)x));
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0L").execute(null);
        Assert.assertEquals((long)0L, (long)((Long)x));
        this.checkEmpty(x, true);
    }

    @Test
    public void testEmptyFloat() throws Exception {
        Object x = this.JEXL.createScript("4294967296.f").execute(null);
        Assert.assertEquals((double)4.294967296E9, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("4294967296.0f").execute(null);
        Assert.assertEquals((double)4.294967296E9, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0.0f").execute(null);
        Assert.assertEquals((double)0.0, (double)((Float)x).floatValue(), (double)1.0E-6);
        this.checkEmpty(x, true);
        x = Float.valueOf(Float.NaN);
        this.checkEmpty(x, true);
    }

    @Test
    public void testEmptyDouble() throws Exception {
        Object x = this.JEXL.createScript("4294967296.d").execute(null);
        Assert.assertEquals((double)4.294967296E9, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("4294967296.0d").execute(null);
        Assert.assertEquals((double)4.294967296E9, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, false);
        x = this.JEXL.createScript("0.0d").execute(null);
        Assert.assertEquals((double)0.0, (double)((Double)x), (double)1.0E-6);
        this.checkEmpty(x, true);
        x = Double.NaN;
        this.checkEmpty(x, true);
    }

    void checkEmpty(Object x, boolean expect) {
        JexlScript s0 = this.JEXL.createScript("empty(x)", new String[]{"x"});
        boolean empty = (Boolean)s0.execute(null, new Object[]{x});
        Assert.assertEquals((Object)expect, (Object)empty);
        JexlScript s1 = this.JEXL.createScript("empty x", new String[]{"x"});
        empty = (Boolean)s1.execute(null, new Object[]{x});
        Assert.assertEquals((Object)expect, (Object)empty);
        JexlScript s2 = this.JEXL.createScript("x.empty()", new String[]{"x"});
        empty = (Boolean)s2.execute(null, new Object[]{x});
        Assert.assertEquals((Object)expect, (Object)empty);
    }

    @Test
    public void testCoerceInteger() throws Exception {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((long)34L, (long)ja.toInteger(ctxt.get("a")));
        Assert.assertEquals((long)45L, (long)ja.toInteger(ctxt.get("b")));
        Assert.assertEquals((long)56L, (long)ja.toInteger(ctxt.get("c")));
        Assert.assertEquals((long)67L, (long)ja.toInteger(ctxt.get("d")));
        Assert.assertEquals((long)78L, (long)ja.toInteger(ctxt.get("e")));
        Assert.assertEquals((long)10L, (long)ja.toInteger((Object)"10"));
        Assert.assertEquals((long)1L, (long)ja.toInteger((Object)true));
        Assert.assertEquals((long)0L, (long)ja.toInteger((Object)false));
    }

    @Test
    public void testCoerceLong() throws Exception {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H;";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((long)34L, (long)ja.toLong(ctxt.get("a")));
        Assert.assertEquals((long)45L, (long)ja.toLong(ctxt.get("b")));
        Assert.assertEquals((long)56L, (long)ja.toLong(ctxt.get("c")));
        Assert.assertEquals((long)67L, (long)ja.toLong(ctxt.get("d")));
        Assert.assertEquals((long)78L, (long)ja.toLong(ctxt.get("e")));
        Assert.assertEquals((long)10L, (long)ja.toLong((Object)"10"));
        Assert.assertEquals((long)1L, (long)ja.toLong((Object)true));
        Assert.assertEquals((long)0L, (long)ja.toLong((Object)false));
    }

    @Test
    public void testCoerceDouble() throws Exception {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((double)34.0, (double)ja.toDouble(ctxt.get("a")), (double)1.0E-6);
        Assert.assertEquals((double)45.0, (double)ja.toDouble(ctxt.get("b")), (double)1.0E-6);
        Assert.assertEquals((double)56.0, (double)ja.toDouble(ctxt.get("c")), (double)1.0E-6);
        Assert.assertEquals((double)67.0, (double)ja.toDouble(ctxt.get("d")), (double)1.0E-6);
        Assert.assertEquals((double)78.0, (double)ja.toDouble(ctxt.get("e")), (double)1.0E-6);
        Assert.assertEquals((double)10.0, (double)ja.toDouble((Object)"10"), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)ja.toDouble((Object)true), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)ja.toDouble((Object)false), (double)1.0E-6);
    }

    @Test
    public void testCoerceBigInteger() throws Exception {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)BigInteger.valueOf(34L), (Object)ja.toBigInteger(ctxt.get("a")));
        Assert.assertEquals((Object)BigInteger.valueOf(45L), (Object)ja.toBigInteger(ctxt.get("b")));
        Assert.assertEquals((Object)BigInteger.valueOf(56L), (Object)ja.toBigInteger(ctxt.get("c")));
        Assert.assertEquals((Object)BigInteger.valueOf(67L), (Object)ja.toBigInteger(ctxt.get("d")));
        Assert.assertEquals((Object)BigInteger.valueOf(78L), (Object)ja.toBigInteger(ctxt.get("e")));
        Assert.assertEquals((Object)BigInteger.valueOf(10L), (Object)ja.toBigInteger((Object)"10"));
        Assert.assertEquals((Object)BigInteger.valueOf(1L), (Object)ja.toBigInteger((Object)true));
        Assert.assertEquals((Object)BigInteger.valueOf(0L), (Object)ja.toBigInteger((Object)false));
    }

    @Test
    public void testCoerceBigDecimal() throws Exception {
        JexlArithmetic ja = this.JEXL.getArithmetic();
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setStrictArithmetic(true);
        String stmt = "{a = 34L; b = 45.0D; c=56.0F; d=67B; e=78H; }";
        JexlScript expr = this.JEXL.createScript(stmt);
        expr.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)BigDecimal.valueOf(34L), (Object)ja.toBigDecimal(ctxt.get("a")));
        Assert.assertEquals((Object)BigDecimal.valueOf(45.0), (Object)ja.toBigDecimal(ctxt.get("b")));
        Assert.assertEquals((Object)BigDecimal.valueOf(56.0), (Object)ja.toBigDecimal(ctxt.get("c")));
        Assert.assertEquals((Object)BigDecimal.valueOf(67L), (Object)ja.toBigDecimal(ctxt.get("d")));
        Assert.assertEquals((Object)BigDecimal.valueOf(78L), (Object)ja.toBigDecimal(ctxt.get("e")));
        Assert.assertEquals((Object)BigDecimal.valueOf(10L), (Object)ja.toBigDecimal((Object)"10"));
        Assert.assertEquals((Object)BigDecimal.valueOf(1.0), (Object)ja.toBigDecimal((Object)true));
        Assert.assertEquals((Object)BigDecimal.valueOf(0.0), (Object)ja.toBigDecimal((Object)false));
    }

    @Test
    public void testAtomicBoolean() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x) 1 else 2;", new String[]{"x"});
        MapContext jc = new MapContext();
        AtomicBoolean ab = new AtomicBoolean(false);
        Object o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertEquals((String)"Result is not 2", (Object)new Integer(2), (Object)o);
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertEquals((String)"Result is not 1", (Object)new Integer(1), (Object)o);
        e = this.JEXL.createScript("x && y", new String[]{"x", "y"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assert.assertFalse((boolean)((Boolean)o));
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.TRUE});
        Assert.assertTrue((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assert.assertFalse((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, Boolean.FALSE});
        Assert.assertFalse((boolean)((Boolean)o));
        e = this.JEXL.createScript("x + y", new String[]{"x", "y"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab, 10});
        Assert.assertEquals((Object)11, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{10, ab});
        Assert.assertEquals((Object)11, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{ab, 10.0});
        Assert.assertEquals((double)11.0, (double)((Double)o), (double)1.0E-6);
        o = e.execute((JexlContext)jc, new Object[]{10.0, ab});
        Assert.assertEquals((double)11.0, (double)((Double)o), (double)1.0E-6);
        BigInteger bi10 = BigInteger.TEN;
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, bi10});
        Assert.assertEquals((Object)bi10, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{bi10, ab});
        Assert.assertEquals((Object)bi10, (Object)o);
        BigDecimal bd10 = BigDecimal.TEN;
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab, bd10});
        Assert.assertEquals((Object)bd10, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{bd10, ab});
        Assert.assertEquals((Object)bd10, (Object)o);
        e = this.JEXL.createScript("!x", new String[]{"x"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertFalse((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertTrue((boolean)((Boolean)o));
        e = this.JEXL.createScript("-x", new String[]{"x"});
        ab.set(true);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertFalse((boolean)((Boolean)o));
        ab.set(false);
        o = e.execute((JexlContext)jc, new Object[]{ab});
        Assert.assertTrue((boolean)((Boolean)o));
    }

    public static class XmlArithmetic
    extends JexlArithmetic {
        public XmlArithmetic(boolean lenient) {
            super(lenient);
        }

        public boolean empty(Element elt) {
            return !elt.hasAttributes() && !elt.hasChildNodes();
        }

        public int size(Element elt) {
            return elt.getChildNodes().getLength();
        }
    }

    public static class Arithmetic132
    extends JexlArithmetic {
        public Arithmetic132() {
            super(false);
        }

        protected double divideZero(BigDecimal x) {
            int ls = x.signum();
            if (ls < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (ls > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }

        protected double divideZero(BigInteger x) {
            int ls = x.signum();
            if (ls < 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (ls > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NaN;
        }

        public Object divide(Object left, Object right) {
            if (left == null && right == null) {
                return this.controlNullNullOperands();
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                if (BigDecimal.ZERO.equals(r)) {
                    return this.divideZero(l);
                }
                BigDecimal result = l.divide(r, this.getMathContext());
                return this.narrowBigDecimal(left, right, result);
            }
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return new Double(l / r);
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            if (BigInteger.ZERO.equals(r)) {
                return this.divideZero(l);
            }
            BigInteger result = l.divide(r);
            return this.narrowBigInteger(left, right, result);
        }

        public Object mod(Object left, Object right) {
            if (left == null && right == null) {
                return this.controlNullNullOperands();
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = this.toBigDecimal(left);
                BigDecimal r = this.toBigDecimal(right);
                if (BigDecimal.ZERO.equals(r)) {
                    return this.divideZero(l);
                }
                BigDecimal remainder = l.remainder(r, this.getMathContext());
                return this.narrowBigDecimal(left, right, remainder);
            }
            if (this.isFloatingPointNumber(left) || this.isFloatingPointNumber(right)) {
                double l = this.toDouble(left);
                double r = this.toDouble(right);
                return new Double(l % r);
            }
            BigInteger l = this.toBigInteger(left);
            BigInteger r = this.toBigInteger(right);
            BigInteger result = l.mod(r);
            if (BigInteger.ZERO.equals(r)) {
                return this.divideZero(l);
            }
            return this.narrowBigInteger(left, right, result);
        }
    }

    public class Callable173 {
        public Object call(String ... arg) {
            return 42;
        }

        public Object call(Integer ... arg) {
            return arg[0] * arg[1];
        }
    }

    public static class ArithmeticPlus
    extends JexlArithmetic {
        public ArithmeticPlus(boolean strict) {
            super(strict);
        }

        public boolean equals(Var lhs, Var rhs) {
            return lhs.value == rhs.value;
        }

        public boolean lessThan(Var lhs, Var rhs) {
            return lhs.value < rhs.value;
        }

        public boolean lessThanOrEqual(Var lhs, Var rhs) {
            return lhs.value <= rhs.value;
        }

        public boolean greaterThan(Var lhs, Var rhs) {
            return lhs.value > rhs.value;
        }

        public boolean greaterThanOrEqual(Var lhs, Var rhs) {
            return lhs.value >= rhs.value;
        }

        public Var add(Var lhs, Var rhs) {
            return new Var(lhs.value + rhs.value);
        }

        public Var subtract(Var lhs, Var rhs) {
            return new Var(lhs.value - rhs.value);
        }

        public Var divide(Var lhs, Var rhs) {
            return new Var(lhs.value / rhs.value);
        }

        public Var multiply(Var lhs, Var rhs) {
            return new Var(lhs.value * rhs.value);
        }

        public Var mod(Var lhs, Var rhs) {
            return new Var(lhs.value / rhs.value);
        }

        public Var negate(Var arg) {
            return new Var(-arg.value);
        }

        public Var and(Var lhs, Var rhs) {
            return new Var(lhs.value & rhs.value);
        }

        public Var or(Var lhs, Var rhs) {
            return new Var(lhs.value | rhs.value);
        }

        public Var xor(Var lhs, Var rhs) {
            return new Var(lhs.value ^ rhs.value);
        }

        public Boolean contains(Var lhs, Var rhs) {
            return lhs.toString().contains(rhs.toString());
        }

        public Boolean startsWith(Var lhs, Var rhs) {
            return lhs.toString().startsWith(rhs.toString());
        }

        public Boolean endsWith(Var lhs, Var rhs) {
            return lhs.toString().endsWith(rhs.toString());
        }

        public Var complement(Var arg) {
            return new Var(~arg.value);
        }

        public Object subtract(String x, String y) {
            int ix = x.indexOf(y);
            if (ix < 0) {
                return x;
            }
            StringBuilder strb = new StringBuilder(x.substring(0, ix));
            strb.append(x.substring(ix + y.length()));
            return strb.toString();
        }

        public Object negate(String str) {
            int length = str.length();
            StringBuilder strb = new StringBuilder(str.length());
            for (int c = length - 1; c >= 0; --c) {
                strb.append(str.charAt(c));
            }
            return strb.toString();
        }

        public Object not(Var x) {
            throw new NullPointerException("make it fail");
        }
    }

    public static class Var {
        int value;

        Var(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static class EmptyTestContext
    extends MapContext
    implements JexlContext.NamespaceResolver {
        public static int log(Object fmt, Object ... arr) {
            return arr == null ? 0 : arr.length;
        }

        public static int log(Object fmt, int ... arr) {
            return arr == null ? 0 : arr.length;
        }

        public Object resolveNamespace(String name) {
            return this;
        }
    }
}

