/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.jexl3.Foo;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Before;
import org.junit.Test;

public class ArrayAccessTest
extends JexlTestCase {
    private Asserter asserter;
    private static final String GET_METHOD_STRING = "GetMethod string";
    static final String[] GET_METHOD_ARRAY = new String[]{"One", "Two", "Three"};
    static final String[][] GET_METHOD_ARRAY2 = new String[][]{{"One", "Two", "Three"}, {"Four", "Five", "Six"}};

    public ArrayAccessTest() {
        super("ArrayAccessTest");
    }

    @Override
    @Before
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    @Test
    public void testArrayAccess() throws Exception {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(new Integer(1));
        l.add(new Integer(2));
        l.add(new Integer(3));
        this.asserter.setVariable("list", l);
        this.asserter.assertExpression("list[1]", new Integer(2));
        this.asserter.assertExpression("list[1+1]", new Integer(3));
        this.asserter.setVariable("loc", new Integer(1));
        this.asserter.assertExpression("list[loc+1]", new Integer(3));
        String[] args = new String[]{"hello", "there"};
        this.asserter.setVariable("array", args);
        this.asserter.assertExpression("array[0]", "hello");
        this.asserter.assertExpression("array.0", "hello");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("foo", "bar");
        this.asserter.setVariable("map", m);
        this.asserter.setVariable("key", "foo");
        this.asserter.assertExpression("map[\"foo\"]", "bar");
        this.asserter.assertExpression("map[key]", "bar");
        this.asserter.setVariable("foo", new Foo());
        this.asserter.assertExpression("foo[\"bar\"]", GET_METHOD_STRING);
        this.asserter.assertExpression("foo[\"bar\"] == foo.bar", Boolean.TRUE);
    }

    @Test
    public void testDoubleArrays() throws Exception {
        Object[][] foo = new Object[2][2];
        foo[0][0] = "one";
        foo[0][1] = "two";
        this.asserter.setVariable("foo", foo);
        this.asserter.assertExpression("foo[0][1]", "two");
        this.asserter.assertExpression("foo[0][1] = 'three'", "three");
        this.asserter.assertExpression("foo[0][1]", "three");
        foo[0][0] = "one";
        foo[0][1] = "two";
        this.asserter.assertExpression("foo.0[1]", "two");
        this.asserter.assertExpression("foo.0[1] = 'three'", "three");
        this.asserter.assertExpression("foo.0[1]", "three");
        foo[0][0] = "one";
        foo[0][1] = "two";
        this.asserter.assertExpression("foo.0.'1'", "two");
        this.asserter.assertExpression("foo.0.'1' = 'three'", "three");
        this.asserter.assertExpression("foo.0.'1'", "three");
        foo[0][0] = "one";
        foo[0][1] = "two";
        this.asserter.assertExpression("foo.'0'.'1'", "two");
        this.asserter.assertExpression("foo.'0'.'1' = 'three'", "three");
        this.asserter.assertExpression("foo.'0'.'1'", "three");
        foo[0][0] = "one";
        foo[0][1] = "two";
        this.asserter.assertExpression("foo.0.1", "two");
        this.asserter.assertExpression("foo.0.1 = 'three'", "three");
        this.asserter.assertExpression("foo.0.1", "three");
    }

    @Test
    public void testDoubleMaps() throws Exception {
        HashMap foo = new HashMap();
        HashMap<Object, String> foo0 = new HashMap<Object, String>();
        foo.put(0, foo0);
        foo0.put(0, "one");
        foo0.put(1, "two");
        foo0.put("3.0", "three");
        this.asserter.setVariable("foo", foo);
        this.asserter.assertExpression("foo[0][1]", "two");
        this.asserter.assertExpression("foo[0][1] = 'three'", "three");
        this.asserter.assertExpression("foo[0][1]", "three");
        this.asserter.assertExpression("foo[0]['3.0']", "three");
        foo0.put(0, "one");
        foo0.put(1, "two");
        this.asserter.assertExpression("foo.0[1]", "two");
        this.asserter.assertExpression("foo.0[1] = 'three'", "three");
        this.asserter.assertExpression("foo.0[1]", "three");
        this.asserter.assertExpression("foo.0['3.0']", "three");
        foo0.put(0, "one");
        foo0.put(1, "two");
        this.asserter.assertExpression("foo.0.'1'", "two");
        this.asserter.assertExpression("foo.0.'1' = 'three'", "three");
        this.asserter.assertExpression("foo.0.'1'", "three");
        foo0.put(0, "one");
        foo0.put(1, "two");
        this.asserter.assertExpression("foo.'0'.'1'", "two");
        this.asserter.assertExpression("foo.'0'.'1' = 'three'", "three");
        this.asserter.assertExpression("foo.'0'.'1'", "three");
        foo0.put(0, "one");
        foo0.put(1, "two");
        this.asserter.assertExpression("foo.0.1", "two");
        this.asserter.assertExpression("foo.0.1 = 'three'", "three");
        this.asserter.assertExpression("foo.0.1", "three");
    }

    @Test
    public void testArrayProperty() throws Exception {
        Foo foo = new Foo();
        this.asserter.setVariable("foo", foo);
        this.asserter.assertExpression("foo.array[1]", GET_METHOD_ARRAY[1]);
        this.asserter.assertExpression("foo.array.1", GET_METHOD_ARRAY[1]);
        this.asserter.assertExpression("foo.array2[1][1]", GET_METHOD_ARRAY2[1][1]);
        this.asserter.assertExpression("foo.array2[1].1", GET_METHOD_ARRAY2[1][1]);
    }

    @Test
    public void testArrayAndDottedConflict() throws Exception {
        Object[] objects = new Object[]{"an", "array", new Long(0L)};
        this.asserter.setStrict(false);
        this.asserter.setSilent(true);
        this.asserter.setVariable("objects", objects);
        this.asserter.setVariable("status", "Enabled");
        this.asserter.assertExpression("objects[1].status", null);
        this.asserter.assertExpression("objects.1.status", null);
        this.asserter.setVariable("base.status", "Ok");
        this.asserter.assertExpression("base.objects[1].status", null);
        this.asserter.assertExpression("base.objects.1.status", null);
    }

    @Test
    public void testArrayIdentifierParsing() throws Exception {
        HashMap<Object, Double> map = new HashMap<Object, Double>();
        map.put("00200", -42.42);
        map.put(200, 42.42);
        this.asserter.setVariable("objects", map);
        this.asserter.assertExpression("objects.get('00200')", -42.42);
        this.asserter.assertExpression("objects.'00200'", -42.42);
        this.asserter.assertExpression("objects.get(200)", 42.42);
        this.asserter.assertExpression("objects.'200'", 42.42);
        this.asserter.assertExpression("objects.200", 42.42);
    }

    @Test
    public void testArrayMethods() throws Exception {
        Object[] objects = new Object[]{"an", "array", new Long(0L)};
        this.asserter.setVariable("objects", objects);
        this.asserter.assertExpression("objects.get(1)", "array");
        this.asserter.assertExpression("objects.size()", new Integer(3));
        this.asserter.assertExpression("objects.set(1, 'dion')", "array");
        this.asserter.assertExpression("objects[1]", "dion");
    }

    @Test
    public void testArrayArray() throws Exception {
        Object[] foo;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        String s43 = "fourty-three";
        foo[0] = foo = new Object[3];
        foo[1] = i42;
        foo[2] = s42;
        this.asserter.setVariable("foo", foo);
        this.asserter.setVariable("zero", 0);
        this.asserter.setVariable("one", 1);
        this.asserter.setVariable("two", 2);
        for (int l = 0; l < 2; ++l) {
            this.asserter.assertExpression("foo[0]", foo);
            this.asserter.assertExpression("foo[0][0]", foo);
            this.asserter.assertExpression("foo[1]", foo[1]);
            this.asserter.assertExpression("foo[0][1]", foo[1]);
            this.asserter.assertExpression("foo[0][1] = 43", i43);
            this.asserter.assertExpression("foo[0][1]", i43);
            this.asserter.assertExpression("foo[0][1] = 42", i42);
            this.asserter.assertExpression("foo[0][1]", i42);
            this.asserter.assertExpression("foo[0][0][1]", foo[1]);
            this.asserter.assertExpression("foo[0][0][1] = 43", i43);
            this.asserter.assertExpression("foo[0][0][1]", i43);
            this.asserter.assertExpression("foo[0][0][1] = 42", i42);
            this.asserter.assertExpression("foo[0][0][1]", i42);
            this.asserter.assertExpression("foo[2]", foo[2]);
            this.asserter.assertExpression("foo[0][2]", foo[2]);
            this.asserter.assertExpression("foo[0][2] = 'fourty-three'", s43);
            this.asserter.assertExpression("foo[0][2]", s43);
            this.asserter.assertExpression("foo[0][2] = 'fourty-two'", s42);
            this.asserter.assertExpression("foo[0][2]", s42);
            this.asserter.assertExpression("foo[0][0][2]", foo[2]);
            this.asserter.assertExpression("foo[0][0][2] = 'fourty-three'", s43);
            this.asserter.assertExpression("foo[0][0][2]", s43);
            this.asserter.assertExpression("foo[0][0][2] = 'fourty-two'", s42);
            this.asserter.assertExpression("foo[0][0][2]", s42);
            this.asserter.assertExpression("foo[zero]", foo);
            this.asserter.assertExpression("foo[zero][zero]", foo);
            this.asserter.assertExpression("foo[one]", foo[1]);
            this.asserter.assertExpression("foo[zero][one]", foo[1]);
            this.asserter.assertExpression("foo[zero][one] = 43", i43);
            this.asserter.assertExpression("foo[zero][one]", i43);
            this.asserter.assertExpression("foo[zero][one] = 42", i42);
            this.asserter.assertExpression("foo[zero][one]", i42);
            this.asserter.assertExpression("foo[zero][zero][one]", foo[1]);
            this.asserter.assertExpression("foo[zero][zero][one] = 43", i43);
            this.asserter.assertExpression("foo[zero][zero][one]", i43);
            this.asserter.assertExpression("foo[zero][zero][one] = 42", i42);
            this.asserter.assertExpression("foo[zero][zero][one]", i42);
            this.asserter.assertExpression("foo[two]", foo[2]);
            this.asserter.assertExpression("foo[zero][two]", foo[2]);
            this.asserter.assertExpression("foo[zero][two] = 'fourty-three'", s43);
            this.asserter.assertExpression("foo[zero][two]", s43);
            this.asserter.assertExpression("foo[zero][two] = 'fourty-two'", s42);
            this.asserter.assertExpression("foo[zero][two]", s42);
            this.asserter.assertExpression("foo[zero][zero][two]", foo[2]);
            this.asserter.assertExpression("foo[zero][zero][two] = 'fourty-three'", s43);
            this.asserter.assertExpression("foo[zero][zero][two]", s43);
            this.asserter.assertExpression("foo[zero][zero][two] = 'fourty-two'", s42);
            this.asserter.assertExpression("foo[zero][zero][two]", s42);
        }
    }
}

