/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class ArrayLiteralTest
extends JexlTestCase {
    public ArrayLiteralTest() {
        super("ArrayLiteralTest");
    }

    @Test
    public void testEmptyArrayLiteral() throws Exception {
        MapContext jc = new MapContext();
        Object o = this.JEXL.createExpression("[]").evaluate((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof Object[]));
        Assert.assertEquals((long)0L, (long)((Object[])o).length);
        o = this.JEXL.createExpression("[...]").evaluate((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof List));
        Assert.assertEquals((long)0L, (long)((List)o).size());
    }

    @Test
    public void testLiteralWithStrings() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 'foo' , 'bar' ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo", "bar"};
        Assert.assertTrue((boolean)Arrays.equals(check, (Object[])o));
    }

    @Test
    public void testLiteralWithElipsis() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 'foo' , 'bar', ... ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo", "bar"};
        Assert.assertEquals(Arrays.asList(check), (Object)o);
        Assert.assertEquals((long)2L, (long)((List)o).size());
    }

    @Test
    public void testLiteralWithOneEntry() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 'foo' ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{"foo"};
        Assert.assertTrue((boolean)Arrays.equals(check, (Object[])o));
    }

    @Test
    public void testLiteralWithNumbers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 5.0 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Object[] check = new Object[]{new Double(5.0), new Integer(10)};
        Assert.assertTrue((boolean)Arrays.equals(check, (Object[])o));
        Assert.assertTrue((o.getClass().isArray() && o.getClass().getComponentType().equals(Number.class) ? 1 : 0) != 0);
    }

    @Test
    public void testLiteralWithNulls() throws Exception {
        String[] exprs = new String[]{"[ null , 10 ]", "[ 10 , null ]", "[ 10 , null , 10]", "[ '10' , null ]", "[ null, '10' , null ]"};
        Object[][] checks = new Object[][]{{null, new Integer(10)}, {new Integer(10), null}, {new Integer(10), null, new Integer(10)}, {"10", null}, {null, "10", null}};
        MapContext jc = new MapContext();
        for (int t = 0; t < exprs.length; ++t) {
            JexlExpression e = this.JEXL.createExpression(exprs[t]);
            Object o = e.evaluate((JexlContext)jc);
            Assert.assertTrue((String)exprs[t], (boolean)Arrays.equals(checks[t], (Object[])o));
        }
    }

    @Test
    public void testLiteralWithIntegers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("[ 5 , 10 ]");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        int[] check = new int[]{5, 10};
        Assert.assertTrue((boolean)Arrays.equals(check, (int[])o));
    }

    @Test
    public void testSizeOfSimpleArrayLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)new Integer(2), (Object)o);
    }

    @Test
    public void notestCallingMethodsOnNewMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' : 'bar' }.values())");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)new Integer(1), (Object)o);
    }

    @Test
    public void testNotEmptySimpleArrayLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("empty([ 'foo' , 'bar' ])");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertFalse((boolean)((Boolean)o));
    }

    @Test
    public void testChangeThroughVariables() throws Exception {
        MapContext jc = new MapContext();
        JexlExpression e147 = this.JEXL.createExpression("quux = [one, two]");
        jc.set("one", (Object)1);
        jc.set("two", (Object)2);
        int[] o1 = (int[])e147.evaluate((JexlContext)jc);
        Assert.assertEquals((long)1L, (long)o1[0]);
        Assert.assertEquals((long)2L, (long)o1[1]);
        jc.set("one", (Object)10);
        jc.set("two", (Object)20);
        int[] o2 = (int[])e147.evaluate((JexlContext)jc);
        Assert.assertEquals((long)10L, (long)o2[0]);
        Assert.assertEquals((long)20L, (long)o2[1]);
    }
}

