/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.apache.commons.jexl3.ClassCreator;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ClassCreatorTest
extends JexlTestCase {
    static final Log logger = LogFactory.getLog(JexlTestCase.class);
    static final int LOOPS = 8;
    private File base = null;
    private JexlEngine jexl = null;
    static final int MEGA = 0x100000;

    public ClassCreatorTest() {
        super("ClassCreatorTest");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.base = new File(System.getProperty("java.io.tmpdir"), "jexl" + System.currentTimeMillis());
        this.jexl = this.JEXL;
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.deleteDirectory(this.base);
    }

    private void deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        dir.delete();
    }

    @Test
    public void testOne() throws Exception {
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        cctor.setSeed(1);
        Class<?> foo1 = cctor.createClass();
        Assert.assertEquals((Object)"foo1", (Object)foo1.getSimpleName());
        cctor.clear();
    }

    @Test
    public void testMany() throws Exception {
        int pass = 0;
        int gced = -1;
        ReferenceQueue<Object> queue = new ReferenceQueue<Object>();
        ArrayList<Reference> stuff = new ArrayList<Reference>();
        JexlExpression expr = this.jexl.createExpression("foo.value");
        JexlExpression newx = this.jexl.createExpression("foo = new(clazz)");
        JexlEvalContext context = new JexlEvalContext();
        context.setStrict(false);
        context.setSilent(true);
        ClassCreator cctor = new ClassCreator(this.jexl, this.base);
        for (int i = 0; i < 8 && gced < 0; ++i) {
            Class<?> clazz;
            cctor.setSeed(i);
            if (pass == 0) {
                clazz = cctor.createClass();
            } else {
                clazz = cctor.getClassInstance();
                if (clazz == null) {
                    Assert.assertEquals((long)i, (long)gced);
                    break;
                }
            }
            context.set("clazz", cctor.getClassName());
            context.set("foo", null);
            Object z = newx.evaluate((JexlContext)context);
            Assert.assertNull((Object)z);
            context.set("clazz", clazz);
            z = newx.evaluate((JexlContext)context);
            Assert.assertNotNull((String)(clazz + ": class " + i + " could not be instantiated on pass " + pass), (Object)z);
            Assert.assertEquals((Object)new Integer(i), (Object)expr.evaluate((JexlContext)context));
            this.jexl.setClassLoader(cctor.getClassLoader());
            z = newx.evaluate((JexlContext)context);
            Assert.assertTrue((boolean)z.getClass().equals(clazz));
            Assert.assertEquals((Object)new Integer(i), (Object)expr.evaluate((JexlContext)context));
            cctor.clear();
            this.jexl.setClassLoader(null);
            if (pass != 0) continue;
            stuff.add(new ClassReference(clazz, queue));
            stuff.add(new InstanceReference(clazz.newInstance(), queue));
            for (int b = 0; b < 1024 && Runtime.getRuntime().freeMemory() > 0x100000L; ++b) {
                BigObject big = new BigObject(b);
                stuff.add(new InstanceReference(big, queue));
            }
            System.gc();
            boolean qr = false;
            while (queue.poll() != null) {
                Reference<Object> ref = queue.remove(1L);
                if (!(ref instanceof ClassReference)) continue;
                gced = i;
                qr = true;
            }
            if (!qr) continue;
            pass = 1;
            i = 0;
        }
        if (gced < 0) {
            logger.warn((Object)"unable to force GC");
        }
    }

    @Test
    public void testBasicCtor() throws Exception {
        JexlScript s = this.jexl.createScript("(c, v)->{ var ct2 = new(c, v); ct2.value; }");
        Object r = s.execute(null, new Object[]{TwoCtors.class, 10});
        Assert.assertEquals((Object)10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, 10});
        Assert.assertEquals((Object)10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, 10.0});
        Assert.assertEquals((Object)-10, (Object)r);
        r = s.execute(null, new Object[]{TwoCtors.class, Float.valueOf(100.0f)});
        Assert.assertEquals((Object)-100, (Object)r);
    }

    public static class TwoCtors {
        int value;

        public TwoCtors(int v) {
            this.value = v;
        }

        public TwoCtors(Number x) {
            this.value = -x.intValue();
        }

        public int getValue() {
            return this.value;
        }
    }

    static final class InstanceReference
    extends SoftReference<Object> {
        InstanceReference(Object obj, ReferenceQueue<Object> queue) {
            super(obj, queue);
        }
    }

    static final class ClassReference
    extends WeakReference<Class<?>> {
        ClassReference(Class<?> clazz, ReferenceQueue<Object> queue) {
            super(clazz, queue);
        }
    }

    public class BigObject {
        private final byte[] space = new byte[0x100000];
        private final int id;

        public BigObject(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

