/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Engine;
import org.junit.Assert;
import org.junit.Test;

public class ContextNamespaceTest
extends JexlTestCase {
    public ContextNamespaceTest() {
        super("ContextNamespaceTest");
    }

    @Test
    public void testThreadedContext() throws Exception {
        Engine jexl = new Engine();
        TaxesContext context = new TaxesContext(18.6);
        String strs = "taxes:vat(1000)";
        JexlScript staxes = jexl.createScript(strs);
        Object result = staxes.execute((JexlContext)context);
        Assert.assertEquals((Object)186.0, (Object)result);
    }

    public static class TaxesContext
    extends MapContext
    implements JexlContext.ThreadLocal,
    JexlContext.NamespaceResolver {
        private final Taxes taxes = new Taxes();
        private final double vat;

        TaxesContext(double vat) {
            this.vat = vat;
        }

        public Object resolveNamespace(String name) {
            return "taxes".equals(name) ? this.taxes : null;
        }

        public double getVAT() {
            return this.vat;
        }
    }

    public static class Taxes {
        public double vat(double n) {
            TaxesContext context = (TaxesContext)JexlEngine.getThreadContext();
            return n * context.getVAT() / 100.0;
        }
    }
}

