/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionTest
extends JexlTestCase {
    public ExceptionTest() {
        super("ExceptionTest");
    }

    @Test
    public void testWrappedEx() throws Exception {
        Engine jexl = new Engine();
        JexlExpression e = jexl.createExpression("method()");
        ObjectContext jc = new ObjectContext((JexlEngine)jexl, (Object)new ThrowNPE());
        try {
            e.evaluate((JexlContext)jc);
            Assert.fail((String)"Should have thrown NPE");
        }
        catch (JexlException xany) {
            Throwable xth = xany.getCause();
            Assert.assertEquals(NullPointerException.class, xth.getClass());
        }
    }

    @Test
    public void testEx() throws Exception {
        String msg;
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e * 6");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setSilent(false);
        ctxt.setStrict(true);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e not defined as variable should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
        ctxt.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e as null operand should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
        ctxt.setStrictArithmetic(false);
        try {
            e.evaluate((JexlContext)ctxt);
        }
        catch (JexlException xjexl) {
            Assert.fail((String)"c.e in expr should not throw");
        }
        ctxt.set("c", "{ 'a' : 3, 'b' : 5}");
        ctxt.set("e", 2);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e not accessible as property should throw");
        }
        catch (JexlException.Property xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("e") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExVar() throws Exception {
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlScript e = jexl.createScript("(x)->{ x * 6 }");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setSilent(false);
        ctxt.setStrict(true);
        ctxt.setStrictArithmetic(true);
        try {
            e.execute((JexlContext)ctxt);
            Assert.fail((String)"x is null, should throw");
        }
        catch (JexlException xjexl) {
            String msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("null") > 0 ? 1 : 0) != 0);
        }
        ctxt.setStrictArithmetic(false);
        try {
            Object o = e.execute((JexlContext)ctxt);
        }
        catch (JexlException.Variable xjexl) {
            Assert.fail((String)"arithmetic allows null operands, should not throw");
        }
    }

    @Test
    public void testExMethod() throws Exception {
        String msg;
        JexlEngine jexl = ExceptionTest.createEngine(false);
        JexlExpression e = jexl.createExpression("c.e.foo()");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.setSilent(false);
        ctxt.setStrict(true);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e not declared as variable should throw");
        }
        catch (JexlException.Variable xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
        ctxt.setStrictArithmetic(true);
        ctxt.set("c.e", null);
        try {
            e.evaluate((JexlContext)ctxt);
            Assert.fail((String)"c.e as null operand should throw");
        }
        catch (JexlException xjexl) {
            msg = xjexl.getMessage();
            Assert.assertTrue((msg.indexOf("c.e") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test206() throws Exception {
        String src = "null.1 = 2; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = null.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
        src = "x = y.1; return 42";
        this.doTest206(src, false, false);
        this.doTest206(src, false, true);
        this.doTest206(src, true, false);
        this.doTest206(src, true, true);
    }

    private void doTest206(String src, boolean strict, boolean silent) throws Exception {
        Object r;
        CaptureLog l;
        block7: {
            l = new CaptureLog();
            MapContext jc = new MapContext();
            JexlEngine jexl = new JexlBuilder().logger((Log)l).strict(strict).silent(silent).create();
            r = -1;
            JexlScript e = jexl.createScript(src);
            try {
                r = e.execute((JexlContext)jc);
                if (strict && !silent) {
                    Assert.fail((String)"should have thrown an exception");
                }
            }
            catch (JexlException xjexl) {
                if (strict && !silent) break block7;
                Assert.fail((String)"should not have thrown an exception");
            }
        }
        if (strict) {
            if (silent && l.count("warn") == 0) {
                Assert.fail((String)"should have generated a warning");
            }
        } else {
            if (l.count("debug") == 0) {
                Assert.fail((String)"should have generated a debug");
            }
            Assert.assertEquals((Object)42, (Object)r);
        }
    }

    public static class ThrowNPE {
        public String method() {
            throw new NullPointerException("ThrowNPE");
        }
    }
}

