/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.TemplateDebugger;
import org.apache.commons.jexl3.internal.TemplateScript;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JXLTTest
extends JexlTestCase {
    private static final JexlEngine ENGINE = new JexlBuilder().silent(false).cache(128).strict(true).create();
    private static final JxltEngine JXLT = ENGINE.createJxltEngine();
    private static final Log LOG = LogFactory.getLog(JxltEngine.class);
    private final MapContext vars = new MapContext();
    private JexlEvalContext context = null;

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
        this.context = new JexlEvalContext((JexlContext)this.vars);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        JXLTTest.debuggerCheck(ENGINE);
        super.tearDown();
    }

    private static String refactor(TemplateDebugger td, JxltEngine.Template ts) {
        boolean dbg = td.debug((JxltEngine.Template)((TemplateScript)ts));
        if (dbg) {
            return td.toString();
        }
        return "";
    }

    private String getSource(String tostring) {
        int len = tostring.length();
        int sc = tostring.lastIndexOf(" /*= ");
        if (sc >= 0) {
            sc += " /*= ".length();
        }
        int ec = tostring.lastIndexOf(" */");
        if (sc >= 0 && ec >= 0 && ec > sc && ec < len) {
            return tostring.substring(sc, ec);
        }
        return tostring;
    }

    public JXLTTest() {
        super("JXLTTest");
    }

    @Test
    public void testStatement() throws Exception {
        Froboz froboz = new Froboz(32);
        this.context.set("froboz", froboz);
        JxltEngine.Expression check = JXLT.createExpression("${ froboz.plus10() }");
        Object o = check.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 32", (Object)new Integer(32), (Object)o);
        Assert.assertEquals((String)"Result is not 42", (long)42L, (long)froboz.getValue());
        Set evars = check.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
    }

    @Test
    public void testAssign() throws Exception {
        JxltEngine.Expression assign = JXLT.createExpression("${froboz.value = 10}");
        JxltEngine.Expression check = JXLT.createExpression("${froboz.value}");
        Object o = assign.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
        o = check.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testComposite() throws Exception {
        String source = "Dear ${p} ${name};";
        JxltEngine.Expression expr = JXLT.createExpression(source);
        this.context.set("p", "Mr");
        this.context.set("name", "Doe");
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        this.context.set("p", "Ms");
        this.context.set("name", "Jones");
        o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Ms Jones;", (Object)o);
        Assert.assertEquals((Object)source, (Object)this.getSource(expr.toString()));
    }

    boolean contains(Set<List<String>> set, List<String> list) {
        for (List<String> sl : set) {
            if (!((Object)sl).equals(list)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testPrepareEvaluate() throws Exception {
        String source = "Dear #{p} ${name};";
        JxltEngine.Expression expr = JXLT.createExpression("Dear #{p} ${name};");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Set evars = expr.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
        Assert.assertTrue((boolean)this.contains(evars, Arrays.asList("name")));
        this.context.set("name", "Doe");
        JxltEngine.Expression phase1 = expr.prepare((JexlContext)this.context);
        String as = phase1.asString();
        Assert.assertEquals((Object)"Dear ${p} Doe;", (Object)as);
        Set evars1 = phase1.getVariables();
        Assert.assertEquals((long)1L, (long)evars1.size());
        Assert.assertTrue((boolean)this.contains(evars1, Arrays.asList("p")));
        this.vars.clear();
        this.context.set("p", "Mr");
        this.context.set("name", "Should not be used in 2nd phase");
        Object o = phase1.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        String p1 = this.getSource(phase1.toString());
        Assert.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(phase1.toString()));
        Assert.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testNested() throws Exception {
        String source = "#{${hi}+'.world'}";
        JxltEngine.Expression expr = JXLT.createExpression("#{${hi}+'.world'}");
        Set evars = expr.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
        Assert.assertTrue((boolean)this.contains(evars, Arrays.asList("hi")));
        this.context.set("hi", "greeting");
        this.context.set("greeting.world", "Hello World!");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testNestedTemplate() throws Exception {
        String source = "#{${hi}+'.world'}";
        JxltEngine.Template expr = JXLT.createTemplate("#{${hi}+'.world'}", new String[]{"hi"});
        this.context.set("greeting.world", "Hello World!");
        StringWriter strw = new StringWriter();
        expr.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{"greeting"});
        String o = strw.toString();
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testImmediate() throws Exception {
        JexlContext none = null;
        String source = "${'Hello ' + 'World!'}";
        JxltEngine.Expression expr = JXLT.createExpression("${'Hello ' + 'World!'}");
        JxltEngine.Expression prepared = expr.prepare(none);
        Assert.assertEquals((String)"prepare should return same expression", (Object)"Hello World!", (Object)prepared.asString());
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"${'Hello ' + 'World!'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant() throws Exception {
        JexlContext none = null;
        String source = "Hello World!";
        JxltEngine.Expression expr = JXLT.createExpression("Hello World!");
        Assert.assertTrue((String)"prepare should return same expression", (expr.prepare(none) == expr ? 1 : 0) != 0);
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"Hello World!", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant2() throws Exception {
        JexlContext none = null;
        String source = "${size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = JXLT.createExpression("${size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"${size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant3() throws Exception {
        JexlContext none = null;
        String source = "#{size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = JXLT.createExpression("#{size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"#{size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant4() throws Exception {
        JexlContext none = null;
        String source = "#{ ${size({'1':2,'2': 3})} }";
        JxltEngine.Expression expr = JXLT.createExpression("#{ ${size({'1':2,'2': 3})} }");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"#{ ${size({'1':2,'2': 3})} }", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testDeferred() throws Exception {
        JexlContext none = null;
        String source = "#{'world'}";
        JxltEngine.Expression expr = JXLT.createExpression("#{'world'}");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        String as = expr.prepare(none).asString();
        Assert.assertEquals((String)"prepare should return immediate version", (Object)"${'world'}", (Object)as);
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"world", (Object)o);
        Assert.assertEquals((Object)"#{'world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testEscape() throws Exception {
        JexlContext none = null;
        JxltEngine.Expression expr = JXLT.createExpression("\\#{'world'}");
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"#{'world'}", (Object)o);
        expr = JXLT.createExpression("\\${'world'}");
        o = expr.evaluate(none);
        Assert.assertEquals((Object)"${'world'}", (Object)o);
    }

    @Test
    public void testEscapeString() throws Exception {
        JxltEngine.Expression expr = JXLT.createExpression("\\\"${'world\\'s finest'}\\\"");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"\"world's finest\"", (Object)o);
    }

    @Test
    public void testNonEscapeString() throws Exception {
        JxltEngine.Expression expr = JXLT.createExpression("c:\\some\\windows\\path");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"c:\\some\\windows\\path", (Object)o);
    }

    @Test
    public void testMalformed() throws Exception {
        try {
            JxltEngine.Expression expr = JXLT.createExpression("${'world'");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    @Test
    public void testMalformedNested() throws Exception {
        try {
            JxltEngine.Expression expr = JXLT.createExpression("#{${hi} world}");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    @Test
    public void testMalformedNested2() throws Exception {
        try {
            JxltEngine.Expression expr = JXLT.createExpression("#{${hi} world}");
            MapContext ctxt = new MapContext();
            ctxt.set("hi", (Object)"hello");
            expr.evaluate((JexlContext)ctxt);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    @Test
    public void testBadContextNested() throws Exception {
        try {
            JxltEngine.Expression expr = JXLT.createExpression("#{${hi}+'.world'}");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOG.warn((Object)xmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharAtBug() throws Exception {
        this.context.set("foo", "abcdef");
        JxltEngine.Expression expr = JXLT.createExpression("${foo.substring(2,4)/*comment*/}");
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"cd", (Object)o);
        this.context.set("bar", "foo");
        try {
            this.context.setSilent(true);
            expr = JXLT.createExpression("#{${bar}+'.charAt(-2)'}");
            expr = expr.prepare((JexlContext)this.context);
            o = expr.evaluate((JexlContext)this.context);
            Assert.assertEquals(null, (Object)o);
        }
        finally {
            this.context.setSilent(false);
        }
    }

    @Test
    public void testTemplate0() throws Exception {
        String source = "   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = JXLT.createTemplate(source);
        this.context.set("x", 42);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        this.context.set("x", "");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"no x\n", (Object)output);
        String dstr = t.toString();
        Assert.assertNotNull((Object)dstr);
    }

    @Test
    public void testTemplate10() throws Exception {
        String source = "$$(x)->{ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ } }\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(source), (String[])null);
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        String[] ps = t.getParameters();
        Assert.assertTrue((boolean)Arrays.asList(ps).contains("x"));
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
    }

    @Test
    public void testTemplate1() throws Exception {
        String source = "$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(source), new String[]{"x"});
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{""});
        output = strw.toString();
        Assert.assertEquals((Object)"no x\n", (Object)output);
    }

    @Test
    public void testTemplate2() throws Exception {
        String source = "The answer: ${x}";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(source), new String[]{"x"});
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"The answer: 42", (Object)output);
    }

    @Test
    public void testPrepareTemplate() throws Exception {
        String source = "$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n";
        int[] args = new int[]{42};
        JxltEngine.Template tl10n = JXLT.createTemplate(source, new String[]{"list"});
        String dstr = tl10n.asString();
        Assert.assertNotNull((Object)dstr);
        Set vars = tl10n.getVariables();
        Assert.assertFalse((boolean)vars.isEmpty());
        this.context.set("l10n", "valeur");
        JxltEngine.Template tpFR = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", "value");
        JxltEngine.Template tpEN = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", null);
        StringWriter strw = new StringWriter();
        tpFR.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outFR = strw.toString();
        Assert.assertEquals((Object)"valeur=42\n", (Object)outFR);
        this.context.set("l10n", null);
        strw = new StringWriter();
        tpEN.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outEN = strw.toString();
        Assert.assertEquals((Object)"value=42\n", (Object)outEN);
    }

    @Test
    public void test42() throws Exception {
        String test42 = "$$ for(var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(test42), new String[]{"list"});
        StringWriter strw = new StringWriter();
        int[] list = new int[]{1, 3, 5, 42, 169};
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{list});
        String output = strw.toString();
        String out42 = "The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n";
        Assert.assertEquals((Object)out42, (Object)output);
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, (JxltEngine.Template)((TemplateScript)t));
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)test42, (Object)refactored);
    }

    @Test
    public void testWriter() throws Exception {
        Froboz froboz = new Froboz(42);
        FrobozWriter writer = new FrobozWriter(new StringWriter());
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader("$$$jexl.print(froboz)"), new String[]{"froboz"});
        t.evaluate((JexlContext)this.context, (Writer)writer, new Object[]{froboz});
        Assert.assertEquals((Object)"froboz{42}", (Object)((Object)writer).toString());
    }

    @Test
    public void testReport() throws Exception {
        String rpt = "<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(rpt), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        String ctl = "<report>\n\n\n\n\n        11\n</report>\n";
        Assert.assertEquals((Object)ctl, (Object)output);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, (JxltEngine.Template)((TemplateScript)t));
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)rpt, (Object)refactored);
    }

    @Test
    public void testReport1() throws Exception {
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(rpt), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", 42);
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReport2() throws Exception {
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader(rpt), new String[]{"x"});
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
        TemplateDebugger td = new TemplateDebugger();
        String xxx = JXLTTest.refactor(td, (JxltEngine.Template)((TemplateScript)t));
        Assert.assertNotNull((Object)xxx);
        Assert.assertEquals((Object)rpt, (Object)xxx);
    }

    @Test
    public void testOneLiner() throws Exception {
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader("fourty-two"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"fourty-two", (Object)output);
    }

    @Test
    public void testOneLinerVar() throws Exception {
        JxltEngine.Template t = JXLT.createTemplate("$$", (Reader)new StringReader("fourty-${x}"), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", "two");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"fourty-two", (Object)output);
    }

    @Test
    public void testInterpolation() throws Exception {
        String expr = "`Hello \n${user}`";
        JexlScript script = this.JEXL.createScript(expr);
        this.context.set("user", "Dimitri");
        Object value = script.execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"Hello \nDimitri", (Object)value);
        this.context.set("user", "Rahul");
        value = script.execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"Hello \nRahul", (Object)value);
    }

    @Test
    public void testInterpolationGlobal() throws Exception {
        String expr = "user='Dimitri'; `Hello \n${user}`";
        Object value = this.JEXL.createScript(expr).execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"Hello \nDimitri", (Object)value);
    }

    @Test
    public void testInterpolationLocal() throws Exception {
        String expr = "var user='Henrib'; `Hello \n${user}`";
        Object value = this.JEXL.createScript(expr).execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"Hello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationLvsG() throws Exception {
        String expr = "user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`";
        Object value = this.JEXL.createScript(expr).execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"H\"ello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationLvsG2() throws Exception {
        String expr = "user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`";
        Object value = this.JEXL.createScript(expr).execute((JexlContext)this.context);
        Assert.assertEquals((String)expr, (Object)"H`ello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationParameter() throws Exception {
        String expr = "(user)->{`Hello \n${user}`}";
        Object value = this.JEXL.createScript(expr).execute((JexlContext)this.context, new Object[]{"Henrib"});
        Assert.assertEquals((String)expr, (Object)"Hello \nHenrib", (Object)value);
        value = this.JEXL.createScript(expr).execute((JexlContext)this.context, new Object[]{"Dimitri"});
        Assert.assertEquals((String)expr, (Object)"Hello \nDimitri", (Object)value);
    }

    public static class FrobozWriter
    extends PrintWriter {
        public FrobozWriter(Writer w) {
            super(w);
        }

        public void print(Froboz froboz) {
            super.print("froboz{");
            super.print(froboz.value);
            super.print("}");
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public int plus10() {
            int i = this.value;
            this.value += 10;
            return i;
        }
    }
}

