/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.MathContext;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.MapContext;

public class JexlEvalContext
implements JexlContext,
JexlContext.NamespaceResolver,
JexlEngine.Options {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final JexlContext vars;
    private final JexlContext.NamespaceResolver ns;
    private Boolean silent = null;
    private Boolean strict = null;
    private Boolean cancellable = null;
    private Boolean mathStrict = null;
    private int mathScale = Integer.MIN_VALUE;
    private MathContext mathContext = null;

    public JexlEvalContext() {
        this(EMPTY_MAP);
    }

    public Charset getCharset() {
        return Charset.defaultCharset();
    }

    public JexlEvalContext(Map<String, Object> map) {
        this.vars = map == EMPTY_MAP ? new MapContext() : new MapContext(map);
        this.ns = null;
    }

    public JexlEvalContext(JexlContext context) {
        this(context, context instanceof JexlContext.NamespaceResolver ? (JexlContext.NamespaceResolver)context : null);
    }

    public JexlEvalContext(JexlContext context, JexlContext.NamespaceResolver namespace) {
        this.vars = context != null ? context : JexlEngine.EMPTY_CONTEXT;
        this.ns = namespace != null ? namespace : JexlEngine.EMPTY_NS;
    }

    public boolean has(String name) {
        return this.vars.has(name);
    }

    public Object get(String name) {
        return this.vars.get(name);
    }

    public void set(String name, Object value) {
        this.vars.set(name, value);
    }

    public Object resolveNamespace(String name) {
        return this.ns != null ? this.ns.resolveNamespace(name) : null;
    }

    public void clearOptions() {
        this.silent = null;
        this.strict = null;
        this.cancellable = null;
        this.mathScale = -1;
        this.mathContext = null;
    }

    public void setOptions(JexlEngine jexl) {
        this.silent = jexl.isSilent();
        this.strict = jexl.isStrict();
        this.mathScale = jexl.getArithmetic().getMathScale();
        this.mathContext = jexl.getArithmetic().getMathContext();
    }

    public void setSilent(boolean s) {
        this.silent = s ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isSilent() {
        return this.silent;
    }

    public void setCancellable(boolean c) {
        this.cancellable = c ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isCancellable() {
        return this.cancellable;
    }

    public void setStrict(Boolean se, Boolean sa) {
        Boolean bl = se == null ? null : (this.strict = se != false ? Boolean.TRUE : Boolean.FALSE);
        this.mathStrict = sa == null ? null : (sa != false ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStrict(boolean se) {
        this.setStrict(se, se);
    }

    public Boolean isStrict() {
        if (this.strict == null) {
            return null;
        }
        return this.strict != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setStrictArithmetic(boolean s) {
        this.mathStrict = s ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isStrictArithmetic() {
        if (this.mathStrict == null) {
            return null;
        }
        return this.mathStrict != false ? Boolean.TRUE : Boolean.FALSE;
    }

    public MathContext getArithmeticMathContext() {
        return this.mathContext;
    }

    public void setMathContext(MathContext mc) {
        this.mathContext = mc;
    }

    public int getArithmeticMathScale() {
        return this.mathScale;
    }

    public void setMathScale(int scale) {
        this.mathScale = scale;
    }
}

