/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.Util;
import org.junit.After;
import org.junit.Assert;

public class JexlTestCase {
    private static final Class<?>[] noParms = new Class[0];
    private static final Class<?>[] stringParm = new Class[]{String.class};
    protected final JexlEngine JEXL;

    public JexlTestCase(String name) {
        this(name, new JexlBuilder().strict(true).silent(false).cache(32).create());
    }

    protected JexlTestCase(String name, JexlEngine jexl) {
        this.JEXL = jexl;
    }

    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        JexlTestCase.debuggerCheck(this.JEXL);
    }

    public static JexlEngine createEngine(boolean lenient) {
        return new JexlBuilder().arithmetic(new JexlArithmetic(!lenient)).cache(512).create();
    }

    public static void debuggerCheck(JexlEngine ijexl) throws Exception {
        Util.debuggerCheck(ijexl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String name) throws Exception {
        if ("runTest".equals(name)) {
            return;
        }
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod(name, noParms);
        }
        catch (Exception xany) {
            Assert.fail((String)("no such test: " + name));
            return;
        }
        try {
            this.setUp();
            method.invoke((Object)this, new Object[0]);
        }
        finally {
            this.tearDown();
        }
    }

    public static void runTest(String tname, String mname) throws Exception {
        String testClassName = "org.apache.commons.jexl3." + tname;
        Class<?> clazz = null;
        JexlTestCase test = null;
        try {
            clazz = Class.forName(testClassName);
        }
        catch (ClassNotFoundException xclass) {
            Assert.fail((String)("no such class: " + testClassName));
            return;
        }
        Constructor<?> ctor = null;
        try {
            ctor = clazz.getConstructor(stringParm);
            test = (JexlTestCase)ctor.newInstance("debug");
        }
        catch (NoSuchMethodException xctor) {
            try {
                test = (JexlTestCase)clazz.newInstance();
            }
            catch (Exception xany) {
                Assert.fail((String)("cant instantiate test: " + xany));
                return;
            }
        }
        catch (Exception xany) {
            Assert.fail((String)("cant instantiate test: " + xany));
            return;
        }
        test.runTest(mname);
    }

    public static void main(String[] args) throws Exception {
        JexlTestCase.runTest(args[0], args[1]);
    }
}

