/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class PragmaTest
extends JexlTestCase {
    public PragmaTest() {
        super("PragmaTest");
    }

    @Test
    public void testPragmas() throws Exception {
        MapContext jc = new MapContext();
        try {
            JexlScript script = this.JEXL.createScript("#pragma one 1\n#pragma the.very.hard 'truth'\n2;");
            Assert.assertTrue((script != null ? 1 : 0) != 0);
            Map pragmas = script.getPragmas();
            Assert.assertEquals((long)2L, (long)pragmas.size());
            Assert.assertEquals((Object)1, pragmas.get("one"));
            Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
        }
        catch (JexlException xjexl) {
            String string = xjexl.toString();
        }
    }

    @Test
    public void testJxltPragmas() throws Exception {
        MapContext jc = new MapContext();
        try {
            JxltEngine engine = new JexlBuilder().create().createJxltEngine();
            JxltEngine.Template tscript = engine.createTemplate("$$ #pragma one 1\n$$ #pragma the.very.hard 'truth'\n2;");
            Assert.assertTrue((tscript != null ? 1 : 0) != 0);
            Map pragmas = tscript.getPragmas();
            Assert.assertEquals((long)2L, (long)pragmas.size());
            Assert.assertEquals((Object)1, pragmas.get("one"));
            Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
        }
        catch (JexlException xjexl) {
            String string = xjexl.toString();
        }
    }
}

