/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PublicFieldsTest
extends JexlTestCase {
    private static final String LOWER42 = "fourty-two";
    private static final String UPPER42 = "FOURTY-TWO";
    private Struct pub;
    private JexlContext ctxt;

    public PublicFieldsTest() {
        super("PublicFieldsTest");
    }

    @Override
    @Before
    public void setUp() {
        this.pub = new Struct();
        this.ctxt = new MapContext();
        this.ctxt.set("pub", (Object)this.pub);
    }

    @Test
    public void testGetInt() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.anInt");
        Assert.assertEquals((Object)42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "anInt", (Object)-42);
        Assert.assertEquals((Object)-42, (Object)get.evaluate(this.ctxt));
    }

    @Test
    public void testSetInt() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.anInt = value");
        this.ctxt.set("value", (Object)-42);
        Assert.assertEquals((Object)-42, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)-42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        this.ctxt.set("value", (Object)42);
        Assert.assertEquals((Object)42, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)42, (Object)this.JEXL.getProperty((Object)this.pub, "anInt"));
        try {
            this.ctxt.set("value", (Object)UPPER42);
            Assert.assertEquals(null, (Object)set.evaluate(this.ctxt));
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testGetString() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.aString");
        Assert.assertEquals((Object)LOWER42, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "aString", (Object)UPPER42);
        Assert.assertEquals((Object)UPPER42, (Object)get.evaluate(this.ctxt));
    }

    @Test
    public void testSetString() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.aString = value");
        this.ctxt.set("value", (Object)UPPER42);
        Assert.assertEquals((Object)UPPER42, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)UPPER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
        this.ctxt.set("value", (Object)LOWER42);
        Assert.assertEquals((Object)LOWER42, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)LOWER42, (Object)this.JEXL.getProperty((Object)this.pub, "aString"));
    }

    @Test
    public void testGetInnerDouble() throws Exception {
        JexlExpression get = this.JEXL.createExpression("pub.inner.aDouble");
        Assert.assertEquals((Object)42.0, (Object)get.evaluate(this.ctxt));
        this.JEXL.setProperty((Object)this.pub, "inner.aDouble", (Object)-42);
        Assert.assertEquals((Object)-42.0, (Object)get.evaluate(this.ctxt));
    }

    @Test
    public void testSetInnerDouble() throws Exception {
        JexlExpression set = this.JEXL.createExpression("pub.inner.aDouble = value");
        this.ctxt.set("value", (Object)-42.0);
        Assert.assertEquals((Object)-42.0, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)-42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        this.ctxt.set("value", (Object)42.0);
        Assert.assertEquals((Object)42.0, (Object)set.evaluate(this.ctxt));
        Assert.assertEquals((Object)42.0, (Object)this.JEXL.getProperty((Object)this.pub, "inner.aDouble"));
        try {
            this.ctxt.set("value", (Object)UPPER42);
            Assert.assertEquals(null, (Object)set.evaluate(this.ctxt));
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEnum() throws Exception {
        this.ctxt.set("com.jexl.gender", Gender.class);
        String src = "x = com.jexl.gender.FEMALE";
        JexlScript script = this.JEXL.createScript(src);
        Object result = script.execute(this.ctxt);
        Assert.assertEquals((Object)((Object)Gender.FEMALE), (Object)result);
        Assert.assertEquals((Object)((Object)Gender.FEMALE), (Object)this.ctxt.get("x"));
    }

    @Test
    public void testGetStaticField() throws Exception {
        this.ctxt.set("com.jexl", Inner.class);
        String src = "x = com.jexl.NOT42";
        JexlScript script = this.JEXL.createScript(src);
        Object result = script.execute(this.ctxt);
        Assert.assertEquals((Object)Inner.NOT42, (Object)result);
        Assert.assertEquals((Object)Inner.NOT42, (Object)this.ctxt.get("x"));
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }

    public static class Struct {
        public Inner inner = new Inner();
        public int anInt = 42;
        public String aString = "fourty-two";
    }

    public static class Inner {
        public double aDouble = 42.0;
        public static double NOT42 = -42.0;
    }
}

