/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class SetLiteralTest
extends JexlTestCase {
    public SetLiteralTest() {
        super("SetLiteralTest");
    }

    private static Set<?> createSet(Object ... args) {
        return new HashSet<Object>(Arrays.asList(args));
    }

    @Test
    public void testSetLiteralWithStrings() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{ 'foo' , 'bar' }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo", "bar");
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testLiteralWithOneEntry() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{ 'foo' }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo");
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testSetLiteralWithStringsScript() throws Exception {
        JexlScript e = this.JEXL.createScript("{ 'foo' , 'bar' }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo", "bar");
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testSetLiteralWithOneEntryScript() throws Exception {
        JexlScript e = this.JEXL.createScript("{ 'foo' }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo");
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testSetLiteralWithOneEntryBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("{ { 'foo' }; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet("foo");
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testSetLiteralWithNumbers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{ 5.0 , 10 }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Set<?> check = SetLiteralTest.createSet(new Double(5.0), new Integer(10));
        Assert.assertTrue((boolean)((Object)check).equals(o));
    }

    @Test
    public void testSetLiteralWithNulls() throws Exception {
        String[] exprs = new String[]{"{ 10 }", "{ 10 , null }", "{ 10 , null , 20}", "{ '10' , null }", "{ null, '10' , 20 }"};
        Set[] checks = new Set[]{SetLiteralTest.createSet(new Integer(10)), SetLiteralTest.createSet(new Integer(10), null), SetLiteralTest.createSet(new Integer(10), null, new Integer(20)), SetLiteralTest.createSet("10", null), SetLiteralTest.createSet(null, "10", new Integer(20))};
        MapContext jc = new MapContext();
        for (int t = 0; t < exprs.length; ++t) {
            JexlScript e = this.JEXL.createScript(exprs[t]);
            Object o = e.execute((JexlContext)jc);
            Assert.assertTrue((String)exprs[t], (boolean)((Object)checks[t]).equals(o));
        }
    }

    @Test
    public void testSizeOfSimpleSetLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' , 'bar'})");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)new Integer(2), (Object)o);
    }

    @Test
    public void testNotEmptySimpleSetLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("empty({ 'foo' , 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assert.assertFalse((boolean)((Boolean)o));
    }
}

