/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Map;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SideEffectTest
extends JexlTestCase {
    private Asserter asserter;

    public SideEffectTest() {
        super("SideEffectTest");
    }

    @Override
    @Before
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    @Test
    public void testSideEffectVar() throws Exception {
        Integer i41;
        Map<String, Object> context = this.asserter.getVariables();
        Integer foo = i41 = Integer.valueOf(4141);
        context.put("foo", foo);
        this.asserter.assertExpression("foo += 2", i41 + 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 + 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo -= 2", i41 - 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 - 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo *= 2", i41 * 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 * 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo /= 2", i41 / 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 / 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo %= 2", i41 % 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 % 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo &= 3", i41 & 3);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 & 3));
        context.put("foo", foo);
        this.asserter.assertExpression("foo |= 2", i41 | 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 | 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo ^= 2", i41 ^ 2);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectVarDots() throws Exception {
        Integer i41;
        Map<String, Object> context = this.asserter.getVariables();
        Integer foo = i41 = Integer.valueOf(4141);
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux += 2", i41 + 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 + 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux -= 2", i41 - 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 - 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux *= 2", i41 * 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 * 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux /= 2", i41 / 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 / 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux %= 2", i41 % 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 % 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux &= 3", i41 & 3);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 & 3));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux |= 2", i41 | 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 | 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux ^= 2", i41 ^ 2);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        String s43 = "fourty-three";
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] += 2", i41 + 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] -= 2", i41 - 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] *= 2", i41 * 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] /= 2", i41 / 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] %= 2", i41 % 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] &= 3", i41 & 3);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] |= 2", i41 | 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] ^= 2", i41 ^ 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectDotArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        String s43 = "fourty-three";
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 += 2", i41 + 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 -= 2", i41 - 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 *= 2", i41 * 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 /= 2", i41 / 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 %= 2", i41 % 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 &= 3", i41 & 3);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 |= 2", i41 | 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 ^= 2", i41 ^ 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectAntishArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo.bar", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] += 2", i41 + 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] -= 2", i41 - 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] *= 2", i41 * 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] /= 2", i41 / 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] %= 2", i41 % 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] &= 3", i41 & 3);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] |= 2", i41 | 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] ^= 2", i41 ^ 2);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectBean() throws Exception {
        Integer i41 = 4141;
        Foo foo = new Foo(0);
        this.asserter.setVariable("foo", foo);
        foo.value = i41;
        this.asserter.assertExpression("foo.value += 2", i41 + 2);
        Assert.assertEquals((long)foo.value, (long)(i41 + 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value -= 2", i41 - 2);
        Assert.assertEquals((long)foo.value, (long)(i41 - 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value *= 2", i41 * 2);
        Assert.assertEquals((long)foo.value, (long)(i41 * 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value /= 2", i41 / 2);
        Assert.assertEquals((long)foo.value, (long)(i41 / 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value %= 2", i41 % 2);
        Assert.assertEquals((long)foo.value, (long)(i41 % 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value &= 3", i41 & 3);
        Assert.assertEquals((long)foo.value, (long)(i41 & 3));
        foo.value = i41;
        this.asserter.assertExpression("foo.value |= 2", i41 | 2);
        Assert.assertEquals((long)foo.value, (long)(i41 | 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value ^= 2", i41 ^ 2);
        Assert.assertEquals((long)foo.value, (long)(i41 ^ 2));
    }

    @Test
    public void testSideEffectBeanContainer() throws Exception {
        Integer i41 = 4141;
        Foo foo = new Foo(0);
        this.asserter.setVariable("foo", foo);
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] += 2", i41 + 2);
        Assert.assertEquals((long)foo.value, (long)(i41 + 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[1] += 2", i41 + 3);
        Assert.assertEquals((long)foo.value, (long)(i41 + 4));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] -= 2", i41 - 2);
        Assert.assertEquals((long)foo.value, (long)(i41 - 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] *= 2", i41 * 2);
        Assert.assertEquals((long)foo.value, (long)(i41 * 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] /= 2", i41 / 2);
        Assert.assertEquals((long)foo.value, (long)(i41 / 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] %= 2", i41 % 2);
        Assert.assertEquals((long)foo.value, (long)(i41 % 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] &= 3", i41 & 3);
        Assert.assertEquals((long)foo.value, (long)(i41 & 3));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] |= 2", i41 | 2);
        Assert.assertEquals((long)foo.value, (long)(i41 | 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] ^= 2", i41 ^ 2);
        Assert.assertEquals((long)foo.value, (long)(i41 ^ 2));
    }

    @Test
    public void testArithmeticSelf() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfOverload(jexl, jc);
        this.runSelfOverload(jexl, jc);
    }

    @Test
    public void testArithmeticSelfNoCache() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(0).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfOverload(jexl, jc);
    }

    protected void runSelfOverload(JexlEngine jexl, JexlContext jc) {
        JexlScript script = jexl.createScript("(x, y)->{ x += y }");
        Object result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3130, (Object)result);
        Var v0 = new Var(3115);
        result = script.execute(jc, new Object[]{v0, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v0);
        Assert.assertEquals((long)3130L, (long)v0.value);
        script = jexl.createScript("(x, y)->{ x -= y}");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3100, (Object)result);
        Var v1 = new Var(3115);
        result = script.execute(jc, new Object[]{v1, new Var(15)});
        Assert.assertNotEquals((Object)result, (Object)v1);
        Assert.assertEquals((long)3100L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x *= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)46725, (Object)result);
        Var v2 = new Var(3115);
        result = script.execute(jc, new Object[]{v2, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v2);
        Assert.assertEquals((long)46725L, (long)v2.value);
        script = jexl.createScript("(x, y)->{ x /= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)207, (Object)result);
        Var v3 = new Var(3115);
        result = script.execute(jc, new Object[]{v3, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v3);
        Assert.assertEquals((long)207L, (long)v3.value);
        script = jexl.createScript("(x, y)->{ x %= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)10, (Object)result);
        Var v4 = new Var(3115);
        result = script.execute(jc, new Object[]{v4, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v4);
        Assert.assertEquals((long)10L, (long)v4.value);
        script = jexl.createScript("(x, y)->{ x &= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)11L, (Object)result);
        Var v5 = new Var(3115);
        result = script.execute(jc, new Object[]{v5, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v5);
        Assert.assertEquals((long)11L, (long)v5.value);
        script = jexl.createScript("(x, y)->{ x |= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3119L, (Object)result);
        Var v6 = new Var(3115);
        result = script.execute(jc, new Object[]{v6, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v6);
        Assert.assertEquals((long)3119L, (long)v6.value);
        script = jexl.createScript("(x, y)->{ x ^= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3108L, (Object)result);
        Var v7 = new Var(3115);
        result = script.execute(jc, new Object[]{v7, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v7);
        Assert.assertEquals((long)3108L, (long)v7.value);
    }

    @Test
    public void testOverrideGetSet() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        Var v0 = new Var(3115);
        JexlScript script = jexl.createScript("(x)->{ x.value}");
        Object result = script.execute(jc, new Object[]{v0});
        Assert.assertEquals((Object)3115, (Object)result);
        script = jexl.createScript("(x)->{ x['VALUE']}");
        result = script.execute(jc, new Object[]{v0});
        Assert.assertEquals((Object)3115, (Object)result);
        script = jexl.createScript("(x,y)->{ x.value = y}");
        result = script.execute(jc, new Object[]{v0, 42});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("(x,y)->{ x['VALUE'] = y}");
        result = script.execute(jc, new Object[]{v0, 169});
        Assert.assertEquals((Object)169, (Object)result);
    }

    public static class SelfArithmetic
    extends JexlArithmetic {
        public SelfArithmetic(boolean strict) {
            super(strict);
        }

        public Object propertyGet(Var var, String property) {
            return "value".equals(property) ? Integer.valueOf(var.value) : JexlEngine.TRY_FAILED;
        }

        public Object propertySet(Var var, String property, int v) {
            Object object;
            if ("value".equals(property)) {
                var.value = v;
                object = var.value;
            } else {
                object = JexlEngine.TRY_FAILED;
            }
            return object;
        }

        public Object arrayGet(Var var, String property) {
            return "VALUE".equals(property) ? Integer.valueOf(var.value) : JexlEngine.TRY_FAILED;
        }

        public Object arraySet(Var var, String property, int v) {
            Object object;
            if ("VALUE".equals(property)) {
                var.value = v;
                object = var.value;
            } else {
                object = JexlEngine.TRY_FAILED;
            }
            return object;
        }

        public JexlOperator selfAdd(Var lhs, Var rhs) {
            lhs.value += rhs.value;
            return JexlOperator.ASSIGN;
        }

        public Var selfSubtract(Var lhs, Var rhs) {
            return new Var(lhs.value - rhs.value);
        }

        public JexlOperator selfDivide(Var lhs, Var rhs) {
            lhs.value /= rhs.value;
            return JexlOperator.ASSIGN;
        }

        public JexlOperator selfMultiply(Var lhs, Var rhs) {
            lhs.value *= rhs.value;
            return JexlOperator.ASSIGN;
        }

        public JexlOperator selfMod(Var lhs, Var rhs) {
            lhs.value %= rhs.value;
            return JexlOperator.ASSIGN;
        }

        public Var and(Var lhs, Var rhs) {
            return new Var(lhs.value & rhs.value);
        }

        public JexlOperator selfAnd(Var lhs, Var rhs) {
            lhs.value &= rhs.value;
            return JexlOperator.ASSIGN;
        }

        public Var or(Var lhs, Var rhs) {
            return new Var(lhs.value | rhs.value);
        }

        public JexlOperator selfOr(Var lhs, Var rhs) {
            lhs.value |= rhs.value;
            return JexlOperator.ASSIGN;
        }

        public Var xor(Var lhs, Var rhs) {
            return new Var(lhs.value ^ rhs.value);
        }

        public JexlOperator selfXor(Var lhs, Var rhs) {
            lhs.value ^= rhs.value;
            return JexlOperator.ASSIGN;
        }
    }

    public static class Var {
        int value;

        Var(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static class Foo {
        int value;

        Foo(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public void setValue(long v) {
            this.value = (int)v;
        }

        public int getValue() {
            return this.value;
        }

        public void setBar(int x, long v) {
            this.value = (int)v + x;
        }

        public int getBar(int x) {
            return this.value + x;
        }
    }
}

