/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.SynchronizedArithmetic;
import org.apache.commons.jexl3.SynchronizedContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SynchronizedOverloadsTest
extends JexlTestCase {
    public SynchronizedOverloadsTest() {
        super("SynchronizedOverloadsTest", null);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Test
    public void testSynchronizer() throws Exception {
        TreeMap<String, Class<SynchronizedContext>> ns = new TreeMap<String, Class<SynchronizedContext>>();
        ns.put("synchronized", SynchronizedContext.class);
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        JexlScript js0 = jexl.createScript("synchronized:call(x, (y)->{y.size()})", new String[]{"x"});
        Object size = js0.execute((JexlContext)jc, new Object[]{"foobar"});
        Assert.assertEquals((Object)6, (Object)size);
    }

    @Test
    public void testSynchronized() throws Exception {
        TreeMap ns = new TreeMap();
        SynchronizedContext jc = new SynchronizedContext((JexlContext)new MapContext());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        JexlScript js0 = jexl.createScript("@synchronized(y) {return y.size(); }", new String[]{"y"});
        Object size = js0.execute((JexlContext)jc, new Object[]{"foobar"});
        Assert.assertEquals((Object)6, (Object)size);
    }

    @Test
    public void testUnsafeMonitor() throws Exception {
        SynchronizedArithmetic.UnsafeMonitor monitor = new SynchronizedArithmetic.UnsafeMonitor();
        TreeMap<String, Integer> foo = new TreeMap<String, Integer>();
        foo.put("one", 1);
        foo.put("two", 2);
        foo.put("three", 3);
        SynchronizedContext jc = new SynchronizedContext((JexlContext)new MapContext());
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new SynchronizedArithmetic(monitor, true)).create();
        JexlScript js0 = jexl.createScript("x['four'] = 4; var t = 0.0; for(var z: x) { t += z; }; call(t, (y)->{return y});", new String[]{"x"});
        Object t = js0.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)10.0, (Object)t);
        Assert.assertTrue((boolean)monitor.isBalanced());
        Assert.assertEquals((long)2L, (long)monitor.getCount());
        t = js0.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)10.0, (Object)t);
        Assert.assertTrue((boolean)monitor.isBalanced());
        Assert.assertEquals((long)4L, (long)monitor.getCount());
    }
}

