/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.IntegerRange;
import org.apache.commons.jexl3.internal.LongRange;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeTest
extends JexlTestCase {
    public RangeTest() {
        super("InternalTest");
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private void checkIteration(LongRange lr, long first, long last) throws Exception {
        Iterator ii = lr.iterator();
        if (ii.hasNext()) {
            long l = (Long)ii.next();
            Assert.assertEquals((long)first, (long)l);
            while (ii.hasNext()) {
                l = (Long)ii.next();
            }
            Assert.assertEquals((long)last, (long)l);
        } else {
            Assert.fail((String)"empty iterator?");
        }
    }

    private void checkIteration(IntegerRange ir, int first, int last) throws Exception {
        Iterator ii = ir.iterator();
        if (ii.hasNext()) {
            int l = (Integer)ii.next();
            Assert.assertEquals((long)first, (long)l);
            while (ii.hasNext()) {
                l = (Integer)ii.next();
            }
            Assert.assertEquals((long)last, (long)l);
        } else {
            Assert.fail((String)"empty iterator?");
        }
    }

    @Test
    public void testRanges() throws Exception {
        LongRange lr0 = LongRange.create((long)20L, (long)10L);
        Assert.assertEquals((long)10L, (long)lr0.getMin());
        Assert.assertEquals((long)20L, (long)lr0.getMax());
        Assert.assertFalse((boolean)lr0.isEmpty());
        Assert.assertTrue((boolean)lr0.contains((Object)10L));
        Assert.assertTrue((boolean)lr0.contains((Object)20L));
        Assert.assertFalse((boolean)lr0.contains((Object)30L));
        Assert.assertFalse((boolean)lr0.contains((Object)5L));
        Assert.assertFalse((boolean)lr0.contains(null));
        this.checkIteration(lr0, 20L, 10L);
        LongRange lr1 = LongRange.create((long)10L, (long)20L);
        this.checkIteration(lr1, 10L, 20L);
        Assert.assertTrue((boolean)lr0.containsAll((Collection)lr1));
        LongRange lr2 = LongRange.create((long)10L, (long)15L);
        Assert.assertNotEquals((Object)lr0, (Object)lr2);
        Assert.assertTrue((boolean)lr0.containsAll((Collection)lr2));
        Assert.assertFalse((boolean)lr2.containsAll((Collection)lr1));
        IntegerRange ir0 = IntegerRange.create((int)20, (int)10);
        this.checkIteration(ir0, 20, 10);
        Assert.assertEquals((long)10L, (long)ir0.getMin());
        Assert.assertEquals((long)20L, (long)ir0.getMax());
        Assert.assertFalse((boolean)ir0.isEmpty());
        Assert.assertTrue((boolean)ir0.contains((Object)10));
        Assert.assertTrue((boolean)ir0.contains((Object)20));
        Assert.assertFalse((boolean)ir0.contains((Object)30));
        Assert.assertFalse((boolean)ir0.contains((Object)5));
        Assert.assertFalse((boolean)ir0.contains(null));
        IntegerRange ir1 = IntegerRange.create((int)10, (int)20);
        this.checkIteration(ir1, 10, 20);
        Assert.assertTrue((boolean)ir0.containsAll((Collection)ir1));
        Assert.assertNotEquals((Object)ir0, (Object)lr0);
        Assert.assertNotEquals((Object)ir1, (Object)lr1);
        IntegerRange ir2 = IntegerRange.create((int)10, (int)15);
        Assert.assertNotEquals((Object)ir0, (Object)ir2);
        Assert.assertTrue((boolean)ir0.containsAll((Collection)ir2));
        Assert.assertFalse((boolean)ir2.containsAll((Collection)ir1));
        long lc0 = 20L;
        Iterator il0 = lr0.iterator();
        while (il0.hasNext()) {
            long v0 = (Long)il0.next();
            Assert.assertEquals((long)lc0, (long)v0);
            try {
                switch ((int)v0) {
                    case 10: {
                        il0.remove();
                        Assert.fail();
                        break;
                    }
                    case 11: {
                        lr1.add(Long.valueOf(v0));
                        Assert.fail();
                        break;
                    }
                    case 12: {
                        lr1.remove((Object)v0);
                        Assert.fail();
                        break;
                    }
                    case 13: {
                        lr1.addAll(Arrays.asList(v0));
                        Assert.fail();
                        break;
                    }
                    case 14: {
                        lr1.removeAll(Arrays.asList(v0));
                        Assert.fail();
                        break;
                    }
                    case 15: {
                        lr1.retainAll(Arrays.asList(v0));
                        Assert.fail();
                    }
                }
            }
            catch (UnsupportedOperationException xuo) {
                // empty catch block
            }
            --lc0;
        }
        Assert.assertEquals((long)9L, (long)lc0);
        try {
            il0.next();
            Assert.fail();
        }
        catch (NoSuchElementException xns) {
            // empty catch block
        }
        int ic0 = 20;
        Iterator ii0 = ir0.iterator();
        while (ii0.hasNext()) {
            int v0 = (Integer)ii0.next();
            Assert.assertEquals((long)ic0, (long)v0);
            try {
                switch (v0) {
                    case 10: {
                        ii0.remove();
                        Assert.fail();
                        break;
                    }
                    case 11: {
                        ir1.add(Integer.valueOf(v0));
                        Assert.fail();
                        break;
                    }
                    case 12: {
                        ir1.remove((Object)v0);
                        Assert.fail();
                        break;
                    }
                    case 13: {
                        ir1.addAll(Arrays.asList(v0));
                        Assert.fail();
                        break;
                    }
                    case 14: {
                        ir1.removeAll(Arrays.asList(v0));
                        Assert.fail();
                        break;
                    }
                    case 15: {
                        ir1.retainAll(Arrays.asList(v0));
                        Assert.fail();
                    }
                }
            }
            catch (UnsupportedOperationException xuo) {
                // empty catch block
            }
            --ic0;
        }
        Assert.assertEquals((long)9L, (long)ic0);
        try {
            ii0.next();
            Assert.fail();
        }
        catch (NoSuchElementException xns) {
            // empty catch block
        }
    }
}

