/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.introspection.AbstractExecutor;
import org.apache.commons.jexl3.internal.introspection.DuckGetExecutor;
import org.apache.commons.jexl3.internal.introspection.DuckSetExecutor;
import org.apache.commons.jexl3.internal.introspection.ListGetExecutor;
import org.apache.commons.jexl3.internal.introspection.ListSetExecutor;
import org.apache.commons.jexl3.internal.introspection.MapGetExecutor;
import org.apache.commons.jexl3.internal.introspection.MapSetExecutor;
import org.apache.commons.jexl3.internal.introspection.PropertyGetExecutor;
import org.apache.commons.jexl3.internal.introspection.PropertySetExecutor;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.junit.Assert;
import org.junit.Test;

public class DiscoveryTest
extends JexlTestCase {
    public DiscoveryTest() {
        super("DiscoveryTest");
    }

    @Test
    public void testBeanIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        Bean bean = new Bean("JEXL", "LXEJ");
        JexlPropertyGet get = uber.getPropertyGet((Object)bean, (Object)"value");
        JexlPropertySet set = uber.getPropertySet((Object)bean, (Object)"value", (Object)"foo");
        Assert.assertTrue((String)"bean property getter", (boolean)(get instanceof PropertyGetExecutor));
        Assert.assertTrue((String)"bean property setter", (boolean)(set instanceof PropertySetExecutor));
        Assert.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)bean, (Object)"value"));
        Assert.assertEquals((Object)set, (Object)uber.getPropertySet((Object)bean, (Object)"value", (Object)"foo"));
        Assert.assertFalse((boolean)get.equals(uber.getPropertyGet((Object)bean, (Object)"eulav")));
        Assert.assertFalse((boolean)set.equals(uber.getPropertySet((Object)bean, (Object)"eulav", (Object)"foo")));
        Object bar = set.invoke((Object)bean, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)bar);
        Assert.assertEquals((Object)"bar", (Object)get.invoke((Object)bean));
        Object quux = set.tryInvoke((Object)bean, (Object)"value", (Object)"quux");
        Assert.assertEquals((Object)"quux", (Object)quux);
        Assert.assertEquals((Object)"quux", (Object)get.invoke((Object)bean));
        Assert.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke((Object)bean, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testDuckIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        Duck duck = new Duck("JEXL", "LXEJ");
        JexlPropertyGet get = uber.getPropertyGet((Object)duck, (Object)"value");
        JexlPropertySet set = uber.getPropertySet((Object)duck, (Object)"value", (Object)"foo");
        Assert.assertTrue((String)"duck property getter", (boolean)(get instanceof DuckGetExecutor));
        Assert.assertTrue((String)"duck property setter", (boolean)(set instanceof DuckSetExecutor));
        Assert.assertEquals((Object)get, (Object)uber.getPropertyGet((Object)duck, (Object)"value"));
        Assert.assertEquals((Object)set, (Object)uber.getPropertySet((Object)duck, (Object)"value", (Object)"foo"));
        Assert.assertFalse((boolean)get.equals(uber.getPropertyGet((Object)duck, (Object)"eulav")));
        Assert.assertFalse((boolean)set.equals(uber.getPropertySet((Object)duck, (Object)"eulav", (Object)"foo")));
        Object bar = set.invoke((Object)duck, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)bar);
        Assert.assertEquals((Object)"bar", (Object)get.invoke((Object)duck));
        Object quux = set.tryInvoke((Object)duck, (Object)"value", (Object)"quux");
        Assert.assertEquals((Object)"quux", (Object)quux);
        Assert.assertEquals((Object)"quux", (Object)get.invoke((Object)duck));
        Assert.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke((Object)duck, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testListIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        ArrayList<String> list = new ArrayList<String>();
        list.add("LIST");
        list.add("TSIL");
        JexlPropertyGet get = uber.getPropertyGet(list, (Object)1);
        JexlPropertySet set = uber.getPropertySet(list, (Object)1, (Object)"foo");
        Assert.assertTrue((String)"list property getter", (boolean)(get instanceof ListGetExecutor));
        Assert.assertTrue((String)"list property setter", (boolean)(set instanceof ListSetExecutor));
        Assert.assertEquals((Object)get, (Object)uber.getPropertyGet(list, (Object)1));
        Assert.assertEquals((Object)set, (Object)uber.getPropertySet(list, (Object)1, (Object)"foo"));
        Assert.assertFalse((boolean)get.equals(uber.getPropertyGet(list, (Object)0)));
        Assert.assertFalse((boolean)get.equals(uber.getPropertySet(list, (Object)0, (Object)"foo")));
        Object bar = set.invoke(list, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)bar);
        Assert.assertEquals((Object)"bar", (Object)get.invoke(list));
        Object quux = set.tryInvoke(list, (Object)1, (Object)"quux");
        Assert.assertEquals((Object)"quux", (Object)quux);
        Assert.assertEquals((Object)"quux", (Object)get.invoke(list));
        Assert.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke(list, (Object)"eulav", (Object)"nope"));
    }

    @Test
    public void testMapIntrospection() throws Exception {
        Uberspect uber = Engine.getUberspect(null, null);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", "MAP");
        map.put("eulav", "PAM");
        JexlPropertyGet get = uber.getPropertyGet(map, (Object)"value");
        JexlPropertySet set = uber.getPropertySet(map, (Object)"value", (Object)"foo");
        Assert.assertTrue((String)"map property getter", (boolean)(get instanceof MapGetExecutor));
        Assert.assertTrue((String)"map property setter", (boolean)(set instanceof MapSetExecutor));
        Assert.assertEquals((Object)get, (Object)uber.getPropertyGet(map, (Object)"value"));
        Assert.assertEquals((Object)set, (Object)uber.getPropertySet(map, (Object)"value", (Object)"foo"));
        Assert.assertFalse((boolean)get.equals(uber.getPropertyGet(map, (Object)"eulav")));
        Assert.assertFalse((boolean)get.equals(uber.getPropertySet(map, (Object)"eulav", (Object)"foo")));
        Object bar = set.invoke(map, (Object)"bar");
        Assert.assertEquals((Object)"bar", (Object)bar);
        Assert.assertEquals((Object)"bar", (Object)get.invoke(map));
        Object quux = set.tryInvoke(map, (Object)"value", (Object)"quux");
        Assert.assertEquals((Object)"quux", (Object)quux);
        Assert.assertEquals((Object)"quux", (Object)get.invoke(map));
        Assert.assertEquals((Object)AbstractExecutor.TRY_FAILED, (Object)set.tryInvoke(map, (Object)1, (Object)"nope"));
    }

    public static class Bean {
        private String value;
        private String eulav;
        private boolean flag;

        public Bean(String v, String e) {
            this.value = v;
            this.eulav = e;
            this.flag = true;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
            this.value = v;
        }

        public String getEulav() {
            return this.eulav;
        }

        public void setEulav(String v) {
            this.eulav = v;
        }

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean f) {
            this.flag = f;
        }
    }

    public static class Duck {
        private String value;
        private String eulav;

        public Duck(String v, String e) {
            this.value = v;
            this.eulav = e;
        }

        public String get(String prop) {
            if ("value".equals(prop)) {
                return this.value;
            }
            if ("eulav".equals(prop)) {
                return this.eulav;
            }
            return "no such property";
        }

        public void set(String prop, String v) {
            if ("value".equals(prop)) {
                this.value = v;
            } else if ("eulav".equals(prop)) {
                this.eulav = v;
            }
        }
    }
}

