/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.introspection;

import java.io.File;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class SandboxTest
extends JexlTestCase {
    static final Log LOGGER = LogFactory.getLog((String)SandboxTest.class.getName());

    public SandboxTest() {
        super("SandboxTest");
    }

    @Test
    public void testCtorBlack() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        JexlScript script = this.JEXL.createScript(expr);
        Object result = script.execute(null);
        Assert.assertEquals((Object)"42", (Object)((Foo)result).getName());
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.black(Foo.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        script = sjexl.createScript(expr);
        try {
            result = script.execute(null);
            Assert.fail((String)"ctor should not be accessible");
        }
        catch (JexlException.Method xmethod) {
            LOGGER.info((Object)xmethod.toString());
        }
    }

    @Test
    public void testMethodBlack() throws Exception {
        String expr = "foo.Quux()";
        JexlScript script = this.JEXL.createScript(expr, new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        Assert.assertEquals((Object)foo.Quux(), (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.black(Foo.class.getName()).execute(new String[]{"Quux"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        script = sjexl.createScript(expr, new String[]{"foo"});
        try {
            result = script.execute(null, new Object[]{foo});
            Assert.fail((String)"Quux should not be accessible");
        }
        catch (JexlException.Method xmethod) {
            LOGGER.info((Object)xmethod.toString());
        }
    }

    @Test
    public void testGetBlack() throws Exception {
        String expr = "foo.alias";
        JexlScript script = this.JEXL.createScript(expr, new String[]{"foo"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo});
        Assert.assertEquals((Object)foo.alias, (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.black(Foo.class.getName()).read(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        script = sjexl.createScript(expr, new String[]{"foo"});
        try {
            result = script.execute(null, new Object[]{foo});
            Assert.fail((String)"alias should not be accessible");
        }
        catch (JexlException.Property xvar) {
            LOGGER.info((Object)xvar.toString());
        }
    }

    @Test
    public void testSetBlack() throws Exception {
        String expr = "foo.alias = $0";
        JexlScript script = this.JEXL.createScript(expr, new String[]{"foo", "$0"});
        Foo foo = new Foo("42");
        Object result = script.execute(null, new Object[]{foo, "43"});
        Assert.assertEquals((Object)"43", (Object)result);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.black(Foo.class.getName()).write(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        script = sjexl.createScript(expr, new String[]{"foo", "$0"});
        try {
            result = script.execute(null, new Object[]{foo, "43"});
            Assert.fail((String)"alias should not be accessible");
        }
        catch (JexlException.Property xvar) {
            LOGGER.info((Object)xvar.toString());
        }
    }

    @Test
    public void testCantSeeMe() throws Exception {
        MapContext jc = new MapContext();
        String expr = "foo.doIt()";
        Object result = null;
        JexlSandbox sandbox = new JexlSandbox(false);
        sandbox.white(Foo.class.getName());
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        jc.set("foo", (Object)new CantSeeMe());
        JexlScript script = sjexl.createScript(expr);
        try {
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"should have failed, doIt()");
        }
        catch (JexlException xany) {
            // empty catch block
        }
        jc.set("foo", (Object)new Foo("42"));
        result = script.execute((JexlContext)jc);
        Assert.assertEquals((long)42L, (long)((Integer)result).intValue());
    }

    @Test
    public void testCtorWhite() throws Exception {
        String expr = "new('" + Foo.class.getName() + "', '42')";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.white(Foo.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        JexlScript script = sjexl.createScript(expr);
        Object result = script.execute(null);
        Assert.assertEquals((Object)"42", (Object)((Foo)result).getName());
    }

    @Test
    public void testMethodWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.Quux()";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.white(Foo.class.getName()).execute(new String[]{"Quux"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        JexlScript script = sjexl.createScript(expr, new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        Assert.assertEquals((Object)foo.Quux(), (Object)result);
    }

    @Test
    public void testMethodNoJexl() throws Exception {
        Foo foo = new Foo("42");
        String[] exprs = new String[]{"foo.cantCallMe()", "foo.tryMe()", "foo.tryMeARiver()", "foo.callMeNot()", "foo.NONO", "new('org.apache.commons.jexl3.SandboxTest$Foo', 'one', 'two')"};
        JexlEngine sjexl = new JexlBuilder().strict(true).create();
        for (String expr : exprs) {
            JexlScript script = sjexl.createScript(expr, new String[]{"foo"});
            try {
                Object result = script.execute(null, new Object[]{foo});
                Assert.fail((String)"should have not been possible");
            }
            catch (JexlException.Method xjm) {
                LOGGER.info((Object)xjm.toString());
            }
            catch (JexlException.Property xjm) {
                LOGGER.info((Object)xjm.toString());
            }
        }
    }

    @Test
    public void testGetWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.white(Foo.class.getName()).read(new String[]{"alias"});
        sandbox.get(Foo.class.getName()).read().alias("alias", "ALIAS");
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        JexlScript script = sjexl.createScript(expr, new String[]{"foo"});
        Object result = script.execute(null, new Object[]{foo});
        Assert.assertEquals((Object)foo.alias, (Object)result);
        script = sjexl.createScript("foo.ALIAS", new String[]{"foo"});
        result = script.execute(null, new Object[]{foo});
        Assert.assertEquals((Object)foo.alias, (Object)result);
    }

    @Test
    public void testSetWhite() throws Exception {
        Foo foo = new Foo("42");
        String expr = "foo.alias = $0";
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.white(Foo.class.getName()).write(new String[]{"alias"});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        JexlScript script = sjexl.createScript(expr, new String[]{"foo", "$0"});
        Object result = script.execute(null, new Object[]{foo, "43"});
        Assert.assertEquals((Object)"43", (Object)result);
        Assert.assertEquals((Object)"43", (Object)foo.alias);
    }

    @Test
    public void testRestrict() throws Exception {
        Object result;
        MapContext context = new MapContext();
        context.set("System", System.class);
        JexlSandbox sandbox = new JexlSandbox();
        sandbox.white(System.class.getName()).execute(new String[]{"currentTimeMillis"});
        sandbox.black(File.class.getName()).execute(new String[]{""});
        JexlEngine sjexl = new JexlBuilder().sandbox(sandbox).strict(true).create();
        JexlScript script = sjexl.createScript("System.exit()");
        try {
            result = script.execute((JexlContext)context);
            Assert.fail((String)"should not allow calling exit!");
        }
        catch (JexlException xjexl) {
            LOGGER.info((Object)xjexl.toString());
        }
        script = sjexl.createScript("System.exit(1)");
        try {
            result = script.execute((JexlContext)context);
            Assert.fail((String)"should not allow calling exit!");
        }
        catch (JexlException xjexl) {
            LOGGER.info((Object)xjexl.toString());
        }
        script = sjexl.createScript("new('java.io.File', '/tmp/should-not-be-created')");
        try {
            result = script.execute((JexlContext)context);
            Assert.fail((String)"should not allow creating a file");
        }
        catch (JexlException xjexl) {
            LOGGER.info((Object)xjexl.toString());
        }
        String expr = "System.currentTimeMillis()";
        script = sjexl.createScript("System.currentTimeMillis()");
        result = script.execute((JexlContext)context);
        Assert.assertNotNull((Object)result);
    }

    public static class Foo
    extends CallMeNot
    implements CantCallMe,
    TryCallMe {
        String name;
        public String alias;

        @NoJexl
        public Foo(String name, String notcallable) {
            throw new RuntimeException("should not be callable!");
        }

        public Foo(String name) {
            this.name = name;
            this.alias = name + "-alias";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String Quux() {
            return this.name + "-quux";
        }

        public int doIt() {
            return 42;
        }

        @NoJexl
        public String cantCallMe() {
            throw new RuntimeException("should not be callable!");
        }

        @Override
        public void tryMe() {
            throw new RuntimeException("should not be callable!");
        }

        @Override
        public void tryMeARiver() {
            throw new RuntimeException("should not be callable!");
        }
    }

    public static abstract class CallMeNot {
        @NoJexl
        public String NONO = "should not be accessible!";

        @NoJexl
        public void callMeNot() {
            throw new RuntimeException("should not be callable!");
        }
    }

    public static interface TryCallMe {
        @NoJexl
        public void tryMeARiver();
    }

    @NoJexl
    public static interface CantCallMe {
        public void tryMe();
    }

    public static class CantSeeMe {
        public boolean doIt() {
            return false;
        }
    }
}

