/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.junit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;

public class Asserter
extends Assert {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private final JexlEvalContext context = new JexlEvalContext(this.variables);
    private final JexlEngine engine;

    public Asserter(JexlEngine jexl) {
        this.engine = jexl;
    }

    public JexlEngine getEngine() {
        return this.engine;
    }

    public JexlContext getContext() {
        return this.context;
    }

    public void setStrict(boolean s) {
        this.context.setStrict(s, s);
    }

    public void setStrict(boolean es, boolean as) {
        this.context.setStrict(es, as);
    }

    public void setSilent(boolean silent) {
        this.context.setSilent(silent);
    }

    public void clearOptions() {
        this.context.clearOptions();
    }

    public void assertExpression(String expression, Object expected) throws Exception {
        JexlScript exp = this.engine.createScript(expression);
        Object value = exp.execute((JexlContext)this.context);
        if (expected instanceof BigDecimal) {
            JexlArithmetic jexla = this.engine.getArithmetic();
            Asserter.assertTrue((String)("expression: " + expression), (((BigDecimal)expected).compareTo(jexla.toBigDecimal(value)) == 0 ? 1 : 0) != 0);
        }
        if (expected != null && value != null) {
            Asserter.assertEquals((String)("expression: " + expression + ", " + expected.getClass().getSimpleName() + " ?= " + value.getClass().getSimpleName()), (Object)expected, (Object)value);
        } else {
            Asserter.assertEquals((String)("expression: " + expression), (Object)expected, (Object)value);
        }
    }

    public void failExpression(String expression, String matchException) throws Exception {
        block2: {
            try {
                JexlScript exp = this.engine.createScript(expression);
                exp.execute((JexlContext)this.context);
                Asserter.fail((String)("expression: " + expression));
            }
            catch (JexlException xjexl) {
                if (matchException == null || xjexl.getMessage().matches(matchException)) break block2;
                Asserter.fail((String)("expression: " + expression + ", expected: " + matchException + ", got " + xjexl.getMessage()));
            }
        }
    }

    public void setVariable(String name, Object value) {
        this.variables.put(name, value);
    }

    public Object removeVariable(String name) {
        return this.variables.remove(name);
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }
}

