/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.parser;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.Parser;

public class ParserTest
extends TestCase {
    public ParserTest(String testName) {
        super(testName);
    }

    public void testParse() throws Exception {
        Parser parser = new Parser((Reader)new StringReader(";"));
        ASTJexlScript sn = parser.parse(null, "foo = 1;", null, false, false);
        ParserTest.assertNotNull((String)"parsed node is null", (Object)sn);
        sn = parser.parse(null, "foo = \"bar\";", null, false, false);
        ParserTest.assertNotNull((String)"parsed node is null", (Object)sn);
        sn = parser.parse(null, "foo = 'bar';", null, false, false);
        ParserTest.assertNotNull((String)"parsed node is null", (Object)sn);
    }

    public void testErrorAssign() throws Exception {
        String[] ops;
        for (String op : ops = new String[]{"=", "+=", "-=", "/=", "*=", "^=", "&=", "|="}) {
            Parser parser = new Parser((Reader)new StringReader(";"));
            try {
                ASTJexlScript sn = parser.parse(null, "foo() " + op + " 1;", null, false, false);
                ParserTest.fail((String)("should have failed on invalid assignment " + op));
            }
            catch (JexlException.Parsing xparse) {
                String ss = xparse.getDetail();
                String sss = xparse.toString();
            }
        }
    }

    public void testErrorAmbiguous() throws Exception {
        Parser parser = new Parser((Reader)new StringReader(";"));
        try {
            ASTJexlScript sn = parser.parse(null, "x = 1 y = 5", null, false, false);
            ParserTest.fail((String)"should have failed on ambiguous statement");
        }
        catch (JexlException.Ambiguous ambiguous) {
            // empty catch block
        }
    }
}

