/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Before;
import org.junit.Test;

public class BitwiseOperatorTest
extends JexlTestCase {
    private Asserter asserter;

    @Override
    @Before
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
        this.asserter.setStrict(false, false);
    }

    public BitwiseOperatorTest() {
        super("BitwiseOperatorTest");
    }

    @Test
    public void testAndWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null & null", new Long(0L), new Object[0]);
    }

    @Test
    public void testAndWithLeftNull() throws Exception {
        this.asserter.assertExpression("null & 1", new Long(0L), new Object[0]);
    }

    @Test
    public void testAndWithRightNull() throws Exception {
        this.asserter.assertExpression("1 & null", new Long(0L), new Object[0]);
    }

    @Test
    public void testAndSimple() throws Exception {
        this.asserter.assertExpression("15 & 3", new Long(3L), new Object[0]);
    }

    @Test
    public void testAndVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.setVariable("y", new Short(7));
        this.asserter.assertExpression("x & y", new Long(7L), new Object[0]);
    }

    @Test
    public void testAndVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.setVariable("y", "7");
        this.asserter.assertExpression("x & y", new Long(7L), new Object[0]);
    }

    @Test
    public void testComplementWithNull() throws Exception {
        this.asserter.assertExpression("~null", new Long(-1L), new Object[0]);
    }

    @Test
    public void testComplementSimple() throws Exception {
        this.asserter.assertExpression("~128", new Long(-129L), new Object[0]);
    }

    @Test
    public void testComplementVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(15));
        this.asserter.assertExpression("~x", new Long(-16L), new Object[0]);
    }

    @Test
    public void testComplementVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", "15");
        this.asserter.assertExpression("~x", new Long(-16L), new Object[0]);
    }

    @Test
    public void testOrWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null | null", new Long(0L), new Object[0]);
    }

    @Test
    public void testOrWithLeftNull() throws Exception {
        this.asserter.assertExpression("null | 1", new Long(1L), new Object[0]);
    }

    @Test
    public void testOrWithRightNull() throws Exception {
        this.asserter.assertExpression("1 | null", new Long(1L), new Object[0]);
    }

    @Test
    public void testOrSimple() throws Exception {
        this.asserter.assertExpression("12 | 3", new Long(15L), new Object[0]);
    }

    @Test
    public void testOrVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(12));
        this.asserter.setVariable("y", new Short(3));
        this.asserter.assertExpression("x | y", new Long(15L), new Object[0]);
    }

    @Test
    public void testOrVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(12));
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x | y", new Long(15L), new Object[0]);
    }

    @Test
    public void testXorWithTwoNulls() throws Exception {
        this.asserter.assertExpression("null ^ null", new Long(0L), new Object[0]);
    }

    @Test
    public void testXorWithLeftNull() throws Exception {
        this.asserter.assertExpression("null ^ 1", new Long(1L), new Object[0]);
    }

    @Test
    public void testXorWithRightNull() throws Exception {
        this.asserter.assertExpression("1 ^ null", new Long(1L), new Object[0]);
    }

    @Test
    public void testXorSimple() throws Exception {
        this.asserter.assertExpression("1 ^ 3", new Long(2L), new Object[0]);
    }

    @Test
    public void testXorVariableNumberCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(1));
        this.asserter.setVariable("y", new Short(3));
        this.asserter.assertExpression("x ^ y", new Long(2L), new Object[0]);
    }

    @Test
    public void testXorVariableStringCoercion() throws Exception {
        this.asserter.setVariable("x", new Integer(1));
        this.asserter.setVariable("y", "3");
        this.asserter.assertExpression("x ^ y", new Long(2L), new Object[0]);
    }

    @Test
    public void testParenthesized() throws Exception {
        this.asserter.assertExpression("(2 | 1) & 3", 3L, new Object[0]);
        this.asserter.assertExpression("(2 & 1) | 3", 3L, new Object[0]);
        this.asserter.assertExpression("~(120 | 42)", new Long(-123L), new Object[0]);
    }
}

