/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.nio.charset.Charset;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.internal.introspection.SandboxUberspect;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.junit.Assert;
import org.junit.Test;

public class BuilderTest {
    private static JexlBuilder builder() {
        return new JexlBuilder();
    }

    @Test
    public void testFlags() {
        Assert.assertTrue((boolean)BuilderTest.builder().antish(true).antish());
        Assert.assertFalse((boolean)BuilderTest.builder().antish(false).antish());
        Assert.assertTrue((boolean)BuilderTest.builder().cancellable(true).cancellable());
        Assert.assertFalse((boolean)BuilderTest.builder().cancellable(false).cancellable());
        Assert.assertTrue((boolean)BuilderTest.builder().safe(true).safe());
        Assert.assertFalse((boolean)BuilderTest.builder().safe(false).safe());
        Assert.assertTrue((boolean)BuilderTest.builder().silent(true).silent());
        Assert.assertFalse((boolean)BuilderTest.builder().silent(false).silent());
        Assert.assertTrue((boolean)BuilderTest.builder().lexical(true).lexical());
        Assert.assertFalse((boolean)BuilderTest.builder().lexical(false).lexical());
        Assert.assertTrue((boolean)BuilderTest.builder().lexicalShade(true).lexicalShade());
        Assert.assertFalse((boolean)BuilderTest.builder().lexicalShade(false).lexicalShade());
        Assert.assertTrue((boolean)BuilderTest.builder().silent(true).silent());
        Assert.assertFalse((boolean)BuilderTest.builder().silent(false).silent());
        Assert.assertTrue((boolean)BuilderTest.builder().strict(true).strict());
        Assert.assertFalse((boolean)BuilderTest.builder().strict(false).strict());
    }

    @Test
    public void testValues() {
        Assert.assertEquals((long)1L, (long)BuilderTest.builder().collectMode(1).collectMode());
        Assert.assertEquals((long)0L, (long)BuilderTest.builder().collectMode(0).collectMode());
        Assert.assertEquals((long)32L, (long)BuilderTest.builder().cacheThreshold(32).cacheThreshold());
        Assert.assertEquals((long)8L, (long)BuilderTest.builder().stackOverflow(8).stackOverflow());
    }

    @Test
    public void testOther() {
        ClassLoader cls = this.getClass().getClassLoader().getParent();
        Assert.assertEquals((Object)cls, (Object)BuilderTest.builder().loader(cls).loader());
        Charset cs = Charset.forName("UTF16");
        Assert.assertEquals((Object)cs, (Object)BuilderTest.builder().charset(cs).charset());
        Assert.assertEquals((Object)cs, (Object)BuilderTest.builder().loader(cs).charset());
        JexlUberspect u0 = BuilderTest.builder().create().getUberspect();
        JexlSandbox sandbox = new JexlSandbox();
        SandboxUberspect uberspect = new SandboxUberspect(u0, sandbox);
        Assert.assertEquals((Object)sandbox, (Object)BuilderTest.builder().sandbox(sandbox).sandbox());
        Assert.assertEquals((Object)uberspect, (Object)BuilderTest.builder().uberspect((JexlUberspect)uberspect).uberspect());
    }
}

