/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.TemplateDebugger;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JXLTTest
extends JexlTestCase {
    private static final Log LOGGER = LogFactory.getLog(JxltEngine.class);
    private final MapContext vars = new MapContext();
    private JexlEvalContext context = null;
    private final JexlBuilder BUILDER;
    private final JexlEngine ENGINE;
    private final JxltEngine JXLT;
    private static final Permissions NOJEXL3 = new Permissions(){

        public boolean allow(Class<?> clazz) {
            String cname = clazz.getName();
            return !cname.contains("jexl3") || cname.contains("311");
        }
    };

    public JXLTTest(JexlBuilder builder) {
        super("JXLTTest");
        this.BUILDER = builder;
        this.ENGINE = this.BUILDER.create();
        this.JXLT = this.ENGINE.createJxltEngine();
    }

    @Parameterized.Parameters
    public static List<JexlBuilder> engines() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true).lexicalShade(true);
        return Arrays.asList(new JexlBuilder().silent(false).lexical(true).lexicalShade(true).cache(128).strict(true), new JexlBuilder().features(f).silent(false).cache(128).strict(true), new JexlBuilder().silent(false).cache(128).strict(true));
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
        this.context = new JexlEvalContext((JexlContext)this.vars);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        JXLTTest.debuggerCheck(this.ENGINE);
        super.tearDown();
    }

    private boolean isLexicalShade() {
        JexlOptions options = this.context.getEngineOptions();
        if (options.isLexicalShade()) {
            return true;
        }
        options = new JexlOptions().set(this.ENGINE);
        return options.isLexicalShade();
    }

    private static String refactor(TemplateDebugger td, JxltEngine.Template ts) {
        boolean dbg = td.debug(ts);
        if (dbg) {
            return td.toString();
        }
        return "";
    }

    private String getSource(String tostring) {
        int len = tostring.length();
        int sc = tostring.lastIndexOf(" /*= ");
        if (sc >= 0) {
            sc += " /*= ".length();
        }
        int ec = tostring.lastIndexOf(" */");
        if (sc >= 0 && ec >= 0 && ec > sc && ec < len) {
            return tostring.substring(sc, ec);
        }
        return tostring;
    }

    @Test
    public void testStatement() throws Exception {
        Froboz froboz = new Froboz(32);
        this.context.set("froboz", froboz);
        JxltEngine.Expression check = this.JXLT.createExpression("${ froboz.plus10() }");
        Object o = check.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 32", (Object)new Integer(32), (Object)o);
        Assert.assertEquals((String)"Result is not 42", (long)42L, (long)froboz.getValue());
        Set evars = check.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
    }

    @Test
    public void testAssign() throws Exception {
        Froboz froboz = new Froboz(32);
        this.context.set("froboz", froboz);
        JxltEngine.Expression assign = this.JXLT.createExpression("${froboz.value = 42}");
        JxltEngine.Expression check = this.JXLT.createExpression("${froboz.value}");
        Object o = assign.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(42), (Object)o);
        o = check.evaluate((JexlContext)this.context);
        Assert.assertEquals((String)"Result is not 10", (Object)new Integer(42), (Object)o);
    }

    @Test
    public void testComposite() throws Exception {
        String source = "Dear ${p} ${name};";
        JxltEngine.Expression expr = this.JXLT.createExpression("Dear ${p} ${name};");
        this.context.set("p", "Mr");
        this.context.set("name", "Doe");
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        this.context.set("p", "Ms");
        this.context.set("name", "Jones");
        o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Ms Jones;", (Object)o);
        Assert.assertEquals((Object)"Dear ${p} ${name};", (Object)this.getSource(expr.toString()));
    }

    boolean contains(Set<List<String>> set, List<String> list) {
        for (List<String> sl : set) {
            if (!sl.equals(list)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testPrepareEvaluate() throws Exception {
        String source = "Dear #{p} ${name};";
        JxltEngine.Expression expr = this.JXLT.createExpression("Dear #{p} ${name};");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Set evars = expr.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
        Assert.assertTrue((boolean)this.contains(evars, Collections.singletonList("name")));
        this.context.set("name", "Doe");
        JxltEngine.Expression phase1 = expr.prepare((JexlContext)this.context);
        String as = phase1.asString();
        Assert.assertEquals((Object)"Dear ${p} Doe;", (Object)as);
        Set evars1 = phase1.getVariables();
        Assert.assertEquals((long)1L, (long)evars1.size());
        Assert.assertTrue((boolean)this.contains(evars1, Collections.singletonList("p")));
        this.vars.clear();
        this.context.set("p", "Mr");
        this.context.set("name", "Should not be used in 2nd phase");
        Object o = phase1.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Dear Mr Doe;", (Object)o);
        String p1 = this.getSource(phase1.toString());
        Assert.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(phase1.toString()));
        Assert.assertEquals((Object)"Dear #{p} ${name};", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testNested() throws Exception {
        String source = "#{${hi}+'.world'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi}+'.world'}");
        Set evars = expr.getVariables();
        Assert.assertEquals((long)1L, (long)evars.size());
        Assert.assertTrue((boolean)this.contains(evars, Collections.singletonList("hi")));
        this.context.set("hi", "greeting");
        this.context.set("greeting.world", "Hello World!");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testNestedTemplate() throws Exception {
        String source = "#{${hi}+'.world'}";
        JxltEngine.Template expr = this.JXLT.createTemplate("#{${hi}+'.world'}", new String[]{"hi"});
        this.context.set("greeting.world", "Hello World!");
        StringWriter strw = new StringWriter();
        expr.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{"greeting"});
        String o = strw.toString();
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"#{${hi}+'.world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testImmediate() throws Exception {
        JexlContext none = null;
        String source = "${'Hello ' + 'World!'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("${'Hello ' + 'World!'}");
        JxltEngine.Expression prepared = expr.prepare(none);
        Assert.assertEquals((String)"prepare should return same expression", (Object)"Hello World!", (Object)prepared.asString());
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"${'Hello ' + 'World!'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant0() throws Exception {
        JexlContext none = null;
        String source = "Hello World!";
        JxltEngine.Expression expr = this.JXLT.createExpression("Hello World!");
        Assert.assertSame((String)"prepare should return same expression", (Object)expr.prepare(none), (Object)expr);
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)"Hello World!", (Object)o);
        Assert.assertEquals((Object)"Hello World!", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant2() throws Exception {
        JexlContext none = null;
        String source = "${size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = this.JXLT.createExpression("${size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be immediate", (boolean)expr.isImmediate());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"${size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant3() throws Exception {
        JexlContext none = null;
        String source = "#{size({'map':123,'map2':456})}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{size({'map':123,'map2':456})}");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"#{size({'map':123,'map2':456})}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testConstant4() throws Exception {
        JexlContext none = null;
        String source = "#{ ${size({'1':2,'2': 3})} }";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{ ${size({'1':2,'2': 3})} }");
        Object o = expr.evaluate(none);
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        Assert.assertEquals((Object)2, (Object)o);
        Assert.assertEquals((Object)"#{ ${size({'1':2,'2': 3})} }", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testDeferred() throws Exception {
        JexlContext none = null;
        String source = "#{'world'}";
        JxltEngine.Expression expr = this.JXLT.createExpression("#{'world'}");
        Assert.assertTrue((String)"expression should be deferred", (boolean)expr.isDeferred());
        String as = expr.prepare(none).asString();
        Assert.assertEquals((String)"prepare should return immediate version", (Object)"${'world'}", (Object)as);
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"world", (Object)o);
        Assert.assertEquals((Object)"#{'world'}", (Object)this.getSource(expr.toString()));
    }

    @Test
    public void testEscape() throws Exception {
        JexlContext none = null;
        JxltEngine.Expression expr = this.JXLT.createExpression("\\#{'world'}");
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"#{'world'}", (Object)o);
        expr = this.JXLT.createExpression("\\${'world'}");
        o = expr.evaluate(none);
        Assert.assertEquals((Object)"${'world'}", (Object)o);
    }

    @Test
    public void testEscapeString() throws Exception {
        JxltEngine.Expression expr = this.JXLT.createExpression("\\\"${'world\\'s finest'}\\\"");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"\"world's finest\"", (Object)o);
    }

    @Test
    public void testNonEscapeString() throws Exception {
        JxltEngine.Expression expr = this.JXLT.createExpression("c:\\some\\windows\\path");
        JexlContext none = null;
        Object o = expr.evaluate(none);
        Assert.assertEquals((Object)"c:\\some\\windows\\path", (Object)o);
    }

    @Test
    public void testMalformed() throws Exception {
        try {
            JxltEngine.Expression expr = this.JXLT.createExpression("${'world'");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOGGER.debug((Object)xmsg);
        }
    }

    @Test
    public void testMalformedNested() throws Exception {
        try {
            JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi} world}");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOGGER.debug((Object)xmsg);
        }
    }

    @Test
    public void testMalformedNested2() throws Exception {
        try {
            JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi} world}");
            MapContext ctxt = new MapContext();
            ctxt.set("hi", (Object)"hello");
            expr.evaluate((JexlContext)ctxt);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOGGER.debug((Object)xmsg);
        }
    }

    @Test
    public void testBadContextNested() throws Exception {
        try {
            JxltEngine.Expression expr = this.JXLT.createExpression("#{${hi}+'.world'}");
            JexlContext none = null;
            expr.evaluate(none);
            Assert.fail((String)"should be malformed");
        }
        catch (JxltEngine.Exception xjexl) {
            String xmsg = xjexl.getMessage();
            LOGGER.debug((Object)xmsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharAtBug() throws Exception {
        this.context.set("foo", "abcdef");
        JexlOptions options = this.context.getEngineOptions();
        JxltEngine.Expression expr = this.JXLT.createExpression("${foo.substring(2,4)/*comment*/}");
        Object o = expr.evaluate((JexlContext)this.context);
        Assert.assertEquals((Object)"cd", (Object)o);
        this.context.set("bar", "foo");
        try {
            options.setSilent(true);
            expr = this.JXLT.createExpression("#{${bar}+'.charAt(-2)'}");
            expr = expr.prepare((JexlContext)this.context);
            o = expr.evaluate((JexlContext)this.context);
            Assert.assertNull((Object)o);
        }
        finally {
            options.setSilent(false);
        }
    }

    @Test
    public void testTemplate0() throws Exception {
        String source = "   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("   $$ if(x) {\nx is ${x}\n   $$ } else {\n${'no x'}\n$$ }\n");
        this.context.set("x", 42);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        this.context.set("x", "");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"no x\n", (Object)output);
        String dstr = t.toString();
        Assert.assertNotNull((Object)dstr);
    }

    @Test
    public void testTemplate10() throws Exception {
        String source = "$$(x)->{ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ } }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$(x)->{ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ } }\n"), (String[])null);
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        String[] ps = t.getParameters();
        Assert.assertTrue((boolean)Arrays.asList(ps).contains("x"));
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
    }

    @Test
    public void testTemplate1() throws Exception {
        String source = "$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ if(x) {\nx is ${x}\n$$ } else {\n${'no x'}\n$$ }\n"), new String[]{"x"});
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"x is 42\n", (Object)output);
        strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{""});
        output = strw.toString();
        Assert.assertEquals((Object)"no x\n", (Object)output);
    }

    @Test
    public void testTemplate2() throws Exception {
        String source = "The answer: ${x}";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("The answer: ${x}"), new String[]{"x"});
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"The answer: 42", (Object)output);
    }

    @Test
    public void testPrepareTemplate() throws Exception {
        String source = "$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n";
        int[] args = new int[]{42};
        JxltEngine.Template tl10n = this.JXLT.createTemplate("$$ for(var x : list) {\n${l10n}=#{x}\n$$ }\n", new String[]{"list"});
        String dstr = tl10n.asString();
        Assert.assertNotNull((Object)dstr);
        Set vars = tl10n.getVariables();
        Assert.assertFalse((boolean)vars.isEmpty());
        this.context.set("l10n", "valeur");
        JxltEngine.Template tpFR = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", "value");
        JxltEngine.Template tpEN = tl10n.prepare((JexlContext)this.context);
        this.context.set("l10n", null);
        StringWriter strw = new StringWriter();
        tpFR.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outFR = strw.toString();
        Assert.assertEquals((Object)"valeur=42\n", (Object)outFR);
        this.context.set("l10n", null);
        strw = new StringWriter();
        tpEN.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{args});
        String outEN = strw.toString();
        Assert.assertEquals((Object)"value=42\n", (Object)outEN);
    }

    @Test
    public void test42() throws Exception {
        String test42 = "$$ for(var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ for(var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n"), new String[]{"list"});
        StringWriter strw = new StringWriter();
        int[] list = new int[]{1, 3, 5, 42, 169};
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{list});
        String output = strw.toString();
        String out42 = "The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n";
        Assert.assertEquals((Object)"The value 1 is under fourty-two\nThe value 3 is under fourty-two\nThe value 5 is under fourty-two\nLife, the universe, and everything\nThe value 169 is over fourty-two\n", (Object)output);
        String dstr = t.asString();
        Assert.assertNotNull((Object)dstr);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, t);
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)"$$ for(var x : list) {\n$$   if (x == 42) {\nLife, the universe, and everything\n$$   } else if (x > 42) {\nThe value ${x} is over fourty-two\n$$   } else {\nThe value ${x} is under fourty-two\n$$   }\n$$ }\n", (Object)refactored);
    }

    @Test
    public void testInheritedDebugger() throws Exception {
        String src = "if ($A) { $B + 1; } else { $C - 2 }";
        Debugger sd = new Debugger();
        JexlEngine jexl = this.JXLT.getEngine();
        JexlScript script = jexl.createScript("if ($A) { $B + 1; } else { $C - 2 }");
        String rscript = sd.debug(script) ? sd.toString() : null;
        Assert.assertNotNull((Object)rscript);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = td.debug(script) ? td.toString() : null;
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)refactored, (Object)rscript);
    }

    @Test
    public void testWriter() throws Exception {
        Froboz froboz = new Froboz(42);
        FrobozWriter writer = new FrobozWriter(new StringWriter());
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$$jexl.print(froboz)"), new String[]{"froboz"});
        t.evaluate((JexlContext)this.context, (Writer)writer, new Object[]{froboz});
        Assert.assertEquals((Object)"froboz{42}", (Object)((Object)writer).toString());
    }

    @Test
    public void testReport() throws Exception {
        String rpt = "<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        String ctl = "<report>\n\n\n\n\n        11\n</report>\n";
        Assert.assertEquals((Object)"<report>\n\n\n\n\n        11\n</report>\n", (Object)output);
        TemplateDebugger td = new TemplateDebugger();
        String refactored = JXLTTest.refactor(td, t);
        Assert.assertNotNull((Object)refactored);
        Assert.assertEquals((Object)"<report>\n\n\n$$ var a = 1;\n$$ var x = 2;\n\n$$ var y = 9;\n\n        ${x + y}\n</report>\n", (Object)refactored);
    }

    @Test
    public void testReport1() throws Exception {
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", 42);
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReport2() throws Exception {
        String rpt = "<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n"), new String[]{"x"});
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        int count = 0;
        for (int i = 0; i < output.length(); ++i) {
            char c = output.charAt(i);
            if ('\n' != c) continue;
            ++count;
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertTrue((output.indexOf("42") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("43") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("44") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.indexOf("45") > 0 ? 1 : 0) != 0);
        TemplateDebugger td = new TemplateDebugger();
        String xxx = JXLTTest.refactor(td, t);
        Assert.assertNotNull((Object)xxx);
        Assert.assertEquals((Object)"<report>\nthis is ${x}\n${x + 1}\n${x + 2}\n${x + 3}\n</report>\n", (Object)xxx);
    }

    @Test
    public void testOneLiner() throws Exception {
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("fourty-two"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"fourty-two", (Object)output);
    }

    @Test
    public void testOneLinerVar() throws Exception {
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("fourty-${x}"), new String[0]);
        StringWriter strw = new StringWriter();
        this.context.set("x", "two");
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"fourty-two", (Object)output);
    }

    @Test
    public void testInterpolation() throws Exception {
        String expr = "`Hello \n${user}`";
        JexlScript script = this.ENGINE.createScript("`Hello \n${user}`");
        this.context.set("user", "Dimitri");
        Object value = script.execute((JexlContext)this.context);
        Assert.assertEquals((String)"`Hello \n${user}`", (Object)"Hello \nDimitri", (Object)value);
        this.context.set("user", "Rahul");
        value = script.execute((JexlContext)this.context);
        Assert.assertEquals((String)"`Hello \n${user}`", (Object)"Hello \nRahul", (Object)value);
    }

    @Test
    public void testInterpolationGlobal() throws Exception {
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; `Hello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; `Hello \n${user}`").execute((JexlContext)this.context);
        Assert.assertEquals((String)"user='Dimitri'; `Hello \n${user}`", (Object)"Hello \nDimitri", (Object)value);
    }

    @Test
    public void testInterpolationLocal() throws Exception {
        String expr = "var user='Henrib'; `Hello \n${user}`";
        Object value = this.ENGINE.createScript("var user='Henrib'; `Hello \n${user}`").execute((JexlContext)this.context);
        Assert.assertEquals((String)"var user='Henrib'; `Hello \n${user}`", (Object)"Hello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationLvsG() throws Exception {
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`").execute((JexlContext)this.context);
        Assert.assertEquals((String)"user='Dimitri'; var user='Henrib'; `H\\\"ello \n${user}`", (Object)"H\"ello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationLvsG2() throws Exception {
        if (this.isLexicalShade()) {
            this.context.set("user", null);
        }
        String expr = "user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`";
        Object value = this.ENGINE.createScript("user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`").execute((JexlContext)this.context);
        Assert.assertEquals((String)"user='Dimitri'; var user='Henrib'; `H\\`ello \n${user}`", (Object)"H`ello \nHenrib", (Object)value);
    }

    @Test
    public void testInterpolationParameter() throws Exception {
        String expr = "(user)->{`Hello \n${user}`}";
        JexlScript script = this.ENGINE.createScript("(user)->{`Hello \n${user}`}");
        Object value = script.execute((JexlContext)this.context, new Object[]{"Henrib"});
        Assert.assertEquals((String)"(user)->{`Hello \n${user}`}", (Object)"Hello \nHenrib", (Object)value);
        value = this.ENGINE.createScript("(user)->{`Hello \n${user}`}").execute((JexlContext)this.context, new Object[]{"Dimitri"});
        Assert.assertEquals((String)"(user)->{`Hello \n${user}`}", (Object)"Hello \nDimitri", (Object)value);
    }

    @Test
    public void testDbgEscapes() throws Exception {
        String[] srcs;
        for (String src : srcs = new String[]{"jexl:print('hello\\'\\nworld')", "'hello\\tworld'", "'hello\\nworld'", "'hello\\fworld'", "'hello\\rworld'"}) {
            JexlScript script = this.ENGINE.createScript(src);
            Debugger dbg = new Debugger();
            dbg.debug(script);
            String msrc = dbg.toString();
            Assert.assertEquals((Object)src, (Object)msrc);
        }
    }

    @Test
    public void testImmediateTemplate() throws Exception {
        this.context.set("tables", new String[]{"table1", "table2"});
        this.context.set("w", "x=1");
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("select * from \n$$var comma = false; \n$$for(var c : tables) { \n$$  if (comma) $jexl.write(','); else comma = true;\n${c}\n$$}\nwhere ${w}\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertTrue((output.contains("table1") && output.contains("table2") ? 1 : 0) != 0);
    }

    @Test
    public void test311a() throws Exception {
        JexlContext ctx = null;
        String rpt = "$$((a)->{\n<p>Universe ${a}</p>\n$$})(42)";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$((a)->{\n<p>Universe ${a}</p>\n$$})(42)"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate(ctx, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @Test
    public void test311b() throws Exception {
        Context311 ctx311 = new Context311();
        String rpt = "$$ exec('42').execute(()->{\n<p>Universe 42</p>\n$$})";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('42').execute(()->{\n<p>Universe 42</p>\n$$})"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @Test
    public void test311c() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "$$ exec('42').execute((a)->{\n<p>Universe ${a}</p>\n$$})";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('42').execute((a)->{\n<p>Universe ${a}</p>\n$$})"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @Test
    public void test311d() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "$$ exec('4').execute((a, b)->{\n<p>Universe ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ exec('4').execute((a, b)->{\n<p>Universe ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @Test
    public void test311e() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "exec('4').execute((a, b)->{ '<p>Universe ' + a + b + '</p>'}, '2')";
        JexlScript script = this.JEXL.createScript("exec('4').execute((a, b)->{ '<p>Universe ' + a + b + '</p>'}, '2')");
        String output = script.execute((JexlContext)ctx311, new Object[]{42}).toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @Test
    public void test311f() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "exec('4').execute((a, b)->{ `<p>Universe ${a}${b}</p>`}, '2')";
        JexlScript script = this.JEXL.createScript("exec('4').execute((a, b)->{ `<p>Universe ${a}${b}</p>`}, '2')");
        String output = script.execute((JexlContext)ctx311, new Object[]{42}).toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @Test
    public void test311g() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = "(a, b)->{ `<p>Universe ${a}${b}</p>`}";
        JexlScript script = this.JEXL.createScript("(a, b)->{ `<p>Universe ${a}${b}</p>`}");
        String output = script.execute((JexlContext)ctx311, new Object[]{"4", "2"}).toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @Test
    public void test311h() throws Exception {
        Context311 ctx311 = new Context311();
        ctx311.newOptions().setLexical(true);
        String rpt = " `<p>Universe ${a}${b}</p>`";
        JexlScript script = this.JEXL.createScript(" `<p>Universe ${a}${b}</p>`", new String[]{"a", "b"});
        String output = script.execute((JexlContext)ctx311, new Object[]{"4", "2"}).toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>", (Object)output);
    }

    @Test
    public void test311i() throws Exception {
        Context311 ctx311 = new Context311();
        String rpt = "$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    @Test
    public void test315() throws Exception {
        String s315 = "<report/>$";
        JxltEngine.Template t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        StringWriter strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)s315, (Object)output);
        s315 = "<foo/>#";
        t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)s315, (Object)output);
        s315 = "<bar/>\\";
        t315 = this.JXLT.createTemplate("$$", (Reader)new StringReader(s315), new String[0]);
        strw = new StringWriter();
        t315.evaluate((JexlContext)this.context, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)s315, (Object)output);
    }

    @Test
    public void testLexicalTemplate() throws Exception {
        JexlOptions opts = new JexlOptions();
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setSafe(true);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        String src0 = "${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe";
        JxltEngine.Template tmplt0 = this.JXLT.createTemplate("$$", (Reader)new StringReader("${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe"), new String[0]);
        StringWriter strw0 = new StringWriter();
        tmplt0.evaluate((JexlContext)ctxt, (Writer)strw0);
        String output0 = ((Object)strw0).toString();
        JexlFeatures features = this.BUILDER.features();
        if (features != null && features.isLexical() && features.isLexicalShade()) {
            Assert.assertEquals((Object)"-strict -cancellable +lexical +lexicalShade +safe", (Object)output0);
        } else {
            Assert.assertEquals((Object)"-strict -cancellable -lexical -lexicalShade +safe", (Object)output0);
        }
        String src = "$$ #pragma script.mode pro50\n${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe";
        JxltEngine.Template tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ #pragma script.mode pro50\n${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.safe?'+':'-'}safe"), new String[0]);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = ((Object)strw).toString();
        Assert.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -safe", (Object)output);
    }

    @Test
    public void testTemplatePragmaPro50() throws Exception {
        JexlOptions opts = new JexlOptions();
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setSafe(true);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        opts.setSharedInstance(true);
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        String src = "$$ #pragma script.mode pro50\n$$ var tab = null;\n$$ tab.dummy();";
        JxltEngine.Template tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$ #pragma script.mode pro50\n$$ var tab = null;\n$$ tab.dummy();"), new String[0]);
        StringWriter strw = new StringWriter();
        try {
            tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
            Assert.fail((String)"tab var is null");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertEquals((Object)"tab", (Object)xvar.getVariable());
            Assert.assertFalse((boolean)xvar.isUndefined());
        }
    }

    @Test
    public void testTemplateOutOfScope() throws Exception {
        JxltEngine.Template tmplt;
        JexlOptions opts = new JexlOptions();
        opts.setCancellable(false);
        opts.setStrict(false);
        opts.setLexical(false);
        opts.setLexicalShade(false);
        opts.setSharedInstance(true);
        JexlTestCase.PragmaticContext ctxt = new JexlTestCase.PragmaticContext(opts);
        String src = "$$if (false) { var tab = 42; }\n${tab}";
        JexlFeatures features = this.BUILDER.features();
        try {
            tmplt = this.JXLT.createTemplate("$$", (Reader)new StringReader("$$if (false) { var tab = 42; }\n${tab}"), new String[0]);
        }
        catch (JexlException xparse) {
            if (features != null && features.isLexicalShade()) {
                return;
            }
            throw xparse;
        }
        StringWriter strw = new StringWriter();
        opts.setSafe(true);
        try {
            tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
            Assert.assertTrue((boolean)((Object)strw).toString().isEmpty());
        }
        catch (JexlException.Variable xvar) {
            Assert.fail((String)"safe should prevent local shade");
        }
        opts.setStrict(true);
        opts.setSafe(false);
        try {
            tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
            Assert.fail((String)"tab var is undefined");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)"tab".equals(xvar.getVariable()));
            Assert.assertTrue((boolean)xvar.isUndefined());
        }
        catch (JexlException xany) {
            Assert.assertTrue((boolean)xany.getMessage().contains("tab"));
        }
    }

    @Test
    public void testCommentedTemplate0() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        String src = "$$/*\nHello\n$$*/";
        JxltEngine.Template tmplt = jxlt.createTemplate("$$/*\nHello\n$$*/");
        Assert.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        Assert.assertTrue((boolean)((Object)strw).toString().isEmpty());
    }

    @Test
    public void testCommentedTemplate1() throws Exception {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        String src = "$$/*\none\n$$*/\n42\n$$/*\nthree\n$$*/\n";
        JxltEngine.Template tmplt = jxlt.createTemplate("$$/*\none\n$$*/\n42\n$$/*\nthree\n$$*/\n");
        Assert.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        Assert.assertEquals((Object)"42\n", (Object)((Object)strw).toString());
    }

    @Test
    public void testConstantTemplate() {
        String src = "<script>\n      function test(src){\n        var res = src.replace(/\\n\\t\\s/g, '\\n');\n      }\n      test();\n    </script>";
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template tmplt = jxlt.createTemplate(src);
        Assert.assertNotNull((Object)tmplt);
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String result = ((Object)strw).toString();
        Assert.assertEquals((Object)src, (Object)result);
    }

    @Test
    public void testSanboxedTemplate() throws Exception {
        String src = "Hello ${user}";
        MapContext ctxt = new MapContext();
        ctxt.set("user", (Object)"Francesco");
        Uberspect uberspect = new Uberspect(LogFactory.getLog(JXLTTest.class), null, (JexlPermissions)NOJEXL3);
        Method method = uberspect.getMethod(TemplateInterpreter.class, "print", new Object[]{Integer.TYPE});
        Assert.assertNull((Object)method);
        JexlEngine jexl = new JexlBuilder().uberspect((JexlUberspect)uberspect).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template tmplt = jxlt.createTemplate("Hello ${user}");
        StringWriter strw = new StringWriter();
        tmplt.evaluate((JexlContext)ctxt, (Writer)strw);
        String result = ((Object)strw).toString();
        Assert.assertEquals((Object)"Hello Francesco", (Object)result);
    }

    @Test
    public void testSanboxed311i() throws Exception {
        Uberspect uberspect = new Uberspect(LogFactory.getLog(JXLTTest.class), null, (JexlPermissions)NOJEXL3);
        Method method = uberspect.getMethod(TemplateInterpreter.class, "print", new Object[]{Integer.TYPE});
        JexlEngine jexl = new JexlBuilder().uberspect((JexlUberspect)uberspect).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        Context311 ctx311 = new Context311();
        String rpt = "$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')";
        JxltEngine.Template t = jxlt.createTemplate("$$", (Reader)new StringReader("$$var u = 'Universe'; exec('4').execute((a, b)->{\n<p>${u} ${a}${b}</p>\n$$}, '2')"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctx311, (Writer)strw, new Object[]{42});
        String output = strw.toString();
        Assert.assertEquals((Object)"<p>Universe 42</p>\n", (Object)output);
    }

    public static class Context311
    extends MapContext
    implements JexlContext.OptionsHandle,
    JexlContext.ThreadLocal {
        private JexlOptions options = null;

        public void setOptions(JexlOptions o) {
            this.options = o;
        }

        public Executor311 exec(String name) {
            return new Executor311(name);
        }

        public JexlOptions getEngineOptions() {
            return this.options;
        }

        JexlOptions newOptions() {
            this.options = new JexlOptions();
            return this.options;
        }
    }

    public static class Executor311 {
        private final String name;

        public Executor311(String name) {
            this.name = name;
        }

        public Object execute(JexlScript script, Object ... args) {
            Object[] actuals;
            if (args != null && args.length > 0) {
                actuals = new Object[args.length + 1];
                System.arraycopy(args, 0, actuals, 1, args.length);
                actuals[0] = this.name;
            } else {
                actuals = new Object[]{this.name};
            }
            return script.execute((JexlContext)JexlEngine.getThreadContext(), actuals);
        }
    }

    public static class FrobozWriter
    extends PrintWriter {
        public FrobozWriter(Writer w) {
            super(w);
        }

        public void print(Froboz froboz) {
            super.print("froboz{");
            super.print(froboz.value);
            super.print("}");
        }

        public String toString() {
            return this.out.toString();
        }
    }

    public static class Froboz {
        int value;

        public Froboz(int v) {
            this.value = v;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public int plus10() {
            int i = this.value;
            this.value += 10;
            return i;
        }
    }
}

