/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.internal.Debugger;
import org.apache.commons.jexl3.internal.OptionsContext;
import org.apache.commons.jexl3.internal.Util;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.junit.After;
import org.junit.Assert;

public class JexlTestCase {
    private static final Class<?>[] NO_PARMS;
    private static final Class<?>[] STRING_PARM;
    protected final JexlEngine JEXL;
    static final JexlOptions MODE_PRO50;
    public static final JexlPermissions SECURE;

    public JexlTestCase(String name) {
        this(name, new JexlBuilder().imports(Arrays.asList("java.lang", "java.math")).permissions(null).cache(128).create());
    }

    protected JexlTestCase(String name, JexlEngine jexl) {
        this.JEXL = jexl;
    }

    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        JexlTestCase.debuggerCheck(this.JEXL);
    }

    static JexlEngine createEngine() {
        return new JexlBuilder().create();
    }

    static JexlEngine createEngine(JexlFeatures features) {
        return new JexlBuilder().features(features).create();
    }

    public static boolean equalsIgnoreWhiteSpace(String lhs, String rhs) {
        String lhsw = lhs.trim().replaceAll("\\s+", "");
        String rhsw = rhs.trim().replaceAll("\\s+", "");
        return lhsw.equals(rhsw);
    }

    public String simpleWhitespace(String arg) {
        return arg.trim().replaceAll("\\s+", " ");
    }

    public static String toString(JexlScript script) {
        Debugger d = new Debugger().lineFeed("").indentation(0);
        d.debug(script);
        return d.toString();
    }

    public static JexlEngine createEngine(boolean lenient) {
        return JexlTestCase.createEngine(lenient, SECURE);
    }

    public static JexlEngine createEngine(boolean lenient, JexlPermissions permissions) {
        return new JexlBuilder().uberspect((JexlUberspect)new Uberspect(null, null, permissions)).arithmetic(new JexlArithmetic(!lenient)).cache(128).create();
    }

    public static void debuggerCheck(JexlEngine ijexl) throws Exception {
        Util.debuggerCheck(ijexl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(String name) throws Exception {
        if ("runTest".equals(name)) {
            return;
        }
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod(name, NO_PARMS);
        }
        catch (Exception xany) {
            Assert.fail((String)("no such test: " + name));
            return;
        }
        try {
            this.setUp();
            method.invoke((Object)this, new Object[0]);
        }
        finally {
            this.tearDown();
        }
    }

    public static void runTest(String tname, String mname) throws Exception {
        String testClassName = "org.apache.commons.jexl3." + tname;
        Class<?> clazz = null;
        JexlTestCase test = null;
        try {
            clazz = Class.forName(testClassName);
        }
        catch (ClassNotFoundException xclass) {
            Assert.fail((String)("no such class: " + testClassName));
            return;
        }
        Constructor<?> ctor = null;
        try {
            ctor = clazz.getConstructor(STRING_PARM);
            test = (JexlTestCase)ctor.newInstance("debug");
        }
        catch (NoSuchMethodException xctor) {
            try {
                test = (JexlTestCase)clazz.newInstance();
            }
            catch (Exception xany) {
                Assert.fail((String)("cant instantiate test: " + xany));
                return;
            }
        }
        catch (Exception xany) {
            Assert.fail((String)("cant instantiate test: " + xany));
            return;
        }
        test.runTest(mname);
    }

    public static void main(String[] args) throws Exception {
        JexlTestCase.runTest(args[0], args[1]);
    }

    static {
        JexlOptions.setDefaultFlags((String[])new String[]{"-safe", "+lexical"});
        NO_PARMS = new Class[0];
        STRING_PARM = new Class[]{String.class};
        MODE_PRO50 = new JexlOptions();
        MODE_PRO50.setFlags("+strict +cancellable +lexical +lexicalShade -safe".split(" "));
        SECURE = JexlPermissions.RESTRICTED;
    }

    public static class PragmaticContext
    extends OptionsContext
    implements JexlContext.PragmaProcessor,
    JexlContext.OptionsHandle {
        private final JexlOptions options;

        public PragmaticContext() {
            this(new JexlOptions());
        }

        public PragmaticContext(JexlOptions o) {
            this.options = o;
        }

        public void processPragma(String key, Object value) {
            this.processPragma(null, key, value);
        }

        public void processPragma(JexlOptions opts, String key, Object value) {
            if ("script.mode".equals(key) && "pro50".equals(value)) {
                opts.set(MODE_PRO50);
            }
        }

        public JexlOptions getEngineOptions() {
            return this.options;
        }
    }
}

