/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Closure;
import org.apache.commons.jexl3.internal.Script;
import org.junit.Assert;
import org.junit.Test;

public class LambdaTest
extends JexlTestCase {
    public LambdaTest() {
        super("LambdaTest");
    }

    @Test
    public void testScriptArguments() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript(" x + x ", new String[]{"x"});
        JexlScript s42 = jexl.createScript("s(21)", new String[]{"s"});
        Object result = s42.execute(null, new Object[]{s});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testScriptContext() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript("function(x) { x + x }");
        String fsstr = s.getParsedText(0);
        Assert.assertEquals((Object)"(x)->{ x + x; }", (Object)fsstr);
        Assert.assertEquals((Object)42, (Object)s.execute(null, new Object[]{21}));
        JexlScript s42 = jexl.createScript("s(21)");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", s);
        Object result = s42.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        result = s42.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        s42 = jexl.createScript("x-> { x + x }");
        result = s42.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var s = function(x) { x + x }; s(21)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var s = function(x, y) { x + y }; s(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaClosure() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 20; var s = function(x, y) { x + y + t}; s(15, 7)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 20; var s = function(x, y) {x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 19; ( (x, y)->{ var t = 20; x + y + t} )(15, 7);";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "( (x, y)->{ ( (xx, yy)->{xx + yy } )(x, y) } )(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = (x, y)->{ var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNestLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "( (x)->{ (y)->{ x + y } })(15)(27)";
        JexlScript s42 = jexl.createScript("( (x)->{ (y)->{ x + y } })(15)(27)");
        Object result = s42.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNestLambada() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript("(x)->{ (y)->{ x + y } }");
        JexlScript s42b = jexl.createScript(s42.toString());
        Assert.assertEquals((long)s42.hashCode(), (long)s42b.hashCode());
        Assert.assertEquals((Object)s42, (Object)s42b);
        Object result = s42.execute(null, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        Object resultb = s42.execute(null, new Object[]{15});
        Assert.assertEquals((long)result.hashCode(), (long)resultb.hashCode());
        Assert.assertEquals((Object)result, (Object)resultb);
        Assert.assertEquals((Object)result, (Object)jexl.createScript(resultb.toString(), new String[]{"x"}).execute(null, new Object[]{15}));
        JexlScript s15 = (JexlScript)result;
        Callable s15b = s15.callable(null, new Object[]{27});
        result = s15.execute(null, new Object[]{27});
        Assert.assertEquals((Object)42, (Object)result);
        result = s15b.call();
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCompareLambdaRecurse() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String factSrc = "function fact(x) { x < 2? 1 : x * fact(x - 1) }";
        JexlScript fact0 = jexl.createScript("function fact(x) { x < 2? 1 : x * fact(x - 1) }");
        JexlScript fact1 = jexl.createScript(fact0.toString());
        Assert.assertEquals((Object)fact0, (Object)fact1);
        Closure r0 = (Closure)fact0.execute(null);
        Closure r1 = (Closure)fact1.execute(null);
        Assert.assertEquals((Object)720, (Object)r0.execute(null, new Object[]{6}));
        Assert.assertEquals((Object)720, (Object)r1.execute(null, new Object[]{6}));
        Assert.assertEquals((Object)r0, (Object)r1);
        Assert.assertEquals((Object)r1, (Object)r0);
        Assert.assertEquals((Object)720, (Object)r0.execute(null, new Object[]{6}));
        Assert.assertEquals((Object)720, (Object)r1.execute(null, new Object[]{6}));
    }

    @Test
    public void testHoistLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlEvalContext ctx = new JexlEvalContext();
        ctx.getEngineOptions().setLexical(false);
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        JexlScript s15 = (JexlScript)result;
        String[] localv = s15.getLocalVariables();
        Assert.assertEquals((long)0L, (long)localv.length);
        Set hvars = s15.getVariables();
        Assert.assertEquals((long)1L, (long)hvars.size());
        strs = "(x)->{ (y)->{ var z = 169; var x; x + y } }";
        s42 = jexl.createScript(strs);
        result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        s15 = (JexlScript)result;
        localv = s15.getLocalVariables();
        Assert.assertNotNull((Object)localv);
        Assert.assertEquals((long)1L, (long)localv.length);
        hvars = s15.getVariables();
        Assert.assertEquals((long)1L, (long)hvars.size());
        result = s15.execute((JexlContext)ctx, new Object[]{27});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testRecurse() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var fact = (x)->{ if (x <= 1) 1; else x * fact(x - 1) }; fact(5)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assert.assertEquals((long)120L, (long)result);
    }

    @Test
    public void testRecurse1() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        String src = "var fact = (x)-> x <= 1? 1 : x * fact(x - 1);\nfact(5);\n";
        JexlScript script = jexl.createScript(src);
        int result = (Integer)script.execute((JexlContext)jc);
        Assert.assertEquals((long)120L, (long)result);
        String parsed = script.getParsedText();
        Assert.assertEquals((Object)src, (Object)parsed);
    }

    @Test
    public void testRecurse2() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var y = 1; var z = 1; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assert.assertEquals((long)720L, (long)result);
    }

    @Test
    public void testRecurse2b() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript fact = jexl.createScript("var y = 1; var z = 1; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) };fact");
        Script func = (Script)fact.execute((JexlContext)jc);
        String[] captured = func.getCapturedVariables();
        Assert.assertEquals((long)3L, (long)captured.length);
        Assert.assertTrue((boolean)Arrays.asList(captured).containsAll(Arrays.asList("z", "y", "fact")));
        int result = (Integer)func.execute((JexlContext)jc, new Object[]{6});
        Assert.assertEquals((long)720L, (long)result);
    }

    @Test
    public void testRecurse3() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var y = 1; var z = 1;var foo = (x)->{y + z}; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assert.assertEquals((long)720L, (long)result);
    }

    @Test
    public void testIdentity() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(x)->{ x }");
        Assert.assertArrayEquals((Object[])new String[]{"x"}, (Object[])script.getParameters());
        Object result = script.execute(null, new Object[]{42});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry1() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String[] parms = base.getUnboundParameters();
        Assert.assertEquals((long)3L, (long)parms.length);
        JexlScript script = base.curry(new Object[]{5});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)2L, (long)parms.length);
        script = script.curry(new Object[]{15});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)1L, (long)parms.length);
        script = script.curry(new Object[]{22});
        parms = script.getUnboundParameters();
        Assert.assertEquals((long)0L, (long)parms.length);
        Object result = script.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry2() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        String[] parms = script.getUnboundParameters();
        Assert.assertEquals((long)1L, (long)parms.length);
        script = script.curry(new Object[]{22});
        Object result = script.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry3() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        Object result = script.execute(null, new Object[]{22});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry4() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5});
        Object result = script.execute(null, new Object[]{15, 22});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry5() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var t = x + y + z; return t", new String[]{"x", "y", "z"});
        JexlScript script = base.curry(new Object[]{5});
        Object result = script.execute(null, new Object[]{15, 22});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test270() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String text = base.toString();
        JexlScript script = base.curry(new Object[]{5, 15});
        Assert.assertEquals((Object)text, (Object)script.toString());
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", base);
        script = jexl.createScript("return s");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)text, (Object)result.toString());
        script = jexl.createScript("return s.curry(1)");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)text, (Object)result.toString());
    }

    @Test
    public void test271a() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 1; var x = (a)->{ var y = (b) -> {base + b}; return base + y(a)}; x(40)");
        Object result = base.execute(null);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test271b() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; var sum = (x, y, z)->{ base + x + y + z }; var y = sum.curry(1); y(2,3)");
        Object result = base.execute(null);
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271c() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ 2 + x + y + z };");
        JexlScript y = base.curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271d() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; (x, y, z)->base + x + y + z;");
        JexlScript y = ((JexlScript)base.execute(null)).curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271e() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 1000; var f = (x, y)->{ var base = x + y + (base?:-1000); base; }; f(100, 20)");
        Object result = base.execute(null);
        Assert.assertEquals((Object)1120, (Object)result);
    }

    @Test
    public void testFatFact0() {
        JexlFeatures features = new JexlFeatures();
        features.fatArrow(true);
        String src = "function (a) { const fact = (x)=>{ x <= 1? 1 : x * fact(x - 1) }; fact(a) }";
        JexlEngine jexl = LambdaTest.createEngine(features);
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{6});
        Assert.assertEquals((Object)720, (Object)result);
    }

    @Test
    public void testFatFact1() {
        String src = "function (a) { const fact = (x)=> x <= 1? 1 : x * fact(x - 1) ; fact(a) }";
        JexlFeatures features = new JexlFeatures();
        features.fatArrow(true);
        JexlEngine jexl = LambdaTest.createEngine(features);
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{6});
        Assert.assertEquals((Object)720, (Object)result);
        features.fatArrow(false);
        jexl = LambdaTest.createEngine(features);
        try {
            script = jexl.createScript(src);
        }
        catch (JexlException.Feature xfeature) {
            Assert.assertTrue((boolean)xfeature.getMessage().contains("fat-arrow"));
        }
    }

    @Test
    public void testNamedFunc() {
        String src = "(let a)->{ function fact(const x) { x <= 1? 1 : x * fact(x - 1); } fact(a); }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{6});
        Assert.assertEquals((Object)720, (Object)result);
        String parsed = this.simpleWhitespace(script.getParsedText());
        Assert.assertEquals((Object)this.simpleWhitespace(src), (Object)parsed);
    }

    @Test
    public void testNamedFuncIsConst() {
        String src = "function foo(x) { x + x }; var foo ='nonononon'";
        JexlEngine jexl = LambdaTest.createEngine();
        try {
            JexlScript script = jexl.createScript(src);
            Assert.fail((String)"should fail, foo is already defined");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("foo"));
        }
    }

    @Test
    public void testFailParseFunc0() {
        String src = "if (false) function foo(x) { x + x }; var foo = 1";
        JexlEngine jexl = LambdaTest.createEngine();
        try {
            JexlScript jexlScript = jexl.createScript(src);
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("function"));
        }
    }

    @Test
    public void testFailParseFunc1() {
        String src = "if (false) let foo = (x) { x + x }; var foo = 1";
        JexlEngine jexl = LambdaTest.createEngine();
        try {
            JexlScript jexlScript = jexl.createScript(src);
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("let"));
        }
    }

    @Test
    public void testLambdaExpr0() {
        String src = "(x, y) -> x + y";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{11, 31});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr1() {
        String src = "x -> x + x";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr10() {
        String src = "(a)->{ var x = x -> x + x; x(a) }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr2() {
        String src = "x -> { { x + x } }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{21});
        Assert.assertTrue((boolean)(result instanceof Set));
        Set set = (Set)result;
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(42));
    }

    @Test
    public void testLambdaExpr3() {
        String src = "x -> ( { x + x } )";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{21});
        Assert.assertTrue((boolean)(result instanceof Set));
        Set set = (Set)result;
        Assert.assertEquals((long)1L, (long)set.size());
        Assert.assertTrue((boolean)set.contains(42));
    }
}

