/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class PragmaTest
extends JexlTestCase {
    public PragmaTest() {
        super("PragmaTest");
    }

    @Test
    public void testPragmas() {
        JexlScript script = this.JEXL.createScript("#pragma one 1\n#pragma the.very.hard 'truth'\n2;");
        Assert.assertNotNull((Object)script);
        Map pragmas = script.getPragmas();
        Assert.assertEquals((long)2L, (long)pragmas.size());
        Assert.assertEquals((Object)1, pragmas.get("one"));
        Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testJxltPragmas() {
        JxltEngine engine = new JexlBuilder().create().createJxltEngine();
        JxltEngine.Template tscript = engine.createTemplate("$$ #pragma one 1\n$$ #pragma the.very.hard 'truth'\n2;");
        Assert.assertNotNull((Object)tscript);
        Map pragmas = tscript.getPragmas();
        Assert.assertEquals((long)2L, (long)pragmas.size());
        Assert.assertEquals((Object)1, pragmas.get("one"));
        Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testSafePragma() {
        SafeContext jc = new SafeContext();
        jc.set("foo", null);
        JexlScript script = this.JEXL.createScript("#pragma jexl.safe true\nfoo.bar;");
        Assert.assertNotNull((Object)script);
        jc.processPragmas(script.getPragmas());
        Object result = script.execute((JexlContext)jc);
        Assert.assertNull((Object)result);
        jc = new SafeContext();
        jc.set("foo", null);
        try {
            script.execute((JexlContext)jc);
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testPragmaModuleNoCache() {
        ModuleContext ctxt = new ModuleContext();
        this.runPragmaModule(ctxt, null);
    }

    @Test
    public void testPragmaModuleCache() {
        CachingModuleContext ctxt = new CachingModuleContext();
        this.runPragmaModule(ctxt, ctxt);
    }

    void runPragmaModule(ModuleContext ctxt, CachingModuleContext cmCtxt) {
        ctxt.script("module0", this.JEXL.createScript("function f42(x) { 42 + x; } function f43(x) { 43 + x; }; { 'f42' : f42, 'f43' : f43 }"));
        ConcurrentHashMap modules = new ConcurrentHashMap();
        JexlScript script = this.JEXL.createScript("#pragma jexl.module.m0 \"script('module0')\"\n m0:f42(10);");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)52, (Object)result);
        if (cmCtxt != null) {
            Assert.assertEquals((long)1L, (long)cmCtxt.getCountCompute());
        }
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)52, (Object)result);
        if (cmCtxt != null) {
            Assert.assertEquals((long)1L, (long)cmCtxt.getCountCompute());
        }
        script = this.JEXL.createScript("#pragma jexl.module.m0 \"script('module0')\"\n m0:f43(10);");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)53, (Object)result);
        if (cmCtxt != null) {
            Assert.assertEquals((long)1L, (long)cmCtxt.getCountCompute());
        }
        try {
            script = this.JEXL.createScript("#pragma jexl.module.m0 ''\n#pragma jexl.module.m0 \"fubar('module0')\"\n m0:f43(10);");
            result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"fubar sshoud fail");
        }
        catch (JexlException.Method xmethod) {
            Assert.assertEquals((Object)"fubar", (Object)xmethod.getMethod());
        }
    }

    @Test
    public void testImportPragmaValueSet() {
        String src = "#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42";
        JexlScript script = this.JEXL.createScript(src);
        Map pragmas = script.getPragmas();
        Object importz = pragmas.get("jexl.import");
        Assert.assertTrue((boolean)(importz instanceof Set));
        Set importzz = (Set)importz;
        Assert.assertTrue((boolean)importzz.contains("java.util"));
        Assert.assertTrue((boolean)importzz.contains("java.io"));
        Assert.assertTrue((boolean)importzz.contains("java.net"));
        Assert.assertEquals((long)3L, (long)importzz.size());
        String parsed = script.getParsedText();
        Assert.assertEquals((Object)src, (Object)parsed);
    }

    @Test
    public void testPragmaOptions1() {
        String str = "i; #pragma jexl.options '-strict'\n";
        JexlEngine jexl = new JexlBuilder().features(new JexlFeatures().pragmaAnywhere(false)).strict(true).create();
        MapContext ctxt = new MapContext();
        try {
            JexlScript e = jexl.createScript("i; #pragma jexl.options '-strict'\n");
            Assert.fail((String)"i should not be resolved");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void testImportPragmaDisabled() {
        String src = "#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42";
        JexlFeatures features = new JexlFeatures();
        features.importPragma(false);
        JexlEngine jexl = new JexlBuilder().features(features).create();
        try {
            JexlScript jexlScript = jexl.createScript(src);
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("import pragma"));
        }
    }

    @Test
    public void testNamespacePragmaDisabled() {
        JexlFeatures features = new JexlFeatures();
        features.namespacePragma(false);
        JexlEngine jexl = new JexlBuilder().features(features).create();
        try {
            JexlScript src = jexl.createScript("#pragma jexl.namespace.sleeper " + StaticSleeper.class.getName() + "\nsleeper:sleep(100);42");
            Assert.fail((String)"should have thrown syntax exception");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("namespace pragma"));
        }
    }

    @Test
    public void testStaticNamespacePragma() {
        SafeContext jc = new SafeContext();
        JexlScript script = this.JEXL.createScript("#pragma jexl.namespace.sleeper " + StaticSleeper.class.getName() + "\nsleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testStatictNamespacePragmaCtl() {
        Map<String, String> ns = Collections.singletonMap("sleeper", StaticSleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamespacePragma() {
        SafeContext jc = new SafeContext();
        String src = "#pragma jexl.namespace.sleeper " + Sleeper.class.getName() + "\nsleeper:sleep(100);\n42;\n";
        JexlScript script = this.JEXL.createScript(src);
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
        String parsed = script.getParsedText();
        Assert.assertEquals((Object)src, (Object)parsed);
    }

    @Test
    public void testNamespacePragmaCtl() {
        Map<String, String> ns = Collections.singletonMap("sleeper", Sleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test354() {
        TreeMap<String, Number> values = new TreeMap<String, Number>();
        values.put("1", 1);
        values.put("+1", 1);
        values.put("-1", -1);
        values.put("1l", 1L);
        values.put("+1l", 1L);
        values.put("-1l", -1L);
        values.put("10h", BigInteger.valueOf(10L));
        values.put("-11h", BigInteger.valueOf(-11L));
        values.put("+12h", BigInteger.valueOf(12L));
        values.put("0xa", 10);
        values.put("+0xa", 10);
        values.put("-0xa", -10);
        values.put("0xacl", 172L);
        values.put("+0xadl", 173L);
        values.put("-0xafl", -175L);
        values.put("1d", 1.0);
        values.put("-1d", -1.0);
        values.put("+1d", 1.0);
        values.put("1f", Float.valueOf(1.0f));
        values.put("-1f", Float.valueOf(-1.0f));
        values.put("+1f", Float.valueOf(1.0f));
        values.put("1B", new BigDecimal(1));
        values.put("-1B", new BigDecimal(-1));
        values.put("+1B", new BigDecimal(1));
        values.put("-42424242424242424242424242424242", new BigInteger("-42424242424242424242424242424242"));
        values.put("+42424242424242424242424242424242", new BigInteger("+42424242424242424242424242424242"));
        values.put("42424242424242424242424242424242", new BigInteger("42424242424242424242424242424242"));
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        for (Map.Entry e : values.entrySet()) {
            String text = "#pragma number " + (String)e.getKey();
            JexlScript script = jexl.createScript(text);
            Assert.assertNotNull((Object)script);
            Map pragmas = script.getPragmas();
            Assert.assertNotNull((Object)pragmas);
            Assert.assertEquals((String)((String)e.getKey()), e.getValue(), pragmas.get("number"));
        }
    }

    public static class Sleeper {
        public void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class StaticSleeper {
        private StaticSleeper() {
        }

        public static void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class CachingModuleContext
    extends ModuleContext
    implements JexlContext.ModuleProcessor {
        private final ConcurrentMap<String, Object> modules = new ConcurrentHashMap<String, Object>();
        private final AtomicInteger count = new AtomicInteger(0);

        public int getCountCompute() {
            return this.count.get();
        }

        CachingModuleContext() {
        }

        public Object processModule(JexlEngine engine, JexlInfo info, String name, String body) {
            if (body.isEmpty()) {
                this.modules.remove(name);
                return null;
            }
            return this.modules.computeIfAbsent(name, n -> {
                Object module = engine.createExpression(info, body).evaluate((JexlContext)this);
                if (module instanceof JexlScript) {
                    module = ((JexlScript)module).execute((JexlContext)this);
                }
                this.count.incrementAndGet();
                return module;
            });
        }
    }

    public static class ModuleContext
    extends MapContext {
        protected final Map<String, JexlScript> sources = new TreeMap<String, JexlScript>();

        ModuleContext() {
        }

        public Object script(String name) {
            return this.sources.get(name);
        }

        void script(String name, JexlScript script) {
            this.sources.put(name, script);
        }
    }

    public static class SafeContext
    extends JexlEvalContext {
        public void processPragmas(Map<String, Object> pragmas) {
            if (pragmas != null && !pragmas.isEmpty()) {
                JexlOptions options = this.getEngineOptions();
                for (Map.Entry<String, Object> pragma : pragmas.entrySet()) {
                    String key = pragma.getKey();
                    Object value = pragma.getValue();
                    if ("jexl.safe".equals(key) && value instanceof Boolean) {
                        options.setSafe(((Boolean)value).booleanValue());
                        continue;
                    }
                    if ("jexl.strict".equals(key) && value instanceof Boolean) {
                        options.setStrict(((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!"jexl.silent".equals(key) || !(value instanceof Boolean)) continue;
                    options.setSilent(((Boolean)value).booleanValue());
                }
            }
        }

        public void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

