/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.jexl342.OptionalArithmetic;
import org.apache.commons.jexl3.junit.Asserter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SideEffectTest
extends JexlTestCase {
    private Asserter asserter;

    public SideEffectTest() {
        super("SideEffectTest");
    }

    @Override
    @Before
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
    }

    @Test
    public void testSideEffectVar() throws Exception {
        Integer i41;
        Map<String, Object> context = this.asserter.getVariables();
        Integer foo = i41 = Integer.valueOf(4141);
        context.put("foo", foo);
        this.asserter.assertExpression("foo += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 + 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 - 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 * 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 / 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 % 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 & 3));
        context.put("foo", foo);
        this.asserter.assertExpression("foo |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 | 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 ^ 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo <<= 2", i41 << 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 << 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo >>= 2", i41 >> 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 >> 2));
        context.put("foo", foo);
        this.asserter.assertExpression("foo >>>= 2", i41 >>> 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo"), (Object)(i41 >>> 2));
    }

    @Test
    public void testSideEffectVarDots() throws Exception {
        Integer i41;
        Map<String, Object> context = this.asserter.getVariables();
        Integer foo = i41 = Integer.valueOf(4141);
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 + 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 - 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 * 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 / 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 % 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 & 3));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 | 2));
        context.put("foo.bar.quux", foo);
        this.asserter.assertExpression("foo.bar.quux ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((Object)context.get("foo.bar.quux"), (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        String s43 = "fourty-three";
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo[0] ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectDotArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        String s42 = "fourty-two";
        String s43 = "fourty-three";
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.0 ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectAntishArray() throws Exception {
        Integer i41 = 4141;
        Integer i42 = 42;
        Integer i43 = 43;
        Object[] foo = new Object[3];
        foo[1] = i42;
        foo[2] = i43;
        this.asserter.setVariable("foo.bar", foo);
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 + 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 - 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 * 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 / 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 % 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 & 3));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 | 2));
        foo[0] = i41;
        this.asserter.assertExpression("foo.bar[0] ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((Object)foo[0], (Object)(i41 ^ 2));
    }

    @Test
    public void testSideEffectBean() throws Exception {
        Integer i41 = 4141;
        Foo foo = new Foo(0);
        this.asserter.setVariable("foo", foo);
        foo.value = i41;
        this.asserter.assertExpression("foo.value += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 + 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 - 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 * 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 / 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 % 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 & 3));
        foo.value = i41;
        this.asserter.assertExpression("foo.value |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 | 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.value ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 ^ 2));
    }

    @Test
    public void testSideEffectBeanContainer() throws Exception {
        Integer i41 = 4141;
        Foo foo = new Foo(0);
        this.asserter.setVariable("foo", foo);
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] += 2", i41 + 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 + 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[1] += 2", i41 + 3, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 + 4));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] -= 2", i41 - 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 - 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] *= 2", i41 * 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 * 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] /= 2", i41 / 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 / 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] %= 2", i41 % 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 % 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] &= 3", i41 & 3, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 & 3));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] |= 2", i41 | 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 | 2));
        foo.value = i41;
        this.asserter.assertExpression("foo.bar[0] ^= 2", i41 ^ 2, new Object[0]);
        Assert.assertEquals((long)foo.value, (long)(i41 ^ 2));
    }

    @Test
    public void testArithmeticSelf() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfOverload(jexl, jc);
        this.runSelfOverload(jexl, jc);
    }

    @Test
    public void testArithmeticSelfNoCache() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(0).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfOverload(jexl, jc);
    }

    protected void runSelfOverload(JexlEngine jexl, JexlContext jc) {
        JexlScript script = jexl.createScript("(x, y)->{ x += y }");
        Object result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3130, (Object)result);
        Var v0 = new Var(3115);
        result = script.execute(jc, new Object[]{v0, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v0);
        Assert.assertEquals((long)3130L, (long)v0.value);
        script = jexl.createScript("(x, y)->{ x -= y}");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3100, (Object)result);
        Var v1 = new Var(3115);
        result = script.execute(jc, new Object[]{v1, new Var(15)});
        Assert.assertNotEquals((Object)result, (Object)v1);
        Assert.assertEquals((long)3100L, (long)((Var)result).value);
        script = jexl.createScript("(x, y)->{ x *= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)46725, (Object)result);
        Var v2 = new Var(3115);
        result = script.execute(jc, new Object[]{v2, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v2);
        Assert.assertEquals((long)46725L, (long)v2.value);
        script = jexl.createScript("(x, y)->{ x /= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)207, (Object)result);
        Var v3 = new Var(3115);
        result = script.execute(jc, new Object[]{v3, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v3);
        Assert.assertEquals((long)207L, (long)v3.value);
        script = jexl.createScript("(x, y)->{ x %= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)10, (Object)result);
        Var v4 = new Var(3115);
        result = script.execute(jc, new Object[]{v4, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v4);
        Assert.assertEquals((long)10L, (long)v4.value);
        script = jexl.createScript("(x, y)->{ x &= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)11L, (Object)result);
        Var v5 = new Var(3115);
        result = script.execute(jc, new Object[]{v5, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v5);
        Assert.assertEquals((long)11L, (long)v5.value);
        script = jexl.createScript("(x, y)->{ x |= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3119L, (Object)result);
        Var v6 = new Var(3115);
        result = script.execute(jc, new Object[]{v6, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v6);
        Assert.assertEquals((long)3119L, (long)v6.value);
        script = jexl.createScript("(x, y)->{ x ^= y }");
        result = script.execute(jc, new Object[]{3115, 15});
        Assert.assertEquals((Object)3108L, (Object)result);
        Var v7 = new Var(3115);
        result = script.execute(jc, new Object[]{v7, new Var(15)});
        Assert.assertEquals((Object)result, (Object)v7);
        Assert.assertEquals((long)3108L, (long)v7.value);
        script = jexl.createScript("(x, y)->{ x >>>= y }");
        result = script.execute(jc, new Object[]{234453115, 5});
        Assert.assertEquals((Object)7326659L, (Object)result);
        Var v8 = new Var(234453115);
        result = script.execute(jc, new Object[]{v8, 5});
        Assert.assertEquals((Object)result, (Object)v8);
        Assert.assertEquals((long)7326659L, (long)v8.value);
        script = jexl.createScript("(x, y)->{ x >>= y }");
        result = script.execute(jc, new Object[]{435566788L, 7});
        Assert.assertEquals((Object)3402865L, (Object)result);
        Var v9 = new Var(435566788);
        result = script.execute(jc, new Object[]{v9, 7});
        Assert.assertEquals((Object)result, (Object)v9);
        Assert.assertEquals((long)3402865L, (long)v9.value);
        script = jexl.createScript("(x, y)->{ x <<= y }");
        result = script.execute(jc, new Object[]{3115, 2});
        Assert.assertEquals((Object)12460L, (Object)result);
        Var v10 = new Var(3115);
        result = script.execute(jc, new Object[]{v10, 2});
        Assert.assertEquals((Object)result, (Object)v10);
        Assert.assertEquals((long)12460L, (long)v10.value);
    }

    @Test
    public void testIncrementSelf() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfIncrement(jexl, jc);
        this.runSelfIncrement(jexl, jc);
    }

    @Test
    public void testIncrementSelfNoCache() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(0).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        this.runSelfIncrement(jexl, jc);
    }

    protected void runSelfIncrement(JexlEngine jexl, JexlContext jc) {
        JexlScript script = jexl.createScript("x -> [+x, +(x++), +x]");
        Var v11 = new Var(3115);
        AtomicInteger i11 = new AtomicInteger(3115);
        for (Object v : Arrays.asList(v11, i11)) {
            Iterator<Object> result = script.execute(jc, new Object[]{v});
            Assert.assertTrue((boolean)(result instanceof int[]));
            int[] nArray = (int[])result;
            Assert.assertEquals((long)3115L, (long)nArray[0]);
            Assert.assertEquals((long)3115L, (long)nArray[1]);
            Assert.assertEquals((long)3116L, (long)nArray[2]);
        }
        script = jexl.createScript("x -> [+x, +(++x), +x]");
        Var v12 = new Var(3189);
        AtomicInteger i12 = new AtomicInteger(3189);
        for (Object object : Arrays.asList(v12, i12)) {
            Object result = script.execute(jc, new Object[]{object});
            Assert.assertTrue((boolean)(result instanceof int[]));
            int[] r = (int[])result;
            Assert.assertEquals((long)3189L, (long)r[0]);
            Assert.assertEquals((long)3190L, (long)r[1]);
            Assert.assertEquals((long)3190L, (long)r[2]);
        }
        script = jexl.createScript("x -> [+x, +(x--), +x]");
        Var v13 = new Var(3115);
        for (Var v : Arrays.asList(v13)) {
            Object result = script.execute(jc, new Object[]{v13});
            Assert.assertTrue((boolean)(result instanceof int[]));
            int[] r = (int[])result;
            Assert.assertEquals((long)3115L, (long)r[0]);
            Assert.assertEquals((long)3115L, (long)r[1]);
            Assert.assertEquals((long)3114L, (long)r[2]);
        }
        script = jexl.createScript("x -> [+x, +(--x), +x]");
        Var var = new Var(3189);
        for (Var v : Arrays.asList(var)) {
            Object result = script.execute(jc, new Object[]{v});
            Assert.assertTrue((boolean)(result instanceof int[]));
            int[] r = (int[])result;
            Assert.assertEquals((long)3189L, (long)r[0]);
            Assert.assertEquals((long)3188L, (long)r[1]);
            Assert.assertEquals((long)3188L, (long)r[2]);
        }
    }

    @Test
    public void testOverrideGetSet() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(64).arithmetic((JexlArithmetic)new SelfArithmetic(false)).create();
        JexlContext jc = null;
        Var v0 = new Var(3115);
        JexlScript script = jexl.createScript("(x)->{ x.value}");
        Object result = script.execute(jc, new Object[]{v0});
        Assert.assertEquals((Object)3115, (Object)result);
        script = jexl.createScript("(x)->{ x['VALUE']}");
        result = script.execute(jc, new Object[]{v0});
        Assert.assertEquals((Object)3115, (Object)result);
        script = jexl.createScript("(x,y)->{ x.value = y}");
        result = script.execute(jc, new Object[]{v0, 42});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("(x,y)->{ x['VALUE'] = y}");
        result = script.execute(jc, new Object[]{v0, 169});
        Assert.assertEquals((Object)169, (Object)result);
    }

    @Test
    public void test246() throws Exception {
        this.run246(new Arithmetic246(true));
    }

    @Test
    public void test246b() throws Exception {
        this.run246(new Arithmetic246b(true));
    }

    private void run246(JexlArithmetic j246) throws Exception {
        Log log246 = LogFactory.getLog(SideEffectTest.class);
        Logger ll246 = LogManager.getLogManager().getLogger(SideEffectTest.class.getName());
        JexlEngine jexl = new JexlBuilder().arithmetic(j246).cache(32).debug(true).logger(log246).create();
        JexlScript script = jexl.createScript("z += x", new String[]{"x"});
        MapContext ctx = new MapContext();
        List z = new ArrayList(1);
        ctx.set("z", z);
        Object zz = script.execute((JexlContext)ctx, new Object[]{"42"});
        Assert.assertSame((Object)zz, z);
        Assert.assertEquals((long)1L, (long)z.size());
        z.clear();
        boolean t246 = false;
        try {
            script.execute((JexlContext)ctx, new Object[]{"42"});
            zz = ctx.get("z");
            Assert.assertTrue((boolean)(zz instanceof List));
            z = (List)zz;
            Assert.assertEquals((long)1L, (long)z.size());
        }
        catch (ArithmeticException | JexlException xjexl) {
            t246 = true;
            Assert.assertEquals(j246.getClass(), Arithmetic246.class);
        }
        ctx.clear();
        ctx.set("z", z);
        zz = script.execute((JexlContext)ctx, new Object[]{"-42"});
        Assert.assertSame((Object)zz, z);
        Assert.assertEquals((long)(t246 ? 1L : 2L), (long)z.size());
    }

    @Test
    public void test248() throws Exception {
        MapContext ctx = new MapContext();
        ArrayList<Integer> foo = new ArrayList<Integer>(Arrays.asList(10, 20, 30, 40));
        ctx.set("foo", foo);
        JexlEngine engine = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic248(true)).create();
        JexlScript foo12 = engine.createScript("foo[1..2]");
        try {
            Object r = foo12.execute((JexlContext)ctx);
            Assert.assertEquals(Arrays.asList(20, 30), (Object)r);
        }
        catch (JexlException xp) {
            Assert.assertTrue((boolean)(xp instanceof JexlException.Property));
        }
        JexlScript foo12assign = engine.createScript("foo[1..2] = x", new String[]{"x"});
        try {
            Object r = foo12assign.execute((JexlContext)ctx, new Object[]{25});
            Assert.assertEquals((Object)25, (Object)r);
            Assert.assertEquals(Arrays.asList(10, 25, 25, 40), foo);
        }
        catch (JexlException xp) {
            Assert.assertTrue((boolean)(xp instanceof JexlException.Property));
        }
    }

    public static class Arithmetic248
    extends JexlArithmetic {
        public Arithmetic248(boolean strict) {
            super(strict);
        }

        public Object arrayGet(List<?> list, Collection<Integer> range) {
            ArrayList rl = new ArrayList(range.size());
            for (int i : range) {
                rl.add(list.get(i));
            }
            return rl;
        }

        public Object arraySet(List<Object> list, Collection<Integer> range, Object value) {
            for (int i : range) {
                list.set(i, value);
            }
            return list;
        }
    }

    public static class Arithmetic246b
    extends Arithmetic246 {
        public Arithmetic246b(boolean astrict) {
            super(astrict);
        }

        public Object selfAdd(Object c, String item) throws IOException {
            if (c == null) {
                return new ArrayList<String>(Collections.singletonList(item));
            }
            if (c instanceof Appendable) {
                ((Appendable)c).append(item);
                return c;
            }
            return JexlEngine.TRY_FAILED;
        }
    }

    public static class Arithmetic246
    extends JexlArithmetic {
        public Arithmetic246(boolean astrict) {
            super(astrict);
        }

        public Object selfAdd(Collection<String> c, String item) throws IOException {
            c.add(item);
            return c;
        }

        public Object selfAdd(Appendable c, String item) throws IOException {
            c.append(item);
            return c;
        }

        public Object add(Object right, Object left) {
            return super.add(left, right);
        }
    }

    public static class SelfArithmetic
    extends OptionalArithmetic {
        public SelfArithmetic(boolean strict) {
            super(strict);
        }

        public Object propertyGet(Var var, String property) {
            return "value".equals(property) ? Integer.valueOf(var.value) : JexlEngine.TRY_FAILED;
        }

        public Object propertySet(Var var, String property, int v) {
            Object object;
            if ("value".equals(property)) {
                var.value = v;
                object = var.value;
            } else {
                object = JexlEngine.TRY_FAILED;
            }
            return object;
        }

        public Object arrayGet(Var var, String property) {
            return "VALUE".equals(property) ? Integer.valueOf(var.value) : JexlEngine.TRY_FAILED;
        }

        public Object arraySet(Var var, String property, int v) {
            Object object;
            if ("VALUE".equals(property)) {
                var.value = v;
                object = var.value;
            } else {
                object = JexlEngine.TRY_FAILED;
            }
            return object;
        }

        public Var selfAdd(Var lhs, Var rhs) {
            lhs.value += rhs.value;
            return lhs;
        }

        public Var selfSubtract(Var lhs, Var rhs) {
            return new Var(lhs.value - rhs.value);
        }

        public Var selfDivide(Var lhs, Var rhs) {
            lhs.value /= rhs.value;
            return lhs;
        }

        public Var selfMultiply(Var lhs, Var rhs) {
            lhs.value *= rhs.value;
            return lhs;
        }

        public Var selfMod(Var lhs, Var rhs) {
            lhs.value %= rhs.value;
            return lhs;
        }

        public Var and(Var lhs, Var rhs) {
            return new Var(lhs.value & rhs.value);
        }

        public Var selfAnd(Var lhs, Var rhs) {
            lhs.value &= rhs.value;
            return lhs;
        }

        public Var or(Var lhs, Var rhs) {
            return new Var(lhs.value | rhs.value);
        }

        public Var selfOr(Var lhs, Var rhs) {
            lhs.value |= rhs.value;
            return lhs;
        }

        public Var xor(Var lhs, Var rhs) {
            return new Var(lhs.value ^ rhs.value);
        }

        public Var selfXor(Var lhs, Var rhs) {
            lhs.value ^= rhs.value;
            return lhs;
        }

        public Var shiftLeft(Var lhs, int rhs) {
            return new Var(lhs.value << rhs);
        }

        public Var selfShiftLeft(Var lhs, int rhs) {
            lhs.value <<= rhs;
            return lhs;
        }

        public Var shiftRight(Var lhs, int rhs) {
            return new Var(lhs.value >> rhs);
        }

        public Var selfShiftRight(Var lhs, int rhs) {
            lhs.value >>= rhs;
            return lhs;
        }

        public Var shiftRightUnsigned(Var lhs, int rhs) {
            return new Var(lhs.value >>> rhs);
        }

        public Var selfShiftRightUnsigned(Var lhs, int rhs) {
            lhs.value >>>= rhs;
            return lhs;
        }

        public int increment(Var lhs) {
            return lhs.value + 1;
        }

        public int decrement(Var lhs) {
            return lhs.value - 1;
        }

        public int incrementAndGet(AtomicInteger i) {
            return i.incrementAndGet();
        }

        public int getAndIncrement(AtomicInteger i) {
            return i.getAndIncrement();
        }

        public int positivize(Var n) {
            return n.value;
        }

        public int positivize(Number n) {
            return n.intValue();
        }
    }

    public static class Var {
        int value;

        Var(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    public static class Foo {
        int value;

        Foo(int v) {
            this.value = v;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public void setValue(long v) {
            this.value = (int)v;
        }

        public int getValue() {
            return this.value;
        }

        public void setBar(int x, long v) {
            this.value = (int)v + x;
        }

        public int getBar(int x) {
            return this.value + x;
        }
    }
}

