/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.examples;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.Assert;
import org.junit.Test;

public class StreamTest {
    private final JexlEngine jexl;

    public StreamTest() {
        JexlFeatures features = new JexlFeatures().loops(false).sideEffectGlobal(false).sideEffect(false);
        JexlPermissions.ClassPermissions permissions = new JexlPermissions.ClassPermissions(new Class[]{URI.class});
        this.jexl = new JexlBuilder().permissions((JexlPermissions)permissions).create();
    }

    @Test
    public void testURIStream() throws Exception {
        List<URI> uris = Arrays.asList(URI.create("http://user@www.apache.org:8000?qry=true"), URI.create("https://commons.apache.org/releases/prepare.html"), URI.create("mailto:henrib@apache.org"));
        List control = uris.stream().map(uri -> uri.getScheme().startsWith("http") ? "https://" + uri.getHost() : null).filter(x -> x != null).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)control.size());
        JexlScript mapper = this.jexl.createScript("uri.scheme =^ 'http'? `https://${uri.host}` : null", new String[]{"uri"});
        JexlScript transform = this.jexl.createScript("list.stream().map(mapper).filter(x -> !!x).collect(Collectors.toList())", new String[]{"list"});
        StreamContext sctxt = new StreamContext();
        sctxt.set("Collectors", Collectors.class);
        sctxt.set("mapper", mapper);
        Object transformed = transform.execute((JexlContext)sctxt, new Object[]{uris});
        Assert.assertTrue((boolean)(transformed instanceof List));
        Assert.assertEquals(control, (Object)transformed);
    }

    public static class StreamContext
    extends MapContext {
        public Stream<?> map(Stream<?> stream, JexlScript mapper) {
            return stream.map(x -> mapper.execute((JexlContext)this, new Object[]{x}));
        }

        public Stream<?> filter(Stream<?> stream, JexlScript filter) {
            return stream.filter(x -> x != null && Boolean.TRUE.equals(filter.execute((JexlContext)this, new Object[]{x})));
        }
    }
}

