/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.introspection.ArrayIterator;
import org.apache.commons.jexl3.internal.introspection.ArrayListWrapper;
import org.junit.Assert;
import org.junit.Test;

public class MiscIntrospectionTest {
    @Test
    public void testEmptyContext() {
        try {
            JexlEngine.EMPTY_CONTEXT.set("nope", (Object)42);
            Assert.fail((String)"empty context should be readonly");
        }
        catch (UnsupportedOperationException xun) {
            Assert.assertNotNull((Object)xun);
        }
    }

    @Test
    public void testArrayIterator() {
        try {
            new ArrayIterator(new ArrayList());
        }
        catch (IllegalArgumentException xill) {
            Assert.assertNotNull((Object)xill);
        }
        ArrayIterator ai0 = new ArrayIterator(null);
        Assert.assertFalse((boolean)ai0.hasNext());
        try {
            ai0.next();
            Assert.fail((String)"should have failed");
        }
        catch (NoSuchElementException no) {
            Assert.assertNotNull((Object)no);
        }
        ai0 = new ArrayIterator((Object)new int[]{42});
        Assert.assertTrue((boolean)ai0.hasNext());
        Assert.assertEquals((Object)42, (Object)ai0.next());
        Assert.assertFalse((boolean)ai0.hasNext());
        try {
            ai0.next();
            Assert.fail((String)"iterator on null?");
        }
        catch (NoSuchElementException no) {
            Assert.assertNotNull((Object)no);
        }
        try {
            ai0.remove();
            Assert.fail((String)"should have failed");
        }
        catch (UnsupportedOperationException no) {
            Assert.assertNotNull((Object)no);
        }
    }

    @Test
    public void testArrayListWrapper() {
        try {
            new ArrayListWrapper((Object)1);
            Assert.fail((String)"non-array wrap?");
        }
        catch (IllegalArgumentException xil) {
            Assert.assertNotNull((Object)xil);
        }
        Integer[] ai = new Integer[]{1, 2};
        ArrayListWrapper alw = new ArrayListWrapper((Object)ai);
        Assert.assertEquals((long)1L, (long)alw.indexOf((Object)2));
        Assert.assertEquals((long)-1L, (long)alw.indexOf(null));
    }
}

