/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.jexl3.annotations.NoJexl;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.junit.Assert;
import org.junit.Test;

public class NoJexlTest {
    @Test
    public void testNoJexlPermissions() throws Exception {
        Permissions p = Permissions.UNRESTRICTED;
        Assert.assertFalse((boolean)p.allow((Field)null));
        Assert.assertFalse((boolean)p.allow((Package)null));
        Assert.assertFalse((boolean)p.allow((Method)null));
        Assert.assertFalse((boolean)p.allow((Constructor)null));
        Assert.assertFalse((boolean)p.allow((Class)null));
        Assert.assertFalse((boolean)p.allow(A2.class));
        Assert.assertTrue((boolean)p.allow(A3.class));
        Assert.assertTrue((boolean)p.allow(A5.class));
        Method mA = A.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA);
        Method mA0 = A0.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA0);
        Method mA1 = A1.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA1);
        Method mA2 = A2.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA2);
        Method mA3 = A2.class.getDeclaredMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA3);
        Assert.assertTrue((boolean)p.allow(mA));
        Assert.assertFalse((boolean)p.allow(mA0));
        Assert.assertFalse((boolean)p.allow(mA1));
        Assert.assertFalse((boolean)p.allow(mA2));
        Assert.assertFalse((boolean)p.allow(mA3));
        Field fA = A.class.getField("i");
        Assert.assertNotNull((Object)fA);
        Assert.assertTrue((boolean)p.allow(fA));
        Field fA0 = A0.class.getField("i0");
        Assert.assertNotNull((Object)fA0);
        Assert.assertFalse((boolean)p.allow(fA0));
        Field fA1 = A1.class.getDeclaredField("i1");
        Assert.assertNotNull((Object)fA1);
        Assert.assertFalse((boolean)p.allow(fA0));
        Constructor cA = A.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA);
        Assert.assertTrue((boolean)p.allow(cA));
        Constructor cA0 = A0.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA0);
        Assert.assertFalse((boolean)p.allow(cA0));
        Constructor cA3 = A3.class.getDeclaredConstructor(new Class[0]);
        Assert.assertNotNull(cA3);
        Assert.assertFalse((boolean)p.allow(cA3));
    }

    @NoJexl
    public static interface InterNoJexl5 {
        public int method();
    }

    public static class A5
    implements InterNoJexl5 {
        @Override
        public int method() {
            return 0;
        }
    }

    protected static class A3 {
        protected int i3;

        protected A3() {
        }

        int method() {
            return 4;
        }
    }

    @NoJexl
    public static class A2
    extends A {
        @Override
        public int method() {
            return 3;
        }
    }

    public static class A1
    extends A
    implements InterNoJexl1 {
        private int i1;

        @NoJexl
        public A1() {
        }

        @Override
        public int method() {
            return 2;
        }
    }

    public static class A0
    extends A
    implements InterNoJexl0 {
        @NoJexl
        public int i0;

        @NoJexl
        public A0() {
        }

        @Override
        public int method() {
            return 1;
        }
    }

    public static interface InterNoJexl1 {
        @NoJexl
        public int method();
    }

    @NoJexl
    public static interface InterNoJexl0 {
        public int method();
    }

    public static class A {
        public int i;

        public int method() {
            return 0;
        }
    }
}

