/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.annotation.ElementType;
import java.lang.instrument.ClassDefinition;
import java.lang.invoke.CallSite;
import java.lang.management.BufferPoolMXBean;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.introspection.ClassTool;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.internal.introspection.nojexlpackage.Invisible;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.Assert;
import org.junit.Test;

public class PermissionsTest {
    JexlPermissions permissions0() {
        String src = " org.apache.commons.jexl3.internal.introspection { PermissionsTest { InterNoJexl0 { } InterNoJexl1 { method(); } A0 { A0(); i0; } A1 { A1(); } A2 { } InterNoJexl5 { } } }";
        Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{src});
        return p;
    }

    @Test
    public void testPermissions0() throws Exception {
        this.runTestPermissions(this.permissions0());
    }

    @Test
    public void testPermissions1() throws Exception {
        this.runTestPermissions((JexlPermissions)new JexlPermissions.Delegate(this.permissions0()){

            public String toString() {
                return "delegate:" + this.base.toString();
            }
        });
    }

    @Test
    public void testPermissions2() throws Exception {
        this.runTestPermissions((JexlPermissions)new JexlPermissions.ClassPermissions(this.permissions0(), Collections.emptySet()));
    }

    private void runTestPermissions(JexlPermissions p) throws Exception {
        Assert.assertFalse((boolean)p.allow((Field)null));
        Assert.assertFalse((boolean)p.allow((Package)null));
        Assert.assertFalse((boolean)p.allow((Method)null));
        Assert.assertFalse((boolean)p.allow((Constructor)null));
        Assert.assertFalse((boolean)p.allow((Class)null));
        Assert.assertFalse((boolean)p.allow(A2.class));
        Assert.assertTrue((boolean)p.allow(A3.class));
        Assert.assertTrue((boolean)p.allow(A5.class));
        Method mA = A.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA);
        Method mA0 = A0.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA0);
        Method mA1 = A1.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA1);
        Method mA2 = A2.class.getMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA2);
        Method mA3 = A2.class.getDeclaredMethod("method", new Class[0]);
        Assert.assertNotNull((Object)mA3);
        Assert.assertTrue((boolean)p.allow(mA));
        Assert.assertFalse((boolean)p.allow(mA0));
        Assert.assertFalse((boolean)p.allow(mA1));
        Assert.assertFalse((boolean)p.allow(mA2));
        Assert.assertFalse((boolean)p.allow(mA3));
        Field fA = A.class.getField("i");
        Assert.assertNotNull((Object)fA);
        Assert.assertTrue((boolean)p.allow(fA));
        Field fA0 = A0.class.getField("i0");
        Assert.assertNotNull((Object)fA0);
        Assert.assertFalse((boolean)p.allow(fA0));
        Field fA1 = A1.class.getDeclaredField("i1");
        Assert.assertNotNull((Object)fA1);
        Assert.assertFalse((boolean)p.allow(fA0));
        Constructor cA = A.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA);
        Assert.assertTrue((boolean)p.allow(cA));
        Constructor cA0 = A0.class.getConstructor(new Class[0]);
        Assert.assertNotNull(cA0);
        Assert.assertFalse((boolean)p.allow(cA0));
        Constructor cA3 = A3.class.getDeclaredConstructor(new Class[0]);
        Assert.assertNotNull(cA3);
        Assert.assertFalse((boolean)p.allow(cA3));
    }

    static Method getMethod(Class<?> clazz, String method) {
        return Arrays.stream(clazz.getMethods()).filter(mth -> mth.getName().equals(method)).findFirst().get();
    }

    @Test
    public void testParsePermissions0() throws Exception {
        String src = "java.lang { Runtime { exit(); exec(); } }\njava.net { URL {} }";
        Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{src});
        Map nojexlmap = p.getPackages();
        Assert.assertNotNull((Object)nojexlmap);
        Permissions.NoJexlPackage njp = (Permissions.NoJexlPackage)nojexlmap.get("java.lang");
        Assert.assertNotNull((Object)njp);
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assert.assertNotNull((Object)exit);
        Assert.assertFalse((boolean)p.allow(exit));
        Method exec = PermissionsTest.getMethod(Runtime.class, "exec");
        Assert.assertNotNull((Object)exec);
        Assert.assertFalse((boolean)p.allow(exec));
        Uberspect uber = new Uberspect(null, null, (JexlPermissions)p);
        Assert.assertNull((Object)uber.getClassByName("java.net.URL"));
    }

    @Test
    public void testGetPackageName() {
        String PKG = "org.apache.commons.jexl3.internal.introspection";
        String pkg = ClassTool.getPackageName(Outer.class);
        Assert.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        pkg = ClassTool.getPackageName(Outer.Inner.class);
        Assert.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        Outer[] oo = new Outer[]{};
        pkg = ClassTool.getPackageName(oo.getClass());
        Assert.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        Outer.Inner[] ii = new Outer.Inner[]{};
        pkg = ClassTool.getPackageName(ii.getClass());
        Assert.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        pkg = ClassTool.getPackageName(Process.class);
        Assert.assertEquals((Object)"java.lang", (Object)pkg);
        pkg = ClassTool.getPackageName(Integer.TYPE);
        Assert.assertEquals((Object)"java.lang", (Object)pkg);
    }

    @Test
    public void testParsePermissions1() {
        String[] src = new String[]{"java.lang.*", "java.math.*", "java.text.*", "java.util.*", "java.lang { Runtime {} }", "java.rmi {}", "java.io { File {} }", "java.nio { Path {} }", "org.apache.commons.jexl3.internal.introspection { PermissionsTest { #level 0\n Outer { #level 1\n Inner { #level 2\n callMeNot(); } } } }"};
        Permissions p = (Permissions)JexlPermissions.parse((String[])src);
        Map nojexlmap = p.getPackages();
        Assert.assertNotNull((Object)nojexlmap);
        Set wildcards = p.getWildcards();
        Assert.assertEquals((long)4L, (long)wildcards.size());
        JexlEngine jexl = new JexlBuilder().permissions((JexlPermissions)p).safe(false).lexical(true).create();
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assert.assertNotNull((Object)exit);
        Assert.assertFalse((boolean)p.allow(exit));
        Method exec = PermissionsTest.getMethod(Runtime.class, "getRuntime");
        Assert.assertNotNull((Object)exec);
        Assert.assertFalse((boolean)p.allow(exec));
        Method callMeNot = PermissionsTest.getMethod(Outer.Inner.class, "callMeNot");
        Assert.assertNotNull((Object)callMeNot);
        Assert.assertFalse((boolean)p.allow(callMeNot));
        JexlScript script = jexl.createScript("o.callMeNot()", new String[]{"o"});
        try {
            Object result = script.execute(null, new Object[]{new Outer.Inner()});
            Assert.fail((String)"callMeNot should be uncallable");
        }
        catch (JexlException.Method xany) {
            Assert.assertEquals((Object)"callMeNot", (Object)xany.getMethod());
        }
        Method uncallable = PermissionsTest.getMethod(Invisible.class, "uncallable");
        Assert.assertFalse((boolean)p.allow(uncallable));
        Package ip = Invisible.class.getPackage();
        Assert.assertFalse((boolean)p.allow(ip));
        script = jexl.createScript("o.uncallable()", new String[]{"o"});
        try {
            Object result = script.execute(null, new Object[]{new Invisible()});
            Assert.fail((String)"uncallable should be uncallable");
        }
        catch (JexlException.Method xany) {
            Assert.assertEquals((Object)"uncallable", (Object)xany.getMethod());
        }
    }

    @Test
    public void testWildCardPackages() {
        HashSet<String> wildcards = new HashSet<String>(Arrays.asList("com.apache.*"));
        boolean found = Permissions.wildcardAllow(wildcards, (String)"com.apache.commons.jexl3");
        Assert.assertTrue((boolean)found);
        found = Permissions.wildcardAllow(wildcards, (String)"com.google.spexl");
        Assert.assertFalse((boolean)found);
    }

    @Test
    public void testSecurePermissions() {
        Assert.assertNotNull((Object)JexlTestCase.SECURE);
        List<Class> acs = Arrays.asList(Runtime.class, BigDecimal.class, SimpleDateFormat.class, Map.class);
        for (Class ac : acs) {
            Package p = ac.getPackage();
            Assert.assertNotNull((String)ac.getName(), (Object)p);
            Assert.assertTrue((String)ac.getName(), (boolean)JexlTestCase.SECURE.allow(p));
        }
        List<Class> nacs = Arrays.asList(ElementType.class, ClassDefinition.class, CallSite.class, BufferPoolMXBean.class, SoftReference.class, Method.class);
        for (Class nac : nacs) {
            Package p = nac.getPackage();
            Assert.assertNotNull((String)nac.getName(), (Object)p);
            Assert.assertFalse((String)nac.getName(), (boolean)JexlTestCase.SECURE.allow(p));
        }
    }

    @Test
    public void testParsePermissionsFailures() {
        String[] srcs;
        for (String src : srcs = new String[]{"java.lang.*.*", "java.math.*.", "java.text.*;", "java.lang {{ Runtime {} }", "java.rmi {}}", "java.io { Text File {} }", "java.io { File { m.x } }"}) {
            try {
                Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{src});
                Assert.fail((String)src);
            }
            catch (IllegalStateException xill) {
                Assert.assertNotNull((Object)xill);
            }
        }
    }

    @Test
    public void testProtectedOverride0() {
        Object r;
        Foo3 foo3 = new Foo3();
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        Foo2 foo2 = new Foo2();
        JexlScript script = jexl.createScript("x.protectedMethod()", new String[]{"x"});
        try {
            r = script.execute(null, new Object[]{foo2});
            Assert.fail((String)"protectedMethod() is not public through superclass Foo2");
        }
        catch (JexlException xjexl) {
            Assert.assertNotNull((Object)((Object)xjexl));
        }
        foo2 = new Foo3();
        r = script.execute(null, new Object[]{foo3});
        Assert.assertEquals((Object)"foo3", (Object)r);
    }

    @Test
    public void testProtectedOverride1() {
        LinkedList<String> a = new LinkedList<String>();
        a.add("aaa");
        a.add("bbb");
        String src = "a.clone()";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(src);
        MapContext context = new MapContext();
        context.set("a", a);
        Object result = script.execute((JexlContext)context, new Object[]{a});
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testPrivateOverload1() throws Exception {
        String src = "parseDouble(\"PHM1\".substring(3)).intValue()";
        I33Arithmetic jexla = new I33Arithmetic(true);
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic((JexlArithmetic)jexla).create();
        JexlScript script = jexl.createScript(src);
        Assert.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assert.assertEquals((Object)1, (Object)result);
    }

    public class I33Arithmetic
    extends JexlArithmetic {
        public I33Arithmetic(boolean astrict) {
            super(astrict);
        }

        public double parseDouble(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
    }

    public static class Foo3
    extends Foo2 {
        @Override
        public String protectedMethod() {
            return "foo3";
        }

        @Override
        public String publicMethod() {
            return "foo3";
        }
    }

    protected static class Foo2 {
        protected Foo2() {
        }

        protected String protectedMethod() {
            return "foo2";
        }

        public String publicMethod() {
            return "foo2";
        }
    }

    public static class Outer {

        public static class Inner {
            public void callMeNot() {
            }
        }
    }

    public static interface InterNoJexl5 {
        public int method();
    }

    public static class A5
    implements InterNoJexl5 {
        @Override
        public int method() {
            return 0;
        }
    }

    protected static class A3 {
        protected int i3;

        protected A3() {
        }

        int method() {
            return 4;
        }
    }

    public static class A2
    extends A {
        @Override
        public int method() {
            return 3;
        }
    }

    public static class A1
    extends A
    implements InterNoJexl1 {
        private int i1;

        @Override
        public int method() {
            return 2;
        }
    }

    public static class A0
    extends A
    implements InterNoJexl0 {
        public int i0;

        @Override
        public int method() {
            return 1;
        }
    }

    public static interface InterNoJexl1 {
        public int method();
    }

    public static interface InterNoJexl0 {
        public int method();
    }

    public static class A {
        public int i;

        public int method() {
            return 0;
        }
    }
}

