/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.jexl342;

import java.lang.ref.Reference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.internal.ArrayBuilder;
import org.apache.commons.jexl3.internal.MapBuilder;
import org.apache.commons.jexl3.internal.SetBuilder;

public class OptionalArithmetic
extends JexlArithmetic {
    public OptionalArithmetic(boolean astrict) {
        super(astrict);
    }

    protected Object star(Object ref) {
        if (ref instanceof Optional) {
            Optional o = (Optional)ref;
            return o.orElse(null);
        }
        if (ref instanceof Reference) {
            Optional r = (Optional)ref;
            return r.get();
        }
        if (ref instanceof AtomicReference) {
            AtomicReference r = (AtomicReference)ref;
            return r.get();
        }
        return ref;
    }

    public Object controlReturn(Object returned) {
        return this.star(returned);
    }

    protected boolean isNullOperand(Object val) {
        return super.isNullOperand(this.star(val));
    }

    public boolean toBoolean(Object val) {
        return super.toBoolean(this.star(val));
    }

    public String toString(Object val) {
        return super.toString(this.star(val));
    }

    public int toInteger(Object val) {
        return super.toInteger(this.star(val));
    }

    public long toLong(Object val) {
        return super.toLong(this.star(val));
    }

    public double toDouble(Object val) {
        return super.toDouble(this.star(val));
    }

    public BigInteger toBigInteger(Object val) {
        return super.toBigInteger(this.star(val));
    }

    public BigDecimal toBigDecimal(Object val) {
        return super.toBigDecimal(this.star(val));
    }

    public Integer size(Object object, Integer def) {
        return super.size(this.star(object), def);
    }

    public Boolean empty(Object o) {
        return super.empty(this.star(o));
    }

    public Boolean isEmpty(Object object, Boolean def) {
        return super.isEmpty(this.star(object), def);
    }

    public Object positivize(Object o) {
        return super.positivize(this.star(o));
    }

    public Object negate(Object o) {
        return super.negate(this.star(o));
    }

    public Object complement(Object o) {
        return super.complement(this.star(o));
    }

    public Boolean contains(Object lhs, Object rhs) {
        return super.contains(this.star(lhs), this.star(rhs));
    }

    public Object add(Object lhs, Object rhs) {
        return super.add(this.star(lhs), this.star(rhs));
    }

    public Object subtract(Object lhs, Object rhs) {
        return super.subtract(this.star(lhs), this.star(rhs));
    }

    public Object multiply(Object lhs, Object rhs) {
        return super.multiply(this.star(lhs), this.star(rhs));
    }

    public Object divide(Object lhs, Object rhs) {
        return super.divide(this.star(lhs), this.star(rhs));
    }

    public Object mod(Object lhs, Object rhs) {
        return super.mod(this.star(lhs), this.star(rhs));
    }

    public Object and(Object left, Object right) {
        return super.and(this.star(left), this.star(right));
    }

    public Object or(Object left, Object right) {
        return super.or(this.star(left), this.star(right));
    }

    public Object xor(Object left, Object right) {
        return super.xor(this.star(left), this.star(right));
    }

    public Object shiftLeft(Object left, Object right) {
        return super.shiftLeft(this.star(left), this.star(right));
    }

    public Object shiftRight(Object left, Object right) {
        return super.shiftRight(this.star(left), this.star(right));
    }

    public Object shiftRightUnsigned(Object left, Object right) {
        return super.shiftRightUnsigned(this.star(left), this.star(right));
    }

    public Boolean startsWith(Object left, Object right) {
        return super.startsWith(this.star(left), this.star(right));
    }

    public Boolean endsWith(Object left, Object right) {
        return super.endsWith(this.star(left), this.star(right));
    }

    public boolean equals(Object left, Object right) {
        return this.equals(this.star(left), this.star(right));
    }

    public boolean greaterThan(Object left, Object right) {
        return this.greaterThan(this.star(left), this.star(right));
    }

    public boolean greaterThanOrEqual(Object left, Object right) {
        return this.greaterThanOrEqual(this.star(left), this.star(right));
    }

    public boolean lessThan(Object left, Object right) {
        return this.lessThan(this.star(left), this.star(right));
    }

    public boolean lessThanOrEqual(Object left, Object right) {
        return this.lessThanOrEqual(this.star(left), this.star(right));
    }

    public boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        if (args != null) {
            for (int a = 0; a < args.length; ++a) {
                Number narrow;
                Number narg;
                Object arg = args[a];
                Object sarg = this.star(arg);
                if (sarg != arg) {
                    narrowed = true;
                }
                if (!(arg instanceof Number) || (narg = (Number)arg).equals(narrow = this.narrow(narg))) continue;
                args[a] = narrow;
                narrowed = true;
            }
        }
        return narrowed;
    }

    public JexlArithmetic.ArrayBuilder arrayBuilder(int size) {
        return new ArrayBuilder(size){

            public void add(Object value) {
                super.add(OptionalArithmetic.this.star(value));
            }
        };
    }

    public JexlArithmetic.SetBuilder setBuilder(int size) {
        return new SetBuilder(size){

            public void add(Object value) {
                super.add(OptionalArithmetic.this.star(value));
            }
        };
    }

    public JexlArithmetic.MapBuilder mapBuilder(int size) {
        return new MapBuilder(size){

            public void put(Object key, Object value) {
                super.put(key, OptionalArithmetic.this.star(value));
            }
        };
    }
}

