/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.logging.Log;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AnnotationTest
extends JexlTestCase {
    public static final int NUM_THREADS = 10;
    public static final int NUM_ITERATIONS = 1000;

    public AnnotationTest() {
        super("AnnotationTest");
    }

    @Test
    public void test197a() throws Exception {
        MapContext jc = new MapContext();
        JexlScript e = this.JEXL.createScript("@synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
    }

    @Test
    public void testError() throws Exception {
        this.testError(true);
        this.testError(false);
    }

    private void testError(boolean silent) throws Exception {
        CaptureLog log = new CaptureLog();
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().logger((Log)log).strict(true).silent(silent).create();
        JexlScript e = jexl.createScript("@error('42') { return 42; }");
        try {
            Object r = e.execute((JexlContext)jc);
            if (!silent) {
                Assertions.fail((String)"should have failed");
            } else {
                Assertions.assertEquals((int)1, (int)log.count("warn"));
            }
        }
        catch (JexlException.Annotation xjexl) {
            Assertions.assertEquals((Object)"error", (Object)xjexl.getAnnotation());
        }
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("error"));
        Assertions.assertTrue((boolean)jc.getNames().contains("42"));
        if (!silent) {
            Assertions.assertEquals((int)0, (int)log.count("warn"));
        }
    }

    @Test
    public void testHoistingStatement() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("var t = 1; @synchronized for(var x : [2,3,7]) t *= x; t");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testJexlSynchronized0() throws InterruptedException {
        TestRunner tr = new TestRunner();
        AnnotationContext ctxt = new AnnotationContext();
        JexlScript script = this.JEXL.createScript("for(var i : 1..NUM_ITERATIONS) {@synchronized { syncCounter.inc(); }concCounter.inc();}", new String[]{"NUM_ITERATIONS", "syncCounter", "concCounter"});
        tr.run(() -> script.execute((JexlContext)ctxt, new Object[]{1000, tr.syncCounter, tr.concCounter}));
    }

    @Test
    public void testMultiple() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("@one(1) @synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)2, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
        Assertions.assertTrue((boolean)jc.getNames().contains("one"));
        Assertions.assertTrue((boolean)jc.getNames().contains("1"));
    }

    @Test
    public void testNoArg() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("@synchronized { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testNoArgExpression() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("@synchronized 42");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testNoArgStatement() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("@synchronized if (true) 2 * 3 * 7; else -42;");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("synchronized"));
    }

    @Test
    public void testOneArg() throws Exception {
        AnnotationContext jc = new AnnotationContext();
        JexlScript e = this.JEXL.createScript("@one(1) { return 42; }");
        Object r = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("one"));
        Assertions.assertTrue((boolean)jc.getNames().contains("1"));
    }

    @Test
    public void testSynchronized() throws InterruptedException {
        TestRunner tr = new TestRunner();
        Counter syncCounter = tr.syncCounter;
        Counter concCounter = tr.concCounter;
        tr.run(() -> {
            for (int i = 0; i < 1000; ++i) {
                Counter counter = syncCounter;
                synchronized (counter) {
                    syncCounter.inc();
                }
                concCounter.inc();
            }
        });
    }

    @Test
    public void testUnknown() throws Exception {
        this.testUnknown(true);
        this.testUnknown(false);
    }

    private void testUnknown(boolean silent) throws Exception {
        CaptureLog log = new CaptureLog();
        AnnotationContext jc = new AnnotationContext();
        JexlEngine jexl = new JexlBuilder().logger((Log)log).strict(true).silent(silent).create();
        JexlScript e = jexl.createScript("@unknown('42') { return 42; }");
        try {
            Object r = e.execute((JexlContext)jc);
            if (!silent) {
                Assertions.fail((String)"should have failed");
            } else {
                Assertions.assertEquals((int)1, (int)log.count("warn"));
            }
        }
        catch (JexlException.Annotation xjexl) {
            Assertions.assertEquals((Object)"unknown", (Object)xjexl.getAnnotation());
        }
        Assertions.assertEquals((int)1, (int)jc.getCount());
        Assertions.assertTrue((boolean)jc.getNames().contains("unknown"));
        Assertions.assertFalse((boolean)jc.getNames().contains("42"));
        if (!silent) {
            Assertions.assertEquals((int)0, (int)log.count("warn"));
        }
    }

    @Test
    public void testVarStmt() throws Exception {
        OptAnnotationContext jc = new OptAnnotationContext();
        JexlOptions options = jc.getEngineOptions();
        jc.getEngineOptions().set(this.JEXL);
        options.setSharedInstance(true);
        JexlScript e = this.JEXL.createScript("(s, v)->{ @strict(s) @silent(v) var x = y ; 42; }");
        Object r = e.execute((JexlContext)jc, new Object[]{false, true});
        Assertions.assertEquals((Object)42, (Object)r);
        r = null;
        options.setSafe(false);
        Assertions.assertThrows(JexlException.Variable.class, () -> e.execute((JexlContext)jc, new Object[]{true, false}));
        r = null;
        r = e.execute((JexlContext)jc, new Object[]{true, true});
        Assertions.assertNull((Object)r);
        options.setSafe(true);
        r = null;
        r = e.execute((JexlContext)jc, new Object[]{false, false});
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertTrue((boolean)options.isStrict());
        JexlScript e2 = this.JEXL.createScript("@scale(5) 42;");
        r = e2.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)r);
        Assertions.assertTrue((boolean)options.isStrict());
        Assertions.assertEquals((int)5, (int)options.getMathScale());
    }

    public static class AnnotationContext
    extends MapContext
    implements JexlContext.AnnotationProcessor {
        private int count;
        private final Set<String> names = new TreeSet<String>();

        public int getCount() {
            return this.count;
        }

        public Set<String> getNames() {
            return this.names;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            ++this.count;
            this.names.add(name);
            if ("one".equals(name)) {
                this.names.add(args[0].toString());
            } else if ("two".equals(name)) {
                this.names.add(args[0].toString());
                this.names.add(args[1].toString());
            } else {
                if ("error".equals(name)) {
                    this.names.add(args[0].toString());
                    throw new IllegalArgumentException(args[0].toString());
                }
                if ("unknown".equals(name)) {
                    return null;
                }
                if ("synchronized".equals(name)) {
                    Object sa;
                    if (statement instanceof Interpreter.AnnotatedCall && (sa = ((Interpreter.AnnotatedCall)statement).getStatement()) != null) {
                        Object object = sa;
                        synchronized (object) {
                            return statement.call();
                        }
                    }
                    JexlEngine jexl = JexlEngine.getThreadEngine();
                    if (jexl != null) {
                        JexlEngine jexlEngine = jexl;
                        synchronized (jexlEngine) {
                            return statement.call();
                        }
                    }
                }
            }
            return statement.call();
        }
    }

    public static class TestRunner {
        public final Counter syncCounter = new Counter();
        public final Counter concCounter = new Counter();

        public void run(Runnable runnable) throws InterruptedException {
            ExecutorService executor = Executors.newFixedThreadPool(10);
            for (int i = 0; i < 10; ++i) {
                executor.submit(runnable);
            }
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
            if (10000 != this.concCounter.getValue()) {
                Assertions.assertEquals((int)10000, (int)this.syncCounter.getValue());
            }
        }
    }

    public static class Counter {
        private int value;

        public int getValue() {
            return this.value;
        }

        public void inc() {
            int v = this.value;
            for (int i = (int)System.currentTimeMillis() % 5; i >= 0; --i) {
                Thread.yield();
            }
            this.value = v + 1;
        }
    }

    public static class OptAnnotationContext
    extends JexlEvalContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            JexlOptions options = this.getEngineOptions();
            if ("strict".equals(name)) {
                boolean s = (Boolean)args[0];
                boolean b = options.isStrict();
                options.setStrict(s);
                Object r = statement.call();
                options.setStrict(b);
                return r;
            }
            if ("silent".equals(name)) {
                if (args != null && args.length != 0) {
                    boolean s = (Boolean)args[0];
                    boolean b2 = options.isSilent();
                    options.setSilent(s);
                    Assertions.assertEquals((Object)s, (Object)options.isSilent());
                    Object r = statement.call();
                    options.setSilent(b2);
                    return r;
                }
                boolean b = options.isSilent();
                try {
                    Object b2 = statement.call();
                    return b2;
                }
                catch (JexlException xjexl) {
                    Object var7_14 = null;
                    return var7_14;
                }
                finally {
                    options.setSilent(b);
                }
            }
            if ("scale".equals(name)) {
                options.setMathScale(((Integer)args[0]).intValue());
                return statement.call();
            }
            return statement.call();
        }
    }
}

