/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.CaptureLog;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.junit.Asserter;
import org.apache.commons.logging.Log;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ArithmeticOperatorTest
extends JexlTestCase {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private Asserter asserter;

    public ArithmeticOperatorTest() {
        super("ArithmeticOperatorTest");
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.asserter = new Asserter(this.JEXL);
        this.asserter.setStrict(false);
    }

    @Test
    public void test373a() {
        this.testSelfAssignOperators("y.add(x++)", 42, 42, 43);
    }

    @Test
    public void test373b() {
        this.testSelfAssignOperators("y.add(++x)", 42, 43, 43);
    }

    @Test
    public void test373c() {
        this.testSelfAssignOperators("y.add(x--)", 42, 42, 41);
    }

    @Test
    public void test373d() {
        this.testSelfAssignOperators("y.add(--x)", 42, 41, 41);
    }

    @Test
    public void test391() throws Exception {
        for (String src : Arrays.asList("2 =~ [1, 2, 3, 4]", "[2, 3] =~ [1, 2, 3, 4]", "[2, 3,...] =~ [1, 2, 3, 4]", "3 =~ [1, 2, 3, 4,...]", "[2, 3] =~ [1, 2, 3, 4,...]", "[2, 3,...] =~ [1, 2, 3, 4,...]")) {
            this.asserter.assertExpression(src, Boolean.TRUE, new Object[0]);
        }
        int[] ic = new int[]{1, 2, 3, 4};
        ArrayList<Integer> iic = new ArrayList<Integer>();
        for (int v : ic) {
            iic.add(v);
        }
        int[] iv = new int[]{2, 3};
        ArrayList<Integer> iiv = new ArrayList<Integer>();
        for (int v : iv) {
            iiv.add(v);
        }
        String src = "(x,y) -> x =~ y ";
        for (Object v : Arrays.asList(iv, iiv, 2)) {
            for (Object c : Arrays.asList(ic, iic)) {
                this.asserter.assertExpression("(x,y) -> x =~ y ", Boolean.TRUE, v, c);
            }
        }
    }

    @Test
    public void testDateArithmetic() throws Exception {
        Date d = new Date();
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().cache(32).arithmetic((JexlArithmetic)new DateArithmetic(true)).create();
        JexlScript expr0 = jexl.createScript("date.yyyy = 1969; date.MM=7; date.dd=20; ", new String[]{"date"});
        Object value0 = expr0.execute((JexlContext)jc, new Object[]{d});
        Assertions.assertNotNull((Object)value0);
        value0 = d;
        Assertions.assertEquals((Object)1969, (Object)jexl.createScript("date.yyyy", new String[]{"date"}).execute((JexlContext)jc, new Object[]{value0}));
        Assertions.assertEquals((Object)7, (Object)jexl.createScript("date.MM", new String[]{"date"}).execute((JexlContext)jc, new Object[]{value0}));
        Assertions.assertEquals((Object)20, (Object)jexl.createScript("date.dd", new String[]{"date"}).execute((JexlContext)jc, new Object[]{value0}));
    }

    @Test
    public void testFormatArithmetic() throws Exception {
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1969, 7, 20);
        Date x0 = cal.getTime();
        String y0 = "MM/yy/dd";
        Double x1 = 42.12345;
        String y1 = "##0.##";
        DateContext jc = new DateContext();
        JexlEngine jexl = new JexlBuilder().cache(32).arithmetic((JexlArithmetic)new DateArithmetic(true)).create();
        JexlScript expr0 = jexl.createScript("x.format(y)", new String[]{"x", "y"});
        Object value10 = expr0.execute((JexlContext)jc, new Object[]{x0, "MM/yy/dd"});
        Object value20 = expr0.execute((JexlContext)jc, new Object[]{x0, "MM/yy/dd"});
        Assertions.assertEquals((Object)value10, (Object)value20);
        Object value11 = expr0.execute((JexlContext)jc, new Object[]{x1, "##0.##"});
        Object value21 = expr0.execute((JexlContext)jc, new Object[]{x1, "##0.##"});
        Assertions.assertEquals((Object)value11, (Object)value21);
        value10 = expr0.execute((JexlContext)jc, new Object[]{x0, "MM/yy/dd"});
        Assertions.assertEquals((Object)value10, (Object)value20);
        value11 = expr0.execute((JexlContext)jc, new Object[]{x1, "##0.##"});
        Assertions.assertEquals((Object)value11, (Object)value21);
        value10 = expr0.execute((JexlContext)jc, new Object[]{x0, "MM/yy/dd"});
        Assertions.assertEquals((Object)value10, (Object)value20);
        value11 = expr0.execute((JexlContext)jc, new Object[]{x1, "##0.##"});
        Assertions.assertEquals((Object)value11, (Object)value21);
        JexlScript expr1 = jexl.createScript("format(x, y)", new String[]{"x", "y"});
        value10 = expr1.execute((JexlContext)jc, new Object[]{x0, "MM/yy/dd"});
        Assertions.assertEquals((Object)value10, (Object)value20);
        Object s0 = expr1.execute((JexlContext)jc, new Object[]{x0, "EEE dd MMM yyyy"});
        Assertions.assertEquals((Object)"Wed 20 Aug 1969", (Object)s0);
        jc.setLocale(Locale.FRANCE);
        s0 = expr1.execute((JexlContext)jc, new Object[]{x0, "EEE dd MMM yyyy"});
        Assertions.assertEquals((Object)"mer. 20 ao\u00fbt 1969", (Object)s0);
        expr1 = jexl.createScript("format(now(), y)", new String[]{"y"});
        Object n0 = expr1.execute((JexlContext)jc, new Object[]{"MM/yy/dd"});
        Assertions.assertNotNull((Object)n0);
        expr1 = jexl.createScript("now().format(y)", new String[]{"y"});
        Object n1 = expr1.execute((JexlContext)jc, new Object[]{"MM/yy/dd"});
        Assertions.assertNotNull((Object)n0);
        Assertions.assertEquals((Object)n0, (Object)n1);
    }

    @Test
    public void testFormatArithmeticJxlt() throws Exception {
        HashMap<String, Class<Aggregate>> ns = new HashMap<String, Class<Aggregate>>();
        ns.put("calc", Aggregate.class);
        Calendar cal = Calendar.getInstance(UTC);
        cal.set(1969, 7, 20);
        Date x0 = cal.getTime();
        String y0 = "yyyy-MM-dd";
        DateContext jc = new DateContext();
        JexlEngine jexl = new JexlBuilder().cache(32).namespaces(ns).arithmetic((JexlArithmetic)new DateArithmetic(true)).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template expr0 = jxlt.createTemplate("${x.format(y)}", new String[]{"x", "y"});
        StringWriter strw = new StringWriter();
        expr0.evaluate((JexlContext)jc, (Writer)strw, new Object[]{x0, "yyyy-MM-dd"});
        String strws = strw.toString();
        Assertions.assertEquals((Object)"1969-08-20", (Object)strws);
        expr0 = jxlt.createTemplate("${calc:sum(x .. y)}", new String[]{"x", "y"});
        strw = new StringWriter();
        expr0.evaluate((JexlContext)jc, (Writer)strw, new Object[]{1, 3});
        strws = strw.toString();
        Assertions.assertEquals((Object)"6", (Object)strws);
        JxltEngine.Template expr1 = jxlt.createTemplate("${jexl:include(s, x, y)}", new String[]{"s", "x", "y"});
        strw = new StringWriter();
        expr1.evaluate((JexlContext)jc, (Writer)strw, new Object[]{expr0, 1, 3});
        strws = strw.toString();
        Assertions.assertEquals((Object)"6", (Object)strws);
        expr0 = jxlt.createTemplate("${now().format(y)}", new String[]{"y"});
        strw = new StringWriter();
        expr0.evaluate((JexlContext)jc, (Writer)strw, new Object[]{"yyyy-MM-dd"});
        strws = strw.toString();
        Assertions.assertNotNull((Object)strws);
    }

    @Test
    public void testIncrementOperatorOnNull() throws Exception {
        JexlEngine jexl = new JexlBuilder().strict(false).create();
        JexlScript script = jexl.createScript("var i = null; ++i");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)1, (Object)result);
        script = jexl.createScript("var i = null; --i");
        result = script.execute(null);
        Assertions.assertEquals((Object)-1, (Object)result);
    }

    @Test
    public void testInterval() throws Exception {
        HashMap<String, Class<Aggregate>> ns = new HashMap<String, Class<Aggregate>>();
        ns.put("calc", Aggregate.class);
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        JexlScript script = jexl.createScript("1 .. 3");
        Object result = script.execute(null);
        Assertions.assertTrue((boolean)(result instanceof Iterable));
        Iterator ii = ((Iterable)result).iterator();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)ii.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)ii.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)ii.next()));
        script = jexl.createScript("(4 - 3) .. (9 / 3)");
        result = script.execute(null);
        Assertions.assertTrue((boolean)(result instanceof Iterable));
        ii = ((Iterable)result).iterator();
        Assertions.assertEquals((Integer)1, (Integer)((Integer)ii.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)ii.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)ii.next()));
        script = jexl.createScript("var x = 0; for(var y : ((5 - 4) .. (12 / 4))) { x = x + y }; x");
        result = script.execute(null);
        Assertions.assertEquals((Object)6, (Object)result);
        script = jexl.createScript("calc:sum(1 .. 3)");
        result = script.execute(null);
        Assertions.assertEquals((Object)6, (Object)result);
        script = jexl.createScript("calc:sum(-3 .. 3)");
        result = script.execute(null);
        Assertions.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void testMatch() throws Exception {
        Object[] vars;
        int[] ai = new int[]{2, 4, 42, 54};
        ArrayList<Integer> al = new ArrayList<Integer>();
        for (int i : ai) {
            al.add(i);
        }
        HashMap<Integer, String> am = new HashMap<Integer, String>();
        am.put(2, "two");
        am.put(4, "four");
        am.put(42, "forty-two");
        am.put(54, "fifty-four");
        MatchingContainer ad = new MatchingContainer(ai);
        IterableContainer ic = new IterableContainer(ai);
        Set as = ad.values;
        for (Object var : vars = new Object[]{ai, al, am, ad, as, ic}) {
            this.asserter.setVariable("container", var);
            for (int x : ai) {
                this.asserter.setVariable("x", x);
                this.asserter.assertExpression("x =~ container", Boolean.TRUE, new Object[0]);
            }
            this.asserter.setVariable("x", 169);
            this.asserter.assertExpression("x !~ container", Boolean.TRUE, new Object[0]);
        }
    }

    @Test
    public void testNotStartsEndsWith() throws Exception {
        this.asserter.setVariable("x", "foobar");
        this.asserter.assertExpression("x !^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("x", "barfoo");
        this.asserter.assertExpression("x !^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.FALSE, new Object[0]);
        int[] ai = new int[]{2, 4, 42, 54};
        IterableContainer ic = new IterableContainer(ai);
        this.asserter.setVariable("x", ic);
        this.asserter.assertExpression("x !^ 2", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !$ 54", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !^ 4", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x !$ 42", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x !^ [2, 4]", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !^ [42, 54]", Boolean.FALSE, new Object[0]);
    }

    @Test
    public void testNotStartsEndsWithString() throws Exception {
        this.asserter.setVariable("x", "foobar");
        this.asserter.assertExpression("x !^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("x", "barfoo");
        this.asserter.assertExpression("x !^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.FALSE, new Object[0]);
    }

    @Test
    public void testNotStartsEndsWithStringBuilder() throws Exception {
        this.asserter.setVariable("x", new StringBuilder("foobar"));
        this.asserter.assertExpression("x !^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("x", new StringBuilder("barfoo"));
        this.asserter.assertExpression("x !^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x !$ 'foo'", Boolean.FALSE, new Object[0]);
    }

    @Test
    public void testNotStartsEndsWithStringDot() throws Exception {
        this.asserter.setVariable("x.y", "foobar");
        this.asserter.assertExpression("x.y !^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x.y !$ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("x.y", "barfoo");
        this.asserter.assertExpression("x.y !^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x.y !$ 'foo'", Boolean.FALSE, new Object[0]);
    }

    @Test
    public void testOperatorError() throws Exception {
        this.testOperatorError(true);
        this.testOperatorError(false);
    }

    private void testOperatorError(boolean silent) throws Exception {
        CaptureLog log = new CaptureLog();
        DateContext jc = new DateContext();
        Date d = new Date();
        JexlEngine jexl = new JexlBuilder().logger((Log)log).strict(true).silent(silent).cache(32).arithmetic((JexlArithmetic)new DateArithmetic(true)).create();
        JexlScript expr0 = jexl.createScript("date * date", new String[]{"date"});
        try {
            Object value0 = expr0.execute((JexlContext)jc, new Object[]{d});
            if (!silent) {
                Assertions.fail((String)"should have failed");
            } else {
                Assertions.assertEquals((int)1, (int)log.count("warn"));
            }
        }
        catch (JexlException.Operator xop) {
            Assertions.assertEquals((Object)"*", (Object)xop.getSymbol());
        }
        if (!silent) {
            Assertions.assertEquals((int)0, (int)log.count("warn"));
        }
    }

    @Test
    public void testRegexp() throws Exception {
        this.asserter.setVariable("str", "abc456");
        this.asserter.assertExpression("str =~ '.*456'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str !~ 'ABC.*'", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("match", "abc.*");
        this.asserter.setVariable("nomatch", ".*123");
        this.asserter.assertExpression("str =~ match", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str !~ match", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("str !~ nomatch", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str =~ nomatch", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("match", new StringBuilder("abc.*"));
        this.asserter.setVariable("nomatch", new StringBuilder(".*123"));
        this.asserter.assertExpression("str =~ match", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str !~ match", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("str !~ nomatch", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str =~ nomatch", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("match", Pattern.compile("abc.*"));
        this.asserter.setVariable("nomatch", Pattern.compile(".*123"));
        this.asserter.assertExpression("str =~ match", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str !~ match", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("str !~ nomatch", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str =~ nomatch", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("'a' =~ ['a','b','c','d','e','f']", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("'a' !~ ['a','b','c','d','e','f']", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("'z' =~ ['a','b','c','d','e','f']", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("'z' !~ ['a','b','c','d','e','f']", Boolean.TRUE, new Object[0]);
    }

    @Test
    public void testRegexp2() throws Exception {
        this.asserter.setVariable("str", "abc456");
        this.asserter.assertExpression("str =~ ~/.*456/", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str !~ ~/ABC.*/", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("str =~ ~/abc\\d{3}/", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("matches(str, ~/.*456/)", Boolean.TRUE, new Object[0]);
        this.asserter.setVariable("str", "4/6");
        this.asserter.assertExpression("str =~ ~/\\d\\/\\d/", Boolean.TRUE, new Object[0]);
    }

    void testSelfAssignOperators(String text, int x, int y0, int x0) {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(text);
        MapContext context = new MapContext();
        context.set("x", (Object)x);
        ArrayList y = new ArrayList();
        context.set("y", y);
        Object result = script.execute((JexlContext)context);
        Assertions.assertEquals((Object)x0, (Object)context.get("x"), (String)"x0");
        Assertions.assertEquals((Object)y0, y.get(0), (String)"y0");
    }

    @Test
    public void testStartsEndsWith() throws Exception {
        this.asserter.setVariable("x", "foobar");
        this.asserter.assertExpression("x =^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("x", "barfoo");
        this.asserter.assertExpression("x =^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.TRUE, new Object[0]);
        int[] ai = new int[]{2, 4, 42, 54};
        IterableContainer ic = new IterableContainer(ai);
        this.asserter.setVariable("x", ic);
        this.asserter.assertExpression("x =^ 2", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =$ 54", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =^ 4", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x =$ 42", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x =^ [2, 4]", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =^ [42, 54]", Boolean.TRUE, new Object[0]);
    }

    @Test
    public void testStartsEndsWithString() throws Exception {
        this.asserter.setVariable("x", "foobar");
        this.asserter.assertExpression("x =^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("x", "barfoo");
        this.asserter.assertExpression("x =^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.TRUE, new Object[0]);
    }

    @Test
    public void testStartsEndsWithStringBuilder() throws Exception {
        this.asserter.setVariable("x", new StringBuilder("foobar"));
        this.asserter.assertExpression("x =^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("x", new StringBuilder("barfoo"));
        this.asserter.assertExpression("x =^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x =$ 'foo'", Boolean.TRUE, new Object[0]);
    }

    @Test
    public void testStartsEndsWithStringDot() throws Exception {
        this.asserter.setVariable("x.y", "foobar");
        this.asserter.assertExpression("x.y =^ 'foo'", Boolean.TRUE, new Object[0]);
        this.asserter.assertExpression("x.y =$ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.setVariable("x.y", "barfoo");
        this.asserter.assertExpression("x.y =^ 'foo'", Boolean.FALSE, new Object[0]);
        this.asserter.assertExpression("x.y =$ 'foo'", Boolean.TRUE, new Object[0]);
    }

    public static class DateArithmetic
    extends JexlArithmetic {
        DateArithmetic(boolean flag) {
            super(flag);
        }

        public Object arrayGet(Date date, String identifier) {
            return this.getDateValue(date, identifier);
        }

        public Object arraySet(Date date, String identifier, Object value) throws Exception {
            return this.setDateValue(date, identifier, value);
        }

        protected Object getDateValue(Date date, String key) {
            try {
                Calendar cal = Calendar.getInstance(UTC);
                cal.setTime(date);
                if ("yyyy".equals(key)) {
                    return cal.get(1);
                }
                if ("MM".equals(key)) {
                    return cal.get(2) + 1;
                }
                if ("dd".equals(key)) {
                    return cal.get(5);
                }
                SimpleDateFormat df = new SimpleDateFormat(key);
                return df.format(date);
            }
            catch (Exception ex) {
                return null;
            }
        }

        public Date multiply(Date d0, Date d1) {
            throw new ArithmeticException("unsupported");
        }

        public Date now() {
            return new Date(System.currentTimeMillis());
        }

        public Object propertyGet(Date date, String identifier) {
            return this.getDateValue(date, identifier);
        }

        public Object propertySet(Date date, String identifier, Object value) throws Exception {
            return this.setDateValue(date, identifier, value);
        }

        protected Object setDateValue(Date date, String key, Object value) throws Exception {
            Calendar cal = Calendar.getInstance(UTC);
            cal.setTime(date);
            if ("yyyy".equals(key)) {
                cal.set(1, this.toInteger(value));
            } else if ("MM".equals(key)) {
                cal.set(2, this.toInteger(value) - 1);
            } else if ("dd".equals(key)) {
                cal.set(5, this.toInteger(value));
            }
            date.setTime(cal.getTimeInMillis());
            return date;
        }
    }

    public static class DateContext
    extends MapContext {
        private Locale locale = Locale.US;

        public String format(Date date, String fmt) {
            SimpleDateFormat sdf = new SimpleDateFormat(fmt, this.locale);
            sdf.setTimeZone(UTC);
            return sdf.format(date);
        }

        public String format(Number number, String fmt) {
            return new DecimalFormat(fmt).format(number);
        }

        void setLocale(Locale l10n) {
            this.locale = l10n;
        }
    }

    public static class Aggregate {
        public static int sum(Iterable<Integer> ii) {
            int sum = 0;
            for (Integer i : ii) {
                sum += i.intValue();
            }
            return sum;
        }

        private Aggregate() {
        }
    }

    public static class MatchingContainer {
        private final Set<Integer> values = new HashSet<Integer>();

        public MatchingContainer(int[] is) {
            for (int value : is) {
                this.values.add(value);
            }
        }

        public boolean contains(int value) {
            return this.values.contains(value);
        }
    }

    public static class IterableContainer
    implements Iterable<Integer> {
        private final SortedSet<Integer> values = new TreeSet<Integer>();

        public IterableContainer(int[] is) {
            for (int value : is) {
                this.values.add(value);
            }
        }

        public boolean contains(int i) {
            return this.values.contains(i);
        }

        public boolean contains(int[] i) {
            for (int ii : i) {
                if (this.values.contains(ii)) continue;
                return false;
            }
            return true;
        }

        public boolean endsWith(int i) {
            return this.values.last().equals(i);
        }

        public boolean endsWith(int[] i) {
            SortedSet<Integer> sw = this.values.tailSet(this.values.size() - i.length);
            int n = 0;
            for (Integer value : sw) {
                if (value.equals(i[n++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<Integer> iterator() {
            return this.values.iterator();
        }

        public boolean startsWith(int i) {
            return this.values.first().equals(i);
        }

        public boolean startsWith(int[] i) {
            SortedSet<Integer> sw = this.values.headSet(i.length);
            int n = 0;
            for (Integer value : sw) {
                if (value.equals(i[n++])) continue;
                return false;
            }
            return true;
        }
    }
}

