/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Issues400Test {
    private static void run404(JexlEngine jexl, String src, Object ... a) {
        JexlScript script = jexl.createScript(src, new String[]{"a", "b"});
        if (!src.endsWith(";")) {
            Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        }
        Object result = script.execute(null, a);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test402() {
        MapContext jc = new MapContext();
        String[] sources = new String[]{"if (true) { return }", "if (true) { 3; return }", "(x->{ 3; return })()"};
        JexlEngine jexl = new JexlBuilder().create();
        for (String source : sources) {
            JexlScript e = jexl.createScript(source);
            Object o = e.execute((JexlContext)jc);
            Assertions.assertNull((Object)o);
        }
    }

    @Test
    public void test403() {
        String[] strings;
        for (String setmap : strings = new String[]{"  map1.`${item.a}` = 1;\n", "  map1[`${item.a}`] = 1;\n", "  map1[item.a] = 1;\n"}) {
            String src = "var a = {'a': 1};\nvar list = [a, a];\nlet map1 = {:};\nfor (var item : list) {\n" + setmap + "}\n map1";
            JexlEngine jexl = new JexlBuilder().cache(64).create();
            JexlScript script = jexl.createScript(src);
            for (int i = 0; i < 2; ++i) {
                Object result = script.execute(null);
                Assertions.assertTrue((boolean)(result instanceof Map));
                Map map = (Map)result;
                Assertions.assertEquals((int)1, (int)map.size());
                Assertions.assertTrue((boolean)map.containsKey(1));
                Assertions.assertTrue((boolean)map.containsValue(1));
            }
        }
    }

    @Test
    public void test404a() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        Map<String, Object> a = Collections.singletonMap("b", 42);
        for (String src : new String[]{"a.b", "a?.b", "a['b']", "a?['b']", "a?.`b`"}) {
            Issues400Test.run404(jexl, src, a);
            Issues400Test.run404(jexl, src + ";", a);
        }
        for (String src : new String[]{"a[b]", "a?[b]", "a?.`${b}`"}) {
            Issues400Test.run404(jexl, src, a, "b");
            Issues400Test.run404(jexl, src + ";", a, "b");
        }
        Map<String, Integer> b = Collections.singletonMap("c", 42);
        a = Collections.singletonMap("b", b);
        for (String src : new String[]{"a[b].c", "a?[b]?['c']", "a?.`${b}`.c"}) {
            Issues400Test.run404(jexl, src, a, "b");
        }
    }

    @Test
    public void test404b() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        Map<String, Integer> b = Collections.singletonMap("c", 42);
        Map<String, Map<String, Integer>> a = Collections.singletonMap("b", b);
        Object result = -42;
        JexlScript script = jexl.createScript("a?['B']?['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        Assertions.assertNull((Object)result);
        script = jexl.createScript("a?['b']?['C']", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertNull((Object)result);
        script = jexl.createScript("a?['b']?['c']", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("a?['B']?['C']?: 1042", new String[]{"a"});
        Assertions.assertEquals((Object)script.getSourceText(), (Object)script.getParsedText());
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals((Object)1042, (Object)result);
        script = jexl.createScript("a? ['B']:['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertArrayEquals((Object[])new String[]{"B"}, (Object[])((String[])result));
        script = jexl.createScript("a?['b'] ?: ['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertEquals(b, (Object)result);
        script = jexl.createScript("a?['B'] ?: ['C']", new String[]{"a"});
        result = script.execute(null, new Object[]{a});
        Assertions.assertArrayEquals((Object[])new String[]{"C"}, (Object[])((String[])result));
    }

    @Test
    public void test406a() {
        JexlEngine jexl = new JexlBuilder().cache(64).strict(true).safe(false).create();
        XuContext context = new XuContext();
        List<String> list = Arrays.asList("[1, 2, 3, 4, ...].join('-')", "[1, 2, 3, 4,].join('-')", "(1 .. 4).join('-')", "join([1, 2, 3, 4, ...], '-')", "join([1, 2, 3, 4], '-')", "join((1 .. 4), '-')");
        for (String src : list) {
            JexlScript script = jexl.createScript(src);
            Object result = script.execute((JexlContext)context);
            Assertions.assertEquals((Object)"1-2-3-4", (Object)result, (String)src);
        }
        String src0 = "x.join('*')";
        JexlScript script0 = jexl.createScript("x.join('*')", new String[]{"x"});
        String src1 = "join(x, '*')";
        JexlScript script1 = jexl.createScript("join(x, '*')", new String[]{"x"});
        for (Object x : Arrays.asList(Arrays.asList(1, 2, 3, 4), new int[]{1, 2, 3, 4})) {
            Object result = script0.execute((JexlContext)context, new Object[]{x});
            Assertions.assertEquals((Object)"1*2*3*4", (Object)result, (String)"x.join('*')");
            result = script1.execute((JexlContext)context, new Object[]{x});
            Assertions.assertEquals((Object)"1*2*3*4", (Object)result, (String)"join(x, '*')");
        }
    }

    @Test
    public void test407() {
        double r = -7.105427357601002E-15;
        Assertions.assertEquals((double)0.0, (double)-7.105427357601002E-15, (double)8.0E-15);
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("a + b - a - b", new String[]{"a", "b"});
        Number result = (Number)script.execute(null, new Object[]{99.0, 7.82});
        Assertions.assertEquals((double)0.0, (double)result.doubleValue(), (double)8.0E-15);
        result = (Number)script.execute(null, new Object[]{new BigDecimal(99.0), new BigDecimal(7.82)});
        Assertions.assertEquals((double)0.0, (double)result.doubleValue(), (double)3.0E-32);
    }

    @Test
    public void test412() {
        HashMap<String, Integer> ctl = new HashMap<String, Integer>();
        ctl.put("one", 1);
        ctl.put("two", 2);
        String fnsrc0 = "function f(x) { x }\nlet one = 'one', two = 'two';\n";
        List<String> list = Arrays.asList("{ one : f(1), two:f(2) }", "{ one: f(1), two: f(2) }", "{ one: f(1), two:f(2) }", "{ one :f(1), two:f(2) }");
        for (String map0 : list) {
            String fnsrc = "function f(x) { x }\nlet one = 'one', two = 'two';\n" + map0;
            MapContext jc = new MapContext();
            JexlEngine jexl = new JexlBuilder().create();
            JexlScript e = jexl.createScript(fnsrc);
            Object o = e.execute((JexlContext)jc);
            Assertions.assertTrue((boolean)(o instanceof Map));
            Map map = (Map)o;
            Assertions.assertEquals((Object)map, ctl);
        }
    }

    @Test
    public void test413a() {
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        Number result = (Number)script.execute(null, new Object[]{12});
        Assertions.assertEquals((Object)54, (Object)result);
    }

    @Test
    public void test413b() {
        JexlBuilder builder = new JexlBuilder();
        JexlOptions options = builder.options();
        options.setConstCapture(true);
        options.setLexical(true);
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> script.execute(null, new Object[]{12}), (String)"c should be const");
        Assertions.assertEquals((Object)"c", (Object)xvar.getVariable());
    }

    @Test
    public void test413c() {
        JexlBuilder builder = new JexlBuilder();
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("#pragma jexl.options '+constCapture'\nvar c = 42; var f = y -> c += y; f(z)", new String[]{"z"});
        JexlException.Variable xvar = (JexlException.Variable)Assertions.assertThrows(JexlException.Variable.class, () -> script.execute(null, new Object[]{12}), (String)"c should be const");
        Assertions.assertEquals((Object)"c", (Object)xvar.getVariable());
    }

    @Test
    public void test413d() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("var c = 42; var f = y -> c += y; f(z)", new String[]{"z"}), (String)"c should be const");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("const"));
    }

    @Test
    public void test415() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        JexlScript script = jexl.createScript("`#${c}`", new String[]{"c"});
        Object result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"#42", (Object)result.toString());
        script = jexl.createScript("`$${c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"$42", (Object)result.toString());
        script = jexl.createScript("`$#{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"$42", (Object)result.toString());
        script = jexl.createScript("`##{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"#42", (Object)result.toString());
        script = jexl.createScript("`--##{c}`", new String[]{"c"});
        result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)"--#42", (Object)result.toString());
    }

    @Test
    public void test419() throws NoSuchMethodException {
        Method currentTimeMillis = System.class.getMethod("currentTimeMillis", new Class[0]);
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(currentTimeMillis));
        JexlPermissions permissions = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +System { currentTimeMillis(); } }"});
        Assertions.assertTrue((boolean)permissions.allow(currentTimeMillis));
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(currentTimeMillis));
        JexlEngine jexl = new JexlBuilder().namespaces(Collections.singletonMap("sns", System.class)).permissions(permissions).create();
        AtomicLong result = new AtomicLong();
        Assertions.assertEquals((long)0L, (long)result.get());
        long now = System.currentTimeMillis();
        jexl.createScript("result.set(sns:currentTimeMillis())", new String[]{"result"}).execute(null, new Object[]{result});
        Assertions.assertTrue((result.get() >= now ? 1 : 0) != 0);
        JexlScript script = jexl.createScript("sns:gc()");
        JexlException.Method method = (JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script.execute(null));
        Assertions.assertEquals((Object)"gc", (Object)method.getMethod());
    }

    @Test
    public void testDocBreakContinue() {
        JexlBuilder builder = new JexlBuilder().features(new JexlFeatures().constCapture(true));
        JexlEngine jexl = builder.create();
        String srcContinue = "let text = '';\nfor (let i : (4..2)) { if (i == 3) continue; text += i; }\ntext;";
        JexlScript script = jexl.createScript("let text = '';\nfor (let i : (4..2)) { if (i == 3) continue; text += i; }\ntext;");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)"42", (Object)result);
        String srcBreak = "let i = 33;\nwhile (i < 66) { if (i == 42) { break; } i += 1; }\ni;";
        script = jexl.createScript("let i = 33;\nwhile (i < 66) { if (i == 42) { break; } i += 1; }\ni;");
        result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamespaceVsTernary0() {
        VinzContext ctxt = new VinzContext();
        ctxt.set("Users", "USERS");
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).silent(false).create();
        JexlScript script = jexl.createScript("() -> {\n  var fn = (user) -> {\n     user ? user : member(Users, 'user');\n  }\n}");
        Object r = script.execute((JexlContext)ctxt);
        Assertions.assertNotNull((Object)r);
        script = (JexlScript)r;
        r = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)"USERS.user", (Object)r);
    }

    @Test
    public void testNamespaceVsTernary1() {
        VinzContext ctxt = new VinzContext();
        ctxt.set("Users", "USERS");
        ctxt.set("vinz", new VinzCaller((JexlContext)ctxt));
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).silent(false).create();
        JexlScript script = jexl.createScript("vinz.execute(() -> {\n  var test = 42;\n  var user = useTest ? test : member(Users, 'user');\n})\n", new String[]{"useTest"});
        Object r = script.execute((JexlContext)ctxt, new Object[]{false});
        Assertions.assertNotNull((Object)r);
        Assertions.assertEquals((Object)"USERS.user", (Object)r);
        r = script.execute((JexlContext)ctxt, new Object[]{true});
        Assertions.assertNotNull((Object)r);
        Assertions.assertEquals((Object)42, (Object)r);
    }

    public static class XuContext
    extends MapContext {
        public String join(int[] list, String str) {
            return this.join(Arrays.stream(list).iterator(), str);
        }

        public String join(Iterable<?> list, String str) {
            return this.join(list.iterator(), str);
        }

        public String join(Iterator<?> iterator, String str) {
            if (!iterator.hasNext()) {
                return "";
            }
            StringBuilder strb = new StringBuilder(256);
            strb.append(iterator.next().toString());
            while (iterator.hasNext()) {
                strb.append(str);
                strb.append(Objects.toString(iterator.next(), "?"));
            }
            return strb.toString();
        }
    }

    public static class VinzContext
    extends MapContext {
        public String member(String m, String u) {
            return m + '.' + u;
        }
    }

    public static class VinzCaller {
        private final JexlContext context;

        VinzCaller(JexlContext context) {
            this.context = context;
        }

        public Object execute(JexlScript script) {
            return script.execute(this.context);
        }
    }
}

