/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Closure;
import org.apache.commons.jexl3.internal.Script;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LambdaTest
extends JexlTestCase {
    public LambdaTest() {
        super("LambdaTest");
    }

    @Test
    public void test270() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String text = base.toString();
        JexlScript script = base.curry(new Object[]{5, 15});
        Assertions.assertEquals((Object)text, (Object)script.toString());
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", base);
        script = jexl.createScript("return s");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)text, (Object)result.toString());
        script = jexl.createScript("return s.curry(1)");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)text, (Object)result.toString());
    }

    @Test
    public void test271a() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 1; var x = (a)->{ var y = (b) -> {base + b}; return base + y(a)}; x(40)");
        Object result = base.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test271b() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; var sum = (x, y, z)->{ base + x + y + z }; var y = sum.curry(1); y(2,3)");
        Object result = base.execute(null);
        Assertions.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271c() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ 2 + x + y + z };");
        JexlScript y = base.curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assertions.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271d() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 2; (x, y, z)->base + x + y + z;");
        JexlScript y = ((JexlScript)base.execute(null)).curry(new Object[]{1});
        Object result = y.execute(null, new Object[]{2, 3});
        Assertions.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test271e() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var base = 1000; var f = (x, y)->{ var base = x + y + (base?:-1000); base; }; f(100, 20)");
        Object result = base.execute(null);
        Assertions.assertEquals((Object)1120, (Object)result);
    }

    @Test
    public void test405a() {
        JexlEngine jexl = new JexlBuilder().cache(4).strict(true).safe(false).create();
        String libSrc = "var theFunction = argFn -> { var fn = argFn; fn() }; { 'theFunction' : theFunction }";
        String src1 = "var v0 = 42; var v1 = -42; lib.theFunction(()->{ v1 + v0 }) ";
        JexlScript libMap = jexl.createScript("var theFunction = argFn -> { var fn = argFn; fn() }; { 'theFunction' : theFunction }");
        Object theLib = libMap.execute(null);
        JexlScript f1 = jexl.createScript("var v0 = 42; var v1 = -42; lib.theFunction(()->{ v1 + v0 }) ", new String[]{"lib"});
        Object result = f1.execute(null, new Object[]{theLib});
        Assertions.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void test405b() {
        JexlEngine jexl = new JexlBuilder().cache(4).strict(true).safe(false).create();
        String libSrc = "function theFunction(argFn) { var fn = argFn; fn() }; { 'theFunction' : theFunction }";
        String src1 = "var v0 = 42; var v1 = -42; lib.theFunction(()->{ v1 + v0 }) ";
        JexlScript libMap = jexl.createScript("function theFunction(argFn) { var fn = argFn; fn() }; { 'theFunction' : theFunction }");
        Object theLib = libMap.execute(null);
        JexlScript f1 = jexl.createScript("var v0 = 42; var v1 = -42; lib.theFunction(()->{ v1 + v0 }) ", new String[]{"lib"});
        Object result = f1.execute(null, new Object[]{theLib});
        Assertions.assertEquals((Object)0, (Object)result);
    }

    @Test
    public void testCompareLambdaRecurse() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String factSrc = "function fact(x) { x < 2? 1 : x * fact(x - 1) }";
        JexlScript fact0 = jexl.createScript("function fact(x) { x < 2? 1 : x * fact(x - 1) }");
        JexlScript fact1 = jexl.createScript(fact0.toString());
        Assertions.assertEquals((Object)fact0, (Object)fact1);
        Closure r0 = (Closure)fact0.execute(null);
        Closure r1 = (Closure)fact1.execute(null);
        Assertions.assertEquals((Object)720, (Object)r0.execute(null, new Object[]{6}));
        Assertions.assertEquals((Object)720, (Object)r1.execute(null, new Object[]{6}));
        Assertions.assertEquals((Object)r0, (Object)r1);
        Assertions.assertEquals((Object)r1, (Object)r0);
        Assertions.assertEquals((Object)720, (Object)r0.execute(null, new Object[]{6}));
        Assertions.assertEquals((Object)720, (Object)r1.execute(null, new Object[]{6}));
    }

    @Test
    public void testCurry1() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        String[] parms = base.getUnboundParameters();
        Assertions.assertEquals((int)3, (int)parms.length);
        JexlScript script = base.curry(new Object[]{5});
        parms = script.getUnboundParameters();
        Assertions.assertEquals((int)2, (int)parms.length);
        script = script.curry(new Object[]{15});
        parms = script.getUnboundParameters();
        Assertions.assertEquals((int)1, (int)parms.length);
        script = script.curry(new Object[]{22});
        parms = script.getUnboundParameters();
        Assertions.assertEquals((int)0, (int)parms.length);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry2() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        String[] parms = script.getUnboundParameters();
        Assertions.assertEquals((int)1, (int)parms.length);
        script = script.curry(new Object[]{22});
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry3() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5, 15});
        Object result = script.execute(null, new Object[]{22});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry4() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("(x, y, z)->{ x + y + z }");
        JexlScript script = base.curry(new Object[]{5});
        Object result = script.execute(null, new Object[]{15, 22});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCurry5() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript base = jexl.createScript("var t = x + y + z; return t", new String[]{"x", "y", "z"});
        JexlScript script = base.curry(new Object[]{5});
        Object result = script.execute(null, new Object[]{15, 22});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testFailParseFunc0() {
        String src = "if (false) function foo(x) { x + x }; var foo = 1";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("if (false) function foo(x) { x + x }; var foo = 1"));
        Assertions.assertTrue((boolean)xparse.getMessage().contains("function"));
    }

    @Test
    public void testFailParseFunc1() {
        String src = "if (false) let foo = (x) { x + x }; var foo = 1";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("if (false) let foo = (x) { x + x }; var foo = 1"));
        Assertions.assertTrue((boolean)xparse.getMessage().contains("let"));
    }

    @Test
    public void testFatFact0() {
        JexlFeatures features = new JexlFeatures();
        features.fatArrow(true);
        String src = "function (a) { const fact = x =>{ x <= 1? 1 : x * fact(x - 1) }; fact(a) }";
        JexlEngine jexl = LambdaTest.createEngine(features);
        JexlScript script = jexl.createScript("function (a) { const fact = x =>{ x <= 1? 1 : x * fact(x - 1) }; fact(a) }");
        Object result = script.execute(null, new Object[]{6});
        Assertions.assertEquals((Object)720, (Object)result);
    }

    @Test
    public void testFatFact1() {
        String src = "function (a) { const fact = (x)=> x <= 1? 1 : x * fact(x - 1) ; fact(a) }";
        JexlFeatures features = new JexlFeatures();
        features.fatArrow(true);
        JexlEngine jexl = LambdaTest.createEngine(features);
        JexlScript script = jexl.createScript("function (a) { const fact = (x)=> x <= 1? 1 : x * fact(x - 1) ; fact(a) }");
        Object result = script.execute(null, new Object[]{6});
        Assertions.assertEquals((Object)720, (Object)result);
        features.fatArrow(false);
        JexlEngine jexl1 = LambdaTest.createEngine(features);
        JexlException.Feature xfeature = (JexlException.Feature)Assertions.assertThrows(JexlException.Feature.class, () -> jexl1.createScript("function (a) { const fact = (x)=> x <= 1? 1 : x * fact(x - 1) ; fact(a) }"));
        Assertions.assertTrue((boolean)xfeature.getMessage().contains("fat-arrow"));
    }

    @Test
    public void testHoistLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlEvalContext ctx = new JexlEvalContext();
        ctx.getEngineOptions().setLexical(false);
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assertions.assertTrue((boolean)(result instanceof JexlScript));
        JexlScript s15 = (JexlScript)result;
        String[] localv = s15.getLocalVariables();
        Assertions.assertEquals((int)0, (int)localv.length);
        Set hvars = s15.getVariables();
        Assertions.assertEquals((int)1, (int)hvars.size());
        strs = "(x)->{ (y)->{ var z = 169; var x; x + y } }";
        s42 = jexl.createScript(strs);
        result = s42.execute((JexlContext)ctx, new Object[]{15});
        Assertions.assertTrue((boolean)(result instanceof JexlScript));
        s15 = (JexlScript)result;
        localv = s15.getLocalVariables();
        Assertions.assertNotNull((Object)localv);
        Assertions.assertEquals((int)1, (int)localv.length);
        hvars = s15.getVariables();
        Assertions.assertEquals((int)1, (int)hvars.size());
        result = s15.execute((JexlContext)ctx, new Object[]{27});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testIdentity() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(x)->{ x }");
        Assertions.assertArrayEquals((Object[])new String[]{"x"}, (Object[])script.getParameters());
        Object result = script.execute(null, new Object[]{42});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var s = function(x) { x + x }; s(21)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "var s = function(x, y) { x + y }; s(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaClosure() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 20; var s = function(x, y) { x + y + t}; s(15, 7)";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "var t = 20; var s = function(x, y) {x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = function(x, y) { var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr0() {
        String src = "(x, y) -> x + y";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(x, y) -> x + y");
        Object result = script.execute(null, new Object[]{11, 31});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr1() {
        String src = "x -> x + x";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("x -> x + x");
        Object result = script.execute(null, new Object[]{21});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr10() {
        String src = "(a)->{ var x = x -> x + x; x(a) }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(a)->{ var x = x -> x + x; x(a) }");
        Object result = script.execute(null, new Object[]{21});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLambdaExpr2() {
        String src = "x -> { { x + x } }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("x -> { { x + x } }");
        Object result = script.execute(null, new Object[]{21});
        Assertions.assertTrue((boolean)(result instanceof Set));
        Set set = (Set)result;
        Assertions.assertEquals((int)1, (int)set.size());
        Assertions.assertTrue((boolean)set.contains(42));
    }

    @Test
    public void testLambdaExpr3() {
        String src = "x -> ( { x + x } )";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("x -> ( { x + x } )");
        Object result = script.execute(null, new Object[]{21});
        Assertions.assertTrue((boolean)(result instanceof Set));
        Set set = (Set)result;
        Assertions.assertEquals((int)1, (int)set.size());
        Assertions.assertTrue((boolean)set.contains(42));
    }

    @Test
    public void testLambdaLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "var t = 19; ( (x, y)->{ var t = 20; x + y + t} )(15, 7);";
        JexlScript s42 = jexl.createScript(strs);
        Object result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "( (x, y)->{ ( (xx, yy)->{xx + yy } )(x, y) } )(15, 27)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        strs = "var t = 19; var s = (x, y)->{ var t = 20; x + y + t}; t = 54; s(15, 7)";
        s42 = jexl.createScript(strs);
        result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamedFunc() {
        String src = "(let a)->{ function fact(const x) { x <= 1? 1 : x * fact(x - 1); } fact(a); }";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript script = jexl.createScript("(let a)->{ function fact(const x) { x <= 1? 1 : x * fact(x - 1); } fact(a); }");
        Object result = script.execute(null, new Object[]{6});
        Assertions.assertEquals((Object)720, (Object)result);
        String parsed = this.simpleWhitespace(script.getParsedText());
        Assertions.assertEquals((Object)this.simpleWhitespace("(let a)->{ function fact(const x) { x <= 1? 1 : x * fact(x - 1); } fact(a); }"), (Object)parsed);
    }

    @Test
    public void testNamedFuncIsConst() {
        String src = "function foo(x) { x + x }; var foo ='nonononon'";
        JexlEngine jexl = LambdaTest.createEngine();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("function foo(x) { x + x }; var foo ='nonononon'"));
        Assertions.assertTrue((boolean)xparse.getMessage().contains("foo"));
    }

    @Test
    public void testNestLambada() throws Exception {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "(x)->{ (y)->{ x + y } }";
        JexlScript s42 = jexl.createScript("(x)->{ (y)->{ x + y } }");
        JexlScript s42b = jexl.createScript(s42.toString());
        Assertions.assertEquals((int)s42.hashCode(), (int)s42b.hashCode());
        Assertions.assertEquals((Object)s42, (Object)s42b);
        Object result = s42.execute(null, new Object[]{15});
        Assertions.assertTrue((boolean)(result instanceof JexlScript));
        Object resultb = s42.execute(null, new Object[]{15});
        Assertions.assertEquals((int)result.hashCode(), (int)resultb.hashCode());
        Assertions.assertEquals((Object)result, (Object)resultb);
        Assertions.assertEquals((Object)result, (Object)jexl.createScript(resultb.toString(), new String[]{"x"}).execute(null, new Object[]{15}));
        JexlScript s15 = (JexlScript)result;
        Callable s15b = s15.callable(null, new Object[]{27});
        result = s15.execute(null, new Object[]{27});
        Assertions.assertEquals((Object)42, (Object)result);
        result = s15b.call();
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNestLambda() {
        JexlEngine jexl = LambdaTest.createEngine();
        String strs = "( (x)->{ (y)->{ x + y } })(15)(27)";
        JexlScript s42 = jexl.createScript("( (x)->{ (y)->{ x + y } })(15)(27)");
        Object result = s42.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testRecurse() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var fact = (x)->{ if (x <= 1) 1; else x * fact(x - 1) }; fact(5)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assertions.assertEquals((int)120, (int)result);
    }

    @Test
    public void testRecurse1() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        String src = "var fact = (x)-> x <= 1? 1 : x * fact(x - 1);\nfact(5);\n";
        JexlScript script = jexl.createScript("var fact = (x)-> x <= 1? 1 : x * fact(x - 1);\nfact(5);\n");
        int result = (Integer)script.execute((JexlContext)jc);
        Assertions.assertEquals((int)120, (int)result);
        String parsed = script.getParsedText();
        Assertions.assertEquals((Object)"var fact = (x)-> x <= 1? 1 : x * fact(x - 1);\nfact(5);\n", (Object)parsed);
    }

    @Test
    public void testRecurse2() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var y = 1; var z = 1; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assertions.assertEquals((int)720, (int)result);
    }

    @Test
    public void testRecurse2b() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript fact = jexl.createScript("var y = 1; var z = 1; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) };fact");
        Script func = (Script)fact.execute((JexlContext)jc);
        String[] captured = func.getCapturedVariables();
        Assertions.assertEquals((int)3, (int)captured.length);
        Assertions.assertTrue((boolean)Arrays.asList(captured).containsAll(Arrays.asList("z", "y", "fact")));
        int result = (Integer)func.execute((JexlContext)jc, new Object[]{6});
        Assertions.assertEquals((int)720, (int)result);
    }

    @Test
    public void testRecurse3() {
        JexlEngine jexl = LambdaTest.createEngine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var y = 1; var z = 1;var foo = (x)->{y + z}; var fact = (x)->{ if (x <= y) z; else x * fact(x - 1) }; fact(6)");
        int result = (Integer)script.execute((JexlContext)jc);
        Assertions.assertEquals((int)720, (int)result);
    }

    @Test
    public void testScriptArguments() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript(" x + x ", new String[]{"x"});
        JexlScript s42 = jexl.createScript("s(21)", new String[]{"s"});
        Object result = s42.execute(null, new Object[]{s});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testScriptContext() {
        JexlEngine jexl = LambdaTest.createEngine();
        JexlScript s = jexl.createScript("function(x) { x + x }");
        String fsstr = s.getParsedText(0);
        Assertions.assertEquals((Object)"(x)->{ x + x; }", (Object)fsstr);
        Assertions.assertEquals((Object)42, (Object)s.execute(null, new Object[]{21}));
        JexlScript s42 = jexl.createScript("s(21)");
        JexlEvalContext ctxt = new JexlEvalContext();
        ctxt.set("s", s);
        Object result = s42.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
        result = s42.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
        s42 = jexl.createScript("x-> { x + x }");
        result = s42.execute((JexlContext)ctxt, new Object[]{21});
        Assertions.assertEquals((Object)42, (Object)result);
    }
}

