/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.Script;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LexicalTest {
    private void checkParse(JexlFeatures f, List<String> srcs, boolean expected) {
        JexlEngine jexl = new JexlBuilder().features(f).strict(true).create();
        for (String src : srcs) {
            if (src.isEmpty()) continue;
            try {
                JexlScript script = jexl.createScript(src);
                if (expected) continue;
                Assertions.fail((String)src);
            }
            catch (JexlException.Parsing xlexical) {
                if (!expected) continue;
                Assertions.fail((String)src);
            }
        }
    }

    private void checkParse(List<String> srcs, boolean expected) {
        this.checkParse(null, srcs, expected);
    }

    void runLexical0(boolean feature) {
        JexlFeatures f = new JexlFeatures();
        f.lexical(feature);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setLexical(true);
        this.runLexical0(jexl, ctxt, "var x = 0; var x = 1;", feature);
        this.runLexical0(jexl, ctxt, "var x = 0; for(var y : null) { var y = 1;", feature);
        this.runLexical0(jexl, ctxt, "var x = 0; for(var x : null) {};", feature);
        this.runLexical0(jexl, ctxt, "(x)->{ var x = 0; x; }", feature);
        this.runLexical0(jexl, ctxt, "var x; if (true) { if (true) { var x = 0; x; } }", feature);
        this.runLexical0(jexl, ctxt, "if (a) { var y = (x)->{ var x = 0; x; }; y(2) }", feature);
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> {
            JexlScript script = jexl.createScript("(x)->{ for(var x : null) { x; } }");
            if (!feature) {
                script.execute((JexlContext)ctxt, new Object[]{42});
            }
        });
        Assertions.assertNotNull((Object)xany.toString());
        JexlScript script = jexl.createScript("var x = 32; (()->{ for(var x : null) { x; }})();");
        if (!feature) {
            script.execute((JexlContext)ctxt, new Object[]{42});
        }
    }

    private void runLexical0(JexlEngine jexl, JexlEvalContext ctxt, String source, boolean feature) {
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> {
            JexlScript script = jexl.createScript(source);
            if (!feature) {
                script.execute((JexlContext)ctxt);
            }
        });
        Assertions.assertNotNull((Object)xany.toString());
    }

    void runLexical1(boolean shade) {
        block16: {
            JexlScript script;
            JexlEvalContext ctxt;
            JexlEngine jexl;
            block15: {
                block14: {
                    block13: {
                        jexl = new JexlBuilder().strict(true).create();
                        ctxt = new JexlEvalContext();
                        ctxt.set("x", 4242);
                        JexlOptions options = ctxt.getEngineOptions();
                        options.setLexical(true);
                        options.setLexicalShade(shade);
                        try {
                            script = jexl.createScript("{ var x = 0; } x");
                            script.execute((JexlContext)ctxt);
                            if (shade) {
                                Assertions.fail((String)"local shade means 'x' should be undefined");
                            }
                        }
                        catch (JexlException xany) {
                            if (shade) break block13;
                            throw xany;
                        }
                    }
                    try {
                        script = jexl.createScript("{ var x = 0; } x = 42");
                        script.execute((JexlContext)ctxt);
                        if (shade) {
                            Assertions.fail((String)"local shade means 'x = 42' should be undefined");
                        }
                    }
                    catch (JexlException xany) {
                        if (shade) break block14;
                        throw xany;
                    }
                }
                try {
                    script = jexl.createScript("{ var x = 0; } y = 42");
                    script.execute((JexlContext)ctxt);
                    if (shade) {
                        Assertions.fail((String)"local shade means 'y = 42' should be undefined (y is undefined)");
                    }
                }
                catch (JexlException xany) {
                    if (shade) break block15;
                    throw xany;
                }
            }
            script = jexl.createScript("var x = 32; (()->{ for(var x : null) { x; }})();");
            script.execute((JexlContext)ctxt, new Object[]{42});
            ctxt.set("y", 4242);
            try {
                script = jexl.createScript("{ var y = 0; } y = 42");
                Object result = script.execute((JexlContext)ctxt);
                if (!shade) {
                    Assertions.assertEquals((Object)42, (Object)result);
                } else {
                    Assertions.fail((String)"local shade means 'y = 42' should be undefined");
                }
            }
            catch (JexlException xany) {
                if (shade) break block16;
                throw xany;
            }
        }
    }

    protected void runLexical2(boolean lexical) {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(lexical).create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("{var x = 42}; {var x; return x; }");
        Object result = script.execute((JexlContext)ctxt);
        if (lexical) {
            Assertions.assertNull((Object)result);
        } else {
            Assertions.assertEquals((Object)42, (Object)result);
        }
    }

    void runTestScope(LexicalScope scope, int init, int count, int step) {
        int i;
        int size = (count - init) / step;
        for (i = init; i < count; i += step) {
            Assertions.assertTrue((boolean)scope.addSymbol(i));
            if (i % (step + 1) == 1) {
                Assertions.assertTrue((boolean)scope.addConstant(i));
            }
            Assertions.assertFalse((boolean)scope.addSymbol(i));
        }
        for (i = init; i < count; i += step) {
            Assertions.assertTrue((boolean)scope.hasSymbol(i));
            for (int s = 1; s < step; ++s) {
                Assertions.assertFalse((boolean)scope.hasSymbol(i + s));
            }
            if (i % (step + 1) != 1) continue;
            Assertions.assertTrue((boolean)scope.isConstant(i));
        }
        Assertions.assertEquals((int)size, (int)scope.getSymbolCount());
        BitSet collect = new BitSet();
        scope.clearSymbols(b -> collect.set(b));
        for (int i2 = init; i2 < count; i2 += step) {
            Assertions.assertTrue((boolean)collect.get(i2), (String)("missing " + i2));
        }
        Assertions.assertEquals((int)0, (int)scope.getSymbolCount());
    }

    private JexlFeatures runVarLoop(boolean flag, String src) {
        VarContext vars = new VarContext();
        JexlOptions options = vars.getEngineOptions();
        options.setLexical(true);
        options.setLexicalShade(true);
        options.setSafe(false);
        JexlFeatures features = new JexlFeatures();
        if (flag) {
            features.lexical(true).lexicalShade(true);
        }
        JexlEngine jexl = new JexlBuilder().features(features).create();
        JexlScript script = jexl.createScript(src);
        ArrayList out = new ArrayList(10);
        vars.set("$out", out);
        Object result = script.execute((JexlContext)vars);
        Assertions.assertEquals((Object)true, (Object)result);
        Assertions.assertEquals((int)10, (int)out.size());
        return features;
    }

    @Test
    public void testAnnotation() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("@scale(13) @test var i = 42");
        OptAnnotationContext jc = new OptAnnotationContext();
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCaptured0() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var x = 10; (b->{ x + b })(32)");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testCaptured1() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("{ var x = 10; } (b->{ x + b })(32)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)11);
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)43, (Object)result);
    }

    @Test
    public void testConst0a() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlScript script = jexl.createScript("{ const x = 10; x + 1 }; { let x = 20; x = 22}");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)22, (Object)result);
    }

    @Test
    public void testConst0b() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlScript script = jexl.createScript("{ const x = 10; }{ const x = 20; }");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)20, (Object)result);
    }

    @Test
    public void testConst1() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("const foo;  foo"), (String)"should fail, const foo must be followed by assign.");
        Assertions.assertTrue((boolean)xparse.getMessage().contains("const"));
    }

    @Test
    public void testConst2a() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        for (String op : Arrays.asList("=", "+=", "-=", "/=", "*=", "%=", "<<=", ">>=", ">>>=", "^=", "&=", "|=")) {
            JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("const foo = 42;  foo " + op + " 1;"), (String)"should fail, const precludes assignment");
            Assertions.assertTrue((boolean)xparse.getMessage().contains("foo"));
        }
    }

    @Test
    public void testConst2b() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        for (String op : Arrays.asList("=", "+=", "-=", "/=", "*=", "%=", "<<=", ">>=", ">>>=", "^=", "&=", "|=")) {
            JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("const foo = 42;  if (true) { foo " + op + " 1; }"), (String)"should fail, const precludes assignment");
            Assertions.assertTrue((boolean)xparse.getMessage().contains("foo"));
        }
    }

    @Test
    public void testConst2c() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        for (String op : Arrays.asList("=", "+=", "-=", "/=", "*=", "%=", "<<=", ">>=", ">>>=", "^=", "&=", "|=")) {
            JexlScript script = jexl.createScript("{ const foo = 42; } { let foo  = 0; foo " + op + " 1; }");
            Assertions.assertNotNull((Object)script);
        }
    }

    @Test
    public void testConst3a() {
        JexlEngine jexl = new JexlBuilder().create();
        List<String> srcs = Arrays.asList("const f = ()->{ var foo = 3; foo = 5; }", "const y = '42'; const f = (let y)->{ var foo = 3; foo = 5; }", "const foo = '34'; const f = ()->{ var foo = 3; foo = 5; };", "const bar = '34'; const f = ()->{ var f = 3; f = 5; };", "const bar = '34'; const f = ()->{ var bar = 3; z ->{ bar += z; } };");
        for (String src : srcs) {
            JexlScript script = jexl.createScript(src);
            Object result = script.execute(null);
            Assertions.assertNotNull((Object)result, (String)src);
        }
    }

    @Test
    public void testConst3b() {
        JexlEngine jexl = new JexlBuilder().create();
        List<String> srcs = Arrays.asList("const f = ()->{ var foo = 3; f = 5; }", "const y = '42'; const f = (let z)->{ y += z; }", "const foo = '34'; const f = ()->{ foo = 3; };", "const bar = '34'; const f = ()->{  bar = 3; z ->{ bar += z; } };", "let bar = '34'; const f = ()->{  const bar = 3; z ->{ bar += z; } };");
        for (String src : srcs) {
            JexlException.Assignment xassign = (JexlException.Assignment)Assertions.assertThrows(JexlException.Assignment.class, () -> jexl.createScript(src), (String)src);
            Assertions.assertNotNull((Object)xassign, (String)src);
        }
    }

    @Test
    public void testConstCaptures() {
        List<String> srcsFalse = Arrays.asList("const x = 0;  x = 1;", "const x = 0; x *= 1;", "const x = 0; var x = 1;", "const x = 0; if (true) { var x = 1;}", "const x = 0; if (true) { x = 1;}", "const x = 0; if (true) { var f  = y -> { x = y + 1; x } }", "const x = 0; if (true) { var f  = y -> { z -> { x = y + 1; x } } }", "const x = 0; if (true) { if (false) { y -> { x = y + 1; x } } }", "const x = 0; if (true) { if (false) { y -> { z -> { x = y + 1; x } } }", "");
        this.checkParse(srcsFalse, false);
        List<String> srcsTrue = Arrays.asList("const x = 0; if (true) { var f  = x -> x + 1;}", "const x = 0; if (true) { var f  = y -> { var x = y + 1; x } }", "const x = 0; if (true) { var f  = y -> { const x = y + 1; x } }", "const x = 0; if (true) { var f  = y -> { z -> { let x = y + 1; x } } }", "");
        this.checkParse(srcsTrue, true);
    }

    @Test
    public void testContextualOptions0() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().features(f).strict(true).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSharedInstance(false);
        options.setLexical(true);
        options.setLexicalShade(true);
        ctxt.set("options", options);
        JexlScript script = jexl.createScript("{var x = 42;} options.lexical = false; options.lexicalShade=false; x");
        Assertions.assertThrows(JexlException.class, () -> script.execute((JexlContext)ctxt), (String)"setting options.lexical should have no effect during execution");
    }

    @Test
    public void testContextualOptions1() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().features(f).strict(true).create();
        TestContext ctxt = new TestContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSharedInstance(true);
        options.setLexical(true);
        options.setLexicalShade(true);
        ctxt.set("options", options);
        JexlScript runner = jexl.createScript("options.lexical = flag; options.lexicalShade = flag;tryCatch(test, catcher, 42);", new String[]{"flag", "test", "catcher"});
        JexlScript tested = jexl.createScript("(y)->{ {var x = y;} x }");
        JexlScript catchFn = jexl.createScript("(xany)-> { xany }");
        Object result = runner.execute((JexlContext)ctxt, new Object[]{false, tested, catchFn});
        Assertions.assertEquals((Object)42, (Object)result);
        result = runner.execute((JexlContext)ctxt, new Object[]{true, tested, catchFn});
        Assertions.assertTrue((boolean)(result instanceof JexlException.Variable));
    }

    @Test
    public void testForVariable0a() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("for(let x : 1..3) { let c = 0}; return x", new String[]{"Should not have been parsed"}));
    }

    @Test
    public void testForVariable0b() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("for(var x : 1..3) { var c = 0}; return x", new String[]{"Should not have been parsed"}));
    }

    @Test
    public void testForVariable1a() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("for(var x : 1..3) { var c = 0} for(var x : 1..3) { var c = 0}; return x"), (String)"Should not have been parsed");
    }

    @Test
    public void testForVariable1b() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("for(let x : 1..3) { let c = 0} for(let x : 1..3) { var c = 0}; return x"), (String)"Should not have been parsed");
    }

    @Test
    public void testInnerAccess0() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var x = 32; (()->{ for(var x : null) { var c = 0; {return x; }} })();");
        Assertions.assertNull((Object)script.execute(null));
    }

    @Test
    public void testInnerAccess1a() {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript script = jexl.createScript("var x = 32; (()->{ for(var x : null) { var c = 0; {return x; }} })();");
        Assertions.assertNotNull((Object)script);
    }

    @Test
    public void testInnerAccess1b() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlScript script = jexl.createScript("let x = 32; (()->{ for(let x : null) { let c = 0; { return x; } } } )(); ");
        Assertions.assertNotNull((Object)script);
        String dbg = JexlTestCase.toString(script);
        String src = script.getSourceText();
        Assertions.assertTrue((boolean)JexlTestCase.equalsIgnoreWhiteSpace(src, dbg));
    }

    @Test
    public void testInternalLexicalFeatures() {
        String str = "42";
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = new JexlBuilder().features(f).create();
        JexlScript e = jexl.createScript("42");
        VarContext vars = new VarContext();
        JexlOptions opts = vars.getEngineOptions();
        opts.setSharedInstance(true);
        Script script = (Script)e;
        JexlFeatures features = script.getFeatures();
        Assertions.assertTrue((boolean)features.isLexical());
        Assertions.assertTrue((boolean)features.isLexicalShade());
        Object result = e.execute((JexlContext)vars);
        Assertions.assertEquals((Object)42, (Object)result);
        Assertions.assertTrue((boolean)opts.isLexical());
        Assertions.assertTrue((boolean)opts.isLexicalShade());
    }

    @Test
    public void testLet0() {
        JexlFeatures f = new JexlFeatures();
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlScript script = jexl.createScript("{ let x = 10; } (b->{ x + b })(32)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)11);
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)43, (Object)result);
    }

    @Test
    public void testLetFail() {
        List<String> srcs = Arrays.asList("let x = 0; var x = 1;", "var x = 0; let x = 1;", "let x = 0; let x = 1;", "var x = 0; const f = (var x) -> { let x = 1; } f()", "var x = 0; const f = (let x) -> { let x = 1; } f()", "var x = 0; const f = (let x) -> { var x = 1; } f()", "");
        this.checkParse(srcs, false);
    }

    @Test
    public void testLetSucceed() {
        List<String> srcs = Arrays.asList("var x = 1; var x = 0;", "{ let x = 0; } var x = 1;", "var x = 0; var f = () -> { let x = 1; } f()", "var x = 0; var f = (let x) -> { x = 1; } f()", "var x = 0; let f = (let x) -> { x = 1; } f()", "var x = 0; const f = (let x) -> { x = 1; } f()", "");
        this.checkParse(srcs, true);
    }

    @Test
    public void testLexical0a() {
        this.runLexical0(false);
    }

    @Test
    public void testLexical0b() {
        this.runLexical0(true);
    }

    @Test
    public void testLexical1() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setLexical(true);
        JexlScript script = jexl.createScript("var x = 0; for(var y : [1]) { var x = 42; return x; };");
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> script.execute((JexlContext)ctxt));
        Assertions.assertNotNull((Object)xany.toString());
        JexlScript script1 = jexl.createScript("(x)->{ if (x) { var x = 7 * (x + x); x; } }");
        xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> script.execute((JexlContext)ctxt, new Object[]{3}));
        Assertions.assertNotNull((Object)xany.toString());
        JexlScript script3 = jexl.createScript("{ var x = 0; } var x = 42; x");
        Object result = script3.execute((JexlContext)ctxt, new Object[]{21});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLexical1a() {
        this.runLexical1(false);
    }

    @Test
    public void testLexical1b() {
        this.runLexical1(true);
    }

    @Test
    public void testLexical2a() {
        this.runLexical2(true);
    }

    @Test
    public void testLexical2b() {
        this.runLexical2(false);
    }

    @Test
    public void testLexical3() {
        String str = "var s = {}; for (var i : [1]) s.add(i); s";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript e = jexl.createScript("var s = {}; for (var i : [1]) s.add(i); s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertTrue((boolean)((Set)o).contains(1));
        e = jexl.createScript("var s = {}; for (var i : [1]) s.add(i); s");
        o = e.execute((JexlContext)jc);
        Assertions.assertTrue((boolean)((Set)o).contains(1));
    }

    @Test
    public void testLexical4() {
        JexlEngine Jexl2 = new JexlBuilder().silent(false).strict(true).lexical(true).create();
        JxltEngine Jxlt = Jexl2.createJxltEngine();
        MapContext ctxt = new MapContext();
        String rpt = "<report>\n\n$$var y = 1; var x = 2;\n${x + y}\n</report>\n";
        JxltEngine.Template t = Jxlt.createTemplate("$$", (Reader)new StringReader("<report>\n\n$$var y = 1; var x = 2;\n${x + y}\n</report>\n"), new String[0]);
        StringWriter strw = new StringWriter();
        t.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = strw.toString();
        String ctl = "<report>\n\n3\n</report>\n";
        Assertions.assertEquals((Object)"<report>\n\n3\n</report>\n", (Object)output);
    }

    @Test
    public void testLexical5() {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        DebugContext ctxt = new DebugContext();
        JexlScript script = jexl.createScript("var x = 42; var y = () -> { {var x = debug(-42); }; return x; }; y()");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLexical6a() {
        String str = "i = 0; { var i = 32; }; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testLexical6a1() {
        String str = "i = 0; { var i = 32; }; i";
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testLexical6b() {
        String str = "i = 0; { var i = 32; }; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(true).create();
        JexlScript e = jexl.createScript("i = 0; { var i = 32; }; i");
        MapContext ctxt = new MapContext();
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> LexicalTest.lambda$testLexical6b$14(e, (JexlContext)ctxt), (String)"i should be shaded");
        Assertions.assertNotNull((Object)xany.toString());
    }

    @Test
    public void testLexical6c() {
        String str = "i = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(false).create();
        JexlScript e = jexl.createScript("i = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        Object o = e.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)0, (Object)o);
    }

    @Test
    public void testLexical6d() {
        String str = "i = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).lexicalShade(true).create();
        JexlScript e = jexl.createScript("i = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> LexicalTest.lambda$testLexical6d$15(e, (JexlContext)ctxt), (String)"i should be shaded");
        Assertions.assertNotNull((Object)xany.toString());
    }

    @Test
    public void testManyConst() {
        String text = "const x = 1, y = 41; x + y";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("const x = 1, y = 41; x + y");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        String s0 = script.getParsedText();
        String s1 = script.getSourceText();
        Assertions.assertNotEquals((Object)s0, (Object)s1);
    }

    @Test
    public void testManyLet() {
        String text = "let x = 1, y = 41, z; x + y";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("let x = 1, y = 41, z; x + y");
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
        String s0 = script.getParsedText();
        String s1 = script.getSourceText();
        Assertions.assertNotEquals((Object)s0, (Object)s1);
    }

    @Test
    public void testNamed() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        JexlEngine jexl = new JexlBuilder().strict(true).features(f).create();
        JexlScript script = jexl.createScript("var i = (x, y, z)->{return x + y + z}; i(22,18,2)");
        MapContext jc = new MapContext();
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionsPragma() {
        try {
            JexlOptions.setDefaultFlags((String[])new String[]{"+safe", "-lexical", "-lexicalShade"});
            VarContext vars = new VarContext();
            JexlEngine jexl = new JexlBuilder().create();
            int n42 = (Integer)jexl.createScript("#pragma jexl.options none\n-42").execute((JexlContext)vars);
            Assertions.assertEquals((int)-42, (int)n42);
            JexlOptions o = vars.snatchOptions();
            Assertions.assertNotNull((Object)o);
            Assertions.assertTrue((boolean)o.isStrict());
            Assertions.assertTrue((boolean)o.isSafe());
            Assertions.assertTrue((boolean)o.isCancellable());
            Assertions.assertFalse((boolean)o.isLexical());
            Assertions.assertFalse((boolean)o.isLexicalShade());
            n42 = (Integer)jexl.createScript("#pragma jexl.options canonical\n42").execute((JexlContext)vars);
            Assertions.assertEquals((int)42, (int)n42);
            o = vars.snatchOptions();
            Assertions.assertNotNull((Object)o);
            Assertions.assertTrue((boolean)o.isStrict());
            Assertions.assertFalse((boolean)o.isSafe());
            Assertions.assertTrue((boolean)o.isCancellable());
            Assertions.assertTrue((boolean)o.isLexical());
            Assertions.assertTrue((boolean)o.isLexicalShade());
            Assertions.assertFalse((boolean)o.isSharedInstance());
        }
        catch (Throwable throwable) {
            JexlOptions.setDefaultFlags((String[])new String[]{"-safe", "+lexical"});
            throw throwable;
        }
        JexlOptions.setDefaultFlags((String[])new String[]{"-safe", "+lexical"});
    }

    @Test
    public void testParameter0() {
        String str = "function(u) {}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("function(u) {}");
        Assertions.assertEquals((int)1, (int)e.getParameters().length);
        e = jexl.createScript(new JexlInfo("TestScript", 1, 1), "function(u) {}", new String[0]);
        Assertions.assertEquals((int)1, (int)e.getParameters().length);
    }

    @Test
    public void testParameter1() {
        JexlEngine jexl = new JexlBuilder().strict(true).lexical(true).create();
        MapContext jc = new MapContext();
        String strs = "var s = function(x) { for (var i : 1..3) {if (i > 2) return x}}; s(42)";
        JexlScript s42 = jexl.createScript("var s = function(x) { for (var i : 1..3) {if (i > 2) return x}}; s(42)");
        Object result = s42.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testPragmaNoop() {
        String str = "#pragma jexl.options 'no effect'\ni = -42; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().lexical(false).strict(true).create();
        JexlScript e = jexl.createScript("#pragma jexl.options 'no effect'\ni = -42; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        Object result = e.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testPragmaOptions() {
        String str = "#pragma jexl.options '+strict +lexical +lexicalShade -safe'\ni = 0; for (var i : [42]) i; i";
        JexlEngine jexl = new JexlBuilder().strict(false).create();
        JexlScript e = jexl.createScript("#pragma jexl.options '+strict +lexical +lexicalShade -safe'\ni = 0; for (var i : [42]) i; i");
        MapContext ctxt = new MapContext();
        JexlException xany = (JexlException)Assertions.assertThrows(JexlException.class, () -> LexicalTest.lambda$testPragmaOptions$16(e, (JexlContext)ctxt), (String)"i should be shaded");
        Assertions.assertNotNull((Object)xany.toString());
    }

    @Test
    public void testScopeFrame() {
        LexicalScope scope = new LexicalScope();
        this.runTestScope(scope, 0, 128, 2);
        this.runTestScope(scope, 33, 55, 1);
        this.runTestScope(scope, 15, 99, 3);
        this.runTestScope(scope, 3, 123, 5);
    }

    @Test
    public void testSingleStatementDeclFail() {
        List<String> srcs = Arrays.asList("if (true) let x ;", "if (true) let x = 1;", "if (true) var x = 1;", "if (true) { 1 } else let x ;", "if (true) { 1 } else let x = 1;", "if (true) { 1 } else var x = 1;", "while (true) let x ;", "while (true) let x = 1;", "while (true) var x = 1;", "do let x ; while (true)", "do let x = 1; while (true)", "do var x = 1; while (true)", "for (let i:ii) let x ;", "for (let i:ii) let x = 1;", "for (let i:ii) var x = 1;", "");
        JexlFeatures f = new JexlFeatures();
        f.lexical(true).lexicalShade(true);
        this.checkParse(f, srcs, false);
    }

    @Test
    public void testSingleStatementVarSucceed() {
        List<String> srcs = Arrays.asList("if (true) var x = 1;", "if (true) { 1 } else var x = 1;", "while (true) var x = 1;", "do var x = 1 while (true)", "for (let i:ii) var x = 1;", "");
        this.checkParse(srcs, true);
    }

    @Test
    public void testUndeclaredVariable() {
        JexlFeatures f = new JexlFeatures();
        f.lexical(true);
        f.lexicalShade(true);
        JexlEngine jexl = JexlTestCase.createEngine(f);
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("{var x = 0}; return x"), (String)"Should not have been parsed");
    }

    @Test
    public void testVarFail() {
        List<String> srcs = Arrays.asList("var x = 0; var x = 1;", "var x = 0; let x = 1;", "let x = 0; var x = 1;", "var x = 0; const f = (var x) -> { let x = 1; } f()", "var x = 0; const f = (let x) -> { var x = 1; } f()", "var x = 0; const f = (var x) -> { var x = 1; } f()", "");
        JexlFeatures f = new JexlFeatures();
        f.lexical(true).lexicalShade(true);
        this.checkParse(f, srcs, false);
    }

    @Test
    public void testVarLoop0() {
        String src0 = "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}";
        String src1 = "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}";
        String src2 = "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9";
        JexlFeatures ff0 = this.runVarLoop(false, "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}");
        JexlFeatures ft0 = this.runVarLoop(true, "var count = 10;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n}");
        JexlFeatures ff1 = this.runVarLoop(false, "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}");
        JexlFeatures ft1 = this.runVarLoop(true, "var count = [0,1,2,3,4,5,6,7,8,9];\nfor (var i : count) {\n  $out.add(i);\n}");
        JexlFeatures ff2 = this.runVarLoop(false, "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9");
        JexlFeatures ft2 = this.runVarLoop(true, "var count = 10;\n  var outer = 0;\nfor (var i : 0 .. count-1) {\n  $out.add(i);\n  outer = i;}\nouter == 9");
        Assertions.assertEquals((Object)ff0, (Object)ff1);
        Assertions.assertEquals((Object)ft0, (Object)ft1);
        Assertions.assertNotEquals((Object)ff0, (Object)ft0);
        String sff0 = ff0.toString();
        String sff1 = ff1.toString();
        Assertions.assertEquals((Object)sff0, (Object)sff1);
        String sft1 = ft1.toString();
        Assertions.assertNotEquals((Object)sff0, (Object)sft1);
    }

    private static /* synthetic */ void lambda$testPragmaOptions$16(JexlScript e, JexlContext ctxt) throws Throwable {
        e.execute(ctxt);
    }

    private static /* synthetic */ void lambda$testLexical6d$15(JexlScript e, JexlContext ctxt) throws Throwable {
        e.execute(ctxt);
    }

    private static /* synthetic */ void lambda$testLexical6b$14(JexlScript e, JexlContext ctxt) throws Throwable {
        e.execute(ctxt);
    }

    public static class VarContext
    extends MapContext
    implements JexlContext.PragmaProcessor,
    JexlContext.OptionsHandle {
        private JexlOptions options = new JexlOptions();

        public JexlOptions getEngineOptions() {
            return this.options;
        }

        public void processPragma(String key, Object value) {
            if ("jexl.options".equals(key) && "canonical".equals(value)) {
                this.options.setStrict(true);
                this.options.setLexical(true);
                this.options.setLexicalShade(true);
                this.options.setSafe(false);
            }
        }

        JexlOptions snatchOptions() {
            JexlOptions o = this.options;
            this.options = new JexlOptions();
            return o;
        }
    }

    public static class OptAnnotationContext
    extends JexlEvalContext
    implements JexlContext.AnnotationProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processAnnotation(String name, Object[] args, Callable<Object> statement) throws Exception {
            if ("scale".equals(name)) {
                JexlOptions options = this.getEngineOptions();
                int scale = options.getMathScale();
                int newScale = (Integer)args[0];
                options.setMathScale(newScale);
                try {
                    Object object = statement.call();
                    return object;
                }
                finally {
                    options.setMathScale(scale);
                }
            }
            return statement.call();
        }
    }

    public static class TestContext
    extends JexlEvalContext {
        public TestContext() {
        }

        public TestContext(Map<String, Object> map) {
            super(map);
        }

        public Object tryCatch(JexlScript tryFn, JexlScript catchFn, Object ... args) {
            Object result;
            try {
                result = tryFn.execute((JexlContext)this, args);
            }
            catch (Throwable xthrow) {
                result = catchFn != null ? catchFn.execute((JexlContext)this, new Object[]{xthrow}) : xthrow;
            }
            return result;
        }
    }

    public static class DebugContext
    extends MapContext {
        public Object debug(Object arg) {
            return arg;
        }
    }
}

