/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MapLiteralTest
extends JexlTestCase {
    public MapLiteralTest() {
        super("MapLiteralTest");
    }

    @Test
    public void testCallingMethodsOnNewMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' : 'bar' }.values())");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
    }

    @Test
    public void testEmptyMap() throws Exception {
        JexlScript script = this.JEXL.createScript("map['']", new String[]{"map"});
        Object result = script.execute(null, new Object[]{Collections.singletonMap("", 42)});
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testLiteralWithMultipleEntries() throws Exception {
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("foo", "bar");
        expected.put("eat", "food");
        List<String> sources = Arrays.asList("{ 'foo' : 'bar', 'eat' : 'food' }", "{ 'foo' : 'bar', 'eat' : 'food', }");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression("{ 'foo' : 'bar', 'eat' : 'food' }");
            Object o = e.evaluate(null);
            Assertions.assertEquals(expected, (Object)o);
        }
    }

    @Test
    public void testLiteralWithNumbers() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{ 5 : 10 }");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals(Collections.singletonMap(5, 10), (Object)o);
        e = this.JEXL.createExpression("m = { 3 : 30, 4 : 40, 5 : 'fifty', '7' : 'seven', 7 : 'SEVEN' }");
        e.evaluate((JexlContext)jc);
        e = this.JEXL.createExpression("m.3");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)30, (Object)o);
        e = this.JEXL.createExpression("m[4]");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)40, (Object)o);
        jc.set("i", (Object)5);
        e = this.JEXL.createExpression("m[i]");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"fifty", (Object)o);
        e = this.JEXL.createExpression("m.3 = 'thirty'");
        e.evaluate((JexlContext)jc);
        e = this.JEXL.createExpression("m.3");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"thirty", (Object)o);
        e = this.JEXL.createExpression("m['7']");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"seven", (Object)o);
        e = this.JEXL.createExpression("m.7");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"SEVEN", (Object)o);
        jc.set("k", (Object)7);
        e = this.JEXL.createExpression("m[k]");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"SEVEN", (Object)o);
        jc.set("k", (Object)"7");
        e = this.JEXL.createExpression("m[k]");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"seven", (Object)o);
    }

    @Test
    public void testLiteralWithStrings() throws Exception {
        List<String> sources = Arrays.asList("{ 'foo' : 'bar' }", "{ 'foo' : 'bar', }");
        for (String src : sources) {
            JexlExpression e = this.JEXL.createExpression(src);
            Object o = e.evaluate(null);
            Assertions.assertEquals(Collections.singletonMap("foo", "bar"), (Object)o);
        }
        Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createExpression("{  : , }"));
    }

    @Test
    public void testMapArrayLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{'foo' : [ 'inner' , 'bar' ]}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertNotNull((Object)o);
        jc.set("outer", o);
        e = this.JEXL.createExpression("outer.foo.1");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"bar", (Object)o);
    }

    @Test
    public void testMapMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("{'foo' : { 'inner' : 'bar' }}");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertNotNull((Object)o);
        jc.set("outer", o);
        e = this.JEXL.createExpression("outer.foo.inner");
        o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)"bar", (Object)o);
    }

    @Test
    public void testNotEmptySimpleMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("empty({ 'foo' : 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertFalse((boolean)((Boolean)o));
    }

    @Test
    public void testSizeOfSimpleMapLiteral() throws Exception {
        JexlExpression e = this.JEXL.createExpression("size({ 'foo' : 'bar' })");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o);
    }

    @Test
    public void testVariableMap() throws Exception {
        JexlScript script = this.JEXL.createScript("{ ['1', '2'.toString()] : someValue }", new String[]{"someValue"});
        Object result = script.execute(null, new Object[]{42});
        Assertions.assertTrue((boolean)(result instanceof Map));
        Object key = null;
        Object value = null;
        Iterator iterator = ((Map)result).entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            key = e.getKey();
            value = e.getValue();
        }
        Object gg = ((Map)result).get(key);
        Assertions.assertEquals((int)42, (int)((Number)gg).intValue());
        Assertions.assertEquals(value, (Object)((Number)gg).intValue());
    }
}

