/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collection;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RangeTest
extends JexlTestCase {
    public RangeTest() {
        super("RangeTest");
    }

    @Test
    public void testIntegerContains() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ x =~ (1..10) }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{5});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{0});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{100});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)o);
    }

    @Test
    public void testIntegerRange() throws Exception {
        int l;
        JexlExpression e = this.JEXL.createExpression("(1..32)");
        MapContext jc = new MapContext();
        Object o0 = e.evaluate((JexlContext)jc);
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assertions.assertEquals((int)32, (int)c.size());
        Assertions.assertNotSame((Object)o0, (Object)o);
        Assertions.assertEquals((int)o0.hashCode(), (int)o.hashCode());
        Assertions.assertEquals((Object)o0, (Object)o);
        int i = 0;
        for (Object v : c) {
            Assertions.assertEquals((int)(++i), (int)((Number)v).intValue());
        }
        Assertions.assertEquals((int)32, (int)i);
        Integer[] aa = c.toArray(new Integer[32]);
        Assertions.assertEquals((int)32, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((int)aa[l], (int)(l + 1));
        }
        aa = c.toArray(new Integer[2]);
        Assertions.assertEquals((int)32, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((int)aa[l], (int)(l + 1));
        }
        aa = c.toArray(new Integer[34]);
        Assertions.assertEquals((int)34, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((int)aa[l], (int)(l + 1));
        }
        Object[] oaa = c.toArray();
        Assertions.assertEquals((int)32, (int)oaa.length);
        for (int l2 = 0; l2 < 32; ++l2) {
            Assertions.assertEquals((Object)oaa[l2], (Object)(l2 + 1));
        }
    }

    @Test
    public void testIntegerRangeOne() throws Exception {
        JexlExpression e = this.JEXL.createExpression("(1..1)");
        MapContext jc = new MapContext();
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assertions.assertEquals((int)1, (int)c.size());
        Object[] a = c.toArray();
        Assertions.assertEquals((int)1, (int)a.length);
        Assertions.assertEquals((int)1, (int)((Number)a[0]).intValue());
        Assertions.assertFalse((boolean)((Boolean)this.JEXL.createScript("empty x", new String[]{"x"}).execute(null, new Object[]{e})));
    }

    @Test
    public void testIntegerSum() throws Exception {
        JexlScript e = this.JEXL.createScript("var s = 0; for(var i : (1..5)) { s = s + i; }; s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((int)15, (int)((Number)o).intValue());
    }

    @Test
    public void testLongContains() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ x =~ (90000000001L..90000000010L) }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc, new Object[]{90000000005L});
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{0});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)o);
        o = e.execute((JexlContext)jc, new Object[]{90000000011L});
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)o);
    }

    @Test
    public void testLongRange() throws Exception {
        int l;
        JexlExpression e = this.JEXL.createExpression("(6789000001L..6789000032L)");
        MapContext jc = new MapContext();
        Object o0 = e.evaluate((JexlContext)jc);
        Object o = e.evaluate((JexlContext)jc);
        Assertions.assertTrue((boolean)(o instanceof Collection));
        Collection c = (Collection)o;
        Assertions.assertEquals((int)32, (int)c.size());
        Assertions.assertFalse((boolean)((Boolean)this.JEXL.createScript("empty x", new String[]{"x"}).execute(null, new Object[]{e})));
        Assertions.assertNotSame((Object)o0, (Object)o);
        Assertions.assertEquals((int)o0.hashCode(), (int)o.hashCode());
        Assertions.assertEquals((Object)o0, (Object)o);
        long i = 6789000000L;
        for (Object v : c) {
            Assertions.assertEquals((long)(++i), (long)((Number)v).longValue());
        }
        Assertions.assertEquals((long)6789000032L, (long)i);
        Long[] aa = c.toArray(new Long[32]);
        Assertions.assertEquals((int)32, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        aa = c.toArray(new Long[2]);
        Assertions.assertEquals((int)32, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        aa = c.toArray(new Long[34]);
        Assertions.assertEquals((int)34, (int)aa.length);
        for (l = 0; l < 32; ++l) {
            Assertions.assertEquals((long)aa[l], (long)(6789000001L + (long)l));
        }
        Object[] oaa = c.toArray();
        Assertions.assertEquals((int)32, (int)oaa.length);
        for (int l2 = 0; l2 < 32; ++l2) {
            Assertions.assertEquals((Object)oaa[l2], (Object)(6789000001L + (long)l2));
        }
    }

    @Test
    public void testLongSum() throws Exception {
        JexlScript e = this.JEXL.createScript("var s = 0; for(var i : (6789000001L..6789000001L)) { s = s + i; }; s");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((long)6789000001L, (long)((Number)o).longValue());
    }
}

