/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TryCatchFinallyTest
extends JexlTestCase {
    public TryCatchFinallyTest() {
        super(TryCatchFinallyTest.class.getSimpleName());
    }

    @Test
    public void testCloseable0x2b() {
        String src = "try(let x = c) { c.isOpened()? 42 : -42; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(let x = c) { c.isOpened()? 42 : -42; } finally { 169; }", new String[]{"c"});
        Circuit circuit = new Circuit();
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null, new Object[]{circuit});
        Assertions.assertEquals((Object)42, (Object)result);
        Assertions.assertFalse((boolean)circuit.isOpened());
    }

    @Test
    public void testCloseable0x3b() {
        String src = "try(let x = c) { c.raiseError(); -42; } catch(const y) { 42; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(let x = c) { c.raiseError(); -42; } catch(const y) { 42; } finally { 169; }", new String[]{"c"});
        Circuit circuit = new Circuit();
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null, new Object[]{circuit});
        Assertions.assertEquals((Object)42, (Object)result);
        Assertions.assertFalse((boolean)circuit.isOpened());
    }

    @Disabled
    public void testEdgeTry() throws Exception {
        int i = 0;
        while (i++ < 5) {
            try {
                throw new JexlException.Continue(null);
            }
            catch (Throwable throwable) {
            }
        }
        Circuit x = new Circuit();
        x.close();
    }

    @Test
    public void testExceptionType() throws Exception {
        JexlScript e = this.JEXL.createScript("try { 'asb'.getBytes('NoSuchCharacterSet'); } catch (let ex) { ex }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertTrue((boolean)(o instanceof UnsupportedEncodingException));
    }

    @Test
    public void testForm0x2a() {
        String src = "try(let x = 42) { x; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { x; } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testForm0x2b() {
        String src = "try(let x = 19, y = 23) { x + y; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(let x = 19, y = 23) { x + y; } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testForm0x2c() {
        String src = "try(const x = 19; let y = 23; ) { x + y; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(const x = 19; let y = 23; ) { x + y; } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testForm0x2d() {
        String src = "try(var x = 19; const y = 23;) { x + y; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(var x = 19; const y = 23;) { x + y; } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testRedefinition0() {
        String src = "try(let x = c) { let x = 3; -42; }";
        JexlException.Parsing xvar = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("try(let x = c) { let x = 3; -42; }", new String[]{"c"}));
        Assertions.assertTrue((boolean)xvar.getMessage().contains("x: variable is already declared"));
    }

    @Test
    public void testRedefinition1() {
        String src = "const x = 33; try(let x = c) { 169; }";
        JexlException.Parsing xvar = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> this.JEXL.createScript("const x = 33; try(let x = c) { 169; }", new String[]{"c"}));
        Assertions.assertTrue((boolean)xvar.getMessage().contains("x: variable is already declared"));
    }

    @Test
    public void testStandard0x2() {
        String src = "try { 42; } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try { 42; } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testThrow0x2a() {
        String src = "try(let x = 42) { throw x } finally { 169; }";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { throw x } finally { 169; }");
        Assertions.assertNotNull((Object)script);
        JexlException.Throw xthrow = (JexlException.Throw)Assertions.assertThrows(JexlException.Throw.class, () -> script.execute(null));
        Assertions.assertEquals((Object)42, (Object)xthrow.getValue());
    }

    @Test
    public void testThrow0x2b() {
        String src = "try(let x = 42) { throw x } finally { throw 169 }";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { throw x } finally { throw 169 }");
        Assertions.assertNotNull((Object)script);
        JexlException.Throw xthrow = (JexlException.Throw)Assertions.assertThrows(JexlException.Throw.class, () -> script.execute(null));
        Assertions.assertEquals((Object)169, (Object)xthrow.getValue());
    }

    @Test
    public void testThrowCatchBreakFinallyContinue() {
        String src = "let r = 0; for(let i : 37..42) { try(let x = 169) { r = i; throw -x } catch(const y) { break } finally { continue } } r";
        JexlScript script = this.JEXL.createScript("let r = 0; for(let i : 37..42) { try(let x = 169) { r = i; throw -x } catch(const y) { break } finally { continue } } r");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testThrowCatchContinueFinallyBreak() {
        String src = "let r = 0; for(let i : 42..37) { try(let x = 169) { r = i; throw -x } catch(const y) { continue } finally { break } } r";
        JexlScript script = this.JEXL.createScript("let r = 0; for(let i : 42..37) { try(let x = 169) { r = i; throw -x } catch(const y) { continue } finally { break } } r");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testThrowCatchThrow() {
        String src = "try(let x = 42) { throw x } catch(const y) { throw -(y.value) } ";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { throw x } catch(const y) { throw -(y.value) } ");
        Assertions.assertNotNull((Object)script);
        JexlException.Throw xthrow = (JexlException.Throw)Assertions.assertThrows(JexlException.Throw.class, () -> script.execute(null));
        Assertions.assertEquals((Object)-42, (Object)xthrow.getValue());
    }

    @Test
    public void testThrowCatchThrowFinallyThrow() {
        String src = "try(let x = 42) { throw x } catch(const y) { throw -(y.value) } finally { throw 169 }";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { throw x } catch(const y) { throw -(y.value) } finally { throw 169 }");
        Assertions.assertNotNull((Object)script);
        JexlException.Throw xthrow = (JexlException.Throw)Assertions.assertThrows(JexlException.Throw.class, () -> script.execute(null));
        Assertions.assertEquals((Object)169, (Object)xthrow.getValue());
    }

    @Test
    public void testThrowRecurse() {
        String src = "function fact(x, f) { if (x == 1) throw f; fact(x - 1, f * x); } fact(7, 1);";
        JexlScript script = this.JEXL.createScript("function fact(x, f) { if (x == 1) throw f; fact(x - 1, f * x); } fact(7, 1);");
        Assertions.assertNotNull((Object)script);
        JexlException.Throw xthrow = (JexlException.Throw)Assertions.assertThrows(JexlException.Throw.class, () -> script.execute(null));
        Assertions.assertEquals((Object)5040, (Object)xthrow.getValue());
    }

    @Test
    public void testTryReturn() {
        String src = "try(let x = 42) { return x } catch(const y) { throw -(y.value) } ";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { return x } catch(const y) { throw -(y.value) } ");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testTryReturnFinallyReturn() {
        String src = "try(let x = 42) { return x } finally { return 169 } ";
        JexlScript script = this.JEXL.createScript("try(let x = 42) { return x } finally { return 169 } ");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)169, (Object)result);
    }

    public static class Circuit
    implements AutoCloseable {
        boolean opened = true;

        @Override
        public void close() throws IOException {
            this.opened = false;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public void raiseError() {
            throw new RuntimeException("raising error");
        }
    }
}

